/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA.Issues;

import com.geteasyqa.EasyQA.API.GetResponse;
import com.geteasyqa.EasyQA.API.Initialization;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public class GetIssues
extends Initialization {
    public GetIssues(String url) {
        super(url);
    }

    public Map<String, String> getIssueList(String token, String auth_token) throws IOException, JSONException {
        Call<ResponseBody> call = this.easyqaUserAPI.getIssueList(token, auth_token);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        Map<String, String> issues = new GetResponse().getMapString(result, "id", "summary");
        return issues;
    }

    public JSONObject getIssueInfoWithMobileBuild(String token, String packageName, String buildVersionCode, String buildVersionName) throws IOException, JSONException {
        JsonObject cred = new JsonObject();
        cred.addProperty("token", token);
        cred.addProperty("packageName", packageName);
        cred.addProperty("buildVersionCode", buildVersionCode);
        cred.addProperty("buildVersionName", buildVersionName);
        Call<ResponseBody> call = this.easyqaUserAPI.getIssueWithMobileBuild(cred);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        JSONObject jsonObject = new JSONObject(result);
        return jsonObject;
    }

    public JSONObject getIssueInfoWithSite(String token, String auth_token, String link) throws IOException, JSONException {
        JsonObject cred = new JsonObject();
        cred.addProperty("token", token);
        cred.addProperty("auth_token", auth_token);
        cred.addProperty("link", link);
        Call<ResponseBody> call = this.easyqaUserAPI.getIssueWithSite(cred);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        JSONObject jsonObject = new JSONObject(result);
        return jsonObject;
    }

    public JSONObject getIssueByUniqueID(String token, String auth_token, String id) throws IOException, JSONException {
        Call<ResponseBody> call = this.easyqaUserAPI.getIssueByID(id, token, auth_token);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        JSONObject jsonObject = new JSONObject(result);
        return jsonObject;
    }

    public JSONObject getIssueByProjectID(String token, String auth_token, String id) throws IOException, JSONException {
        Call<ResponseBody> call = this.easyqaUserAPI.getIssueByIDInProject(id, token, auth_token);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        JSONObject jsonObject = new JSONObject(result);
        return jsonObject;
    }
}

