/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA.API;

import com.google.gson.JsonObject;
import java.util.Map;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface EasyQAAPI {
    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/projects/members_list")
    public Call<ResponseBody> getMembersList(@Query(value="token") String var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/users/show")
    public Call<ResponseBody> getUserByEmail(@Query(value="email") String var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/users/show")
    public Call<ResponseBody> getUserByID(@Query(value="id") String var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/organization/members")
    public Call<ResponseBody> getOrgMembersListByOrgID(@Query(value="organization_id") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/organization/members")
    public Call<ResponseBody> getOrgMembersListByOrgTitle(@Query(value="organization_title") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/sign_in")
    public Call<ResponseBody> signIn(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @DELETE(value="/api/v1/sign_out")
    public Call<ResponseBody> signOut(@Query(value="token") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/organizations")
    public Call<ResponseBody> createOrganization(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/organizations")
    public Call<ResponseBody> getOrganizationsList(@Query(value="auth_token") String var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/organizations/{id}")
    public Call<ResponseBody> getOrganization(@Path(value="id") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/organizations/{id}")
    public Call<ResponseBody> updateOrganization(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/organizations/{id}", hasBody=true)
    public Call<ResponseBody> deleteOrganization(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/projects")
    public Call<ResponseBody> createProject(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/projects")
    public Call<ResponseBody> getProjectsList(@Query(value="auth_token") String var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/projects/{id}")
    public Call<ResponseBody> getProject(@Path(value="id") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/projects/{id}")
    public Call<ResponseBody> updateProject(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/projects/{id}", hasBody=true)
    public Call<ResponseBody> deleteProject(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/organizations/{organization_id}/roles")
    public Call<ResponseBody> assigneOrganizationRole(@Path(value="organization_id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/roles/{id}", hasBody=true)
    public Call<ResponseBody> deleteRole(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/organizations/{organization_id}/roles")
    public Call<ResponseBody> getOrganizationsRolesList(@Path(value="organization_id") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/organizations/{organization_id}/roles")
    public Call<ResponseBody> getProjectRolesList(@Path(value="organization_id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/roles/{id}")
    public Call<ResponseBody> getRole(@Path(value="id") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/roles/{id}")
    public Call<ResponseBody> updateRole(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/projects/upload_crashes")
    public Call<ResponseBody> uploadCrash(@Body JsonObject var1);

    @Multipart
    @POST(value="/api/v1/projects/issues/create")
    public Call<ResponseBody> uploadBugReport(@PartMap Map<String, RequestBody> var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/issues")
    public Call<ResponseBody> getIssueList(@Query(value="token") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/projects/issue_info")
    public Call<ResponseBody> getIssueWithMobileBuild(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/projects/issue_info")
    public Call<ResponseBody> getIssueWithSite(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/issues/{id}")
    public Call<ResponseBody> getIssueByID(@Path(value="id") String var1, @Query(value="token") String var2, @Query(value="auth_token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/issues/pid{id}")
    public Call<ResponseBody> getIssueByIDInProject(@Path(value="id") String var1, @Query(value="token") String var2, @Query(value="auth_token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/issues/{id}", hasBody=true)
    public Call<ResponseBody> deleteIssue(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/issues/pid{id}", hasBody=true)
    public Call<ResponseBody> deleteIssueByIDInProject(@Path(value="id") String var1, @Body JsonObject var2);

    @Multipart
    @PUT(value="/api/v1/issues/{id}")
    public Call<ResponseBody> updateIssue(@Path(value="id") String var1, @PartMap Map<String, RequestBody> var2);

    @Multipart
    @PUT(value="/api/v1/issues/pid{id}")
    public Call<ResponseBody> updateIssueByIdInProject(@Path(value="id") String var1, @PartMap Map<String, RequestBody> var2);

    @Multipart
    @POST(value="/api/v1/issues/{id}/attachments")
    public Call<ResponseBody> createAttachment(@Path(value="id") String var1, @PartMap Map<String, RequestBody> var2);

    @Multipart
    @POST(value="/api/v1/issues/pid{id}/attachments")
    public Call<ResponseBody> createAttachmentByIdInProject(@Path(value="id") String var1, @PartMap Map<String, RequestBody> var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/attachments/{id}", hasBody=true)
    public Call<ResponseBody> deleteAttachment(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/statuses")
    public Call<ResponseBody> createStatus(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/statuses")
    public Call<ResponseBody> getStatusesList(@Query(value="auth_token") String var1, @Query(value="token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/statuses/{id}")
    public Call<ResponseBody> getStatus(@Path(value="id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/statuses/{id}")
    public Call<ResponseBody> updateStatus(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/statuses/{id}", hasBody=true)
    public Call<ResponseBody> deleteStatus(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/test_plans")
    public Call<ResponseBody> createTestPlan(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_plans")
    public Call<ResponseBody> getTestPlansList(@Query(value="auth_token") String var1, @Query(value="token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_plans/{id}")
    public Call<ResponseBody> getTestPlan(@Path(value="id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/test_plans/{id}")
    public Call<ResponseBody> updateTestPlan(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/test_plans/{id}", hasBody=true)
    public Call<ResponseBody> deleteTestPlan(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/test_modules/{test_module_id}/test_cases")
    public Call<ResponseBody> createTestCase(@Path(value="test_module_id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_module/{test_module_id}/test_cases")
    public Call<ResponseBody> getTestCasesListOfModule(@Path(value="test_module_id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_plan/{test_plan_id}/test_cases")
    public Call<ResponseBody> getTestCasesListOfTestPlan(@Path(value="test_plan_id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_cases/{id}")
    public Call<ResponseBody> getTestCase(@Path(value="id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/test_cases/{id}")
    public Call<ResponseBody> updateTestCase(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/test_cases/{id}", hasBody=true)
    public Call<ResponseBody> deleteTestCase(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/test_plans/{test_plan_id}/test_modules")
    public Call<ResponseBody> createTestModule(@Path(value="test_plan_id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_plans/{test_plan_id}/test_modules")
    public Call<ResponseBody> getTestModulesList(@Path(value="test_plan_id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_modules/{id}")
    public Call<ResponseBody> getTestModule(@Path(value="id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/test_modules/{id}")
    public Call<ResponseBody> updateTestModule(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/test_modules/{id}", hasBody=true)
    public Call<ResponseBody> deleteTestModule(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/test_runs")
    public Call<ResponseBody> createTestRun(@Body JsonObject var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_runs")
    public Call<ResponseBody> getTestRunsList(@Query(value="auth_token") String var1, @Query(value="token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_runs/{id}")
    public Call<ResponseBody> getTestRun(@Path(value="id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/test_runs/{id}")
    public Call<ResponseBody> updateTestRun(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/test_runs/{id}", hasBody=true)
    public Call<ResponseBody> deleteTestRun(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_runs/{test_run_id}/test_run_results")
    public Call<ResponseBody> getTestRunResultsList(@Path(value="test_run_id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_run_results/{id}")
    public Call<ResponseBody> getTestRunResult(@Path(value="id") String var1, @Query(value="auth_token") String var2, @Query(value="token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/api/v1/test_run_results/{id}")
    public Call<ResponseBody> updateTestRunResult(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/test_run_results/{id}", hasBody=true)
    public Call<ResponseBody> deleteTestRunResult(@Path(value="id") String var1, @Body JsonObject var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/api/v1/test_objects")
    public Call<ResponseBody> uploadLink(@Body JsonObject var1);

    @Multipart
    @POST(value="/api/v1/test_objects")
    public Call<ResponseBody> uploadBuild(@PartMap Map<String, RequestBody> var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_objects")
    public Call<ResponseBody> getTestObjectLinks(@Query(value="token") String var1);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_objects")
    public Call<ResponseBody> getTestObjecsList(@Query(value="token") String var1, @Query(value="auth_token") String var2);

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/api/v1/test_objects/{id}")
    public Call<ResponseBody> getTestObjec(@Path(value="id") String var1, @Query(value="token") String var2, @Query(value="auth_token") String var3);

    @Headers(value={"Content-Type: application/json"})
    @HTTP(method="DELETE", path="/api/v1/test_objects/{id}", hasBody=true)
    public Call<ResponseBody> deleteTestObject(@Path(value="id") String var1, @Body JsonObject var2);
}

