/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.test.espresso.idling.CountingIdlingResource;
import android.text.TextUtils;
import com.getbouncer.cardscan.CreditCard;
import com.getbouncer.cardscan.TestingImageBridge;
import com.getbouncer.cardscan.TestingImageReader;
import com.getbouncer.cardscan.base.IdleResourceManager;
import com.getbouncer.cardscan.base.ScanActivityImpl;
import com.getbouncer.cardscan.base.ScanBaseActivity;

public class ScanActivity {
    private static final String TAG = "ScanActivity";
    private static final int REQUEST_CODE = 51234;
    public static final int RESULT_CANCELED = 0;
    public static final int RESULT_OK = -1;
    public static String RESULT_FATAL_ERROR = ScanBaseActivity.RESULT_FATAL_ERROR;
    public static TestingImageReader testingImageReader = null;
    public static String apiKey;

    public static void start(@NonNull Activity activity) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("apiKey", apiKey);
        activity.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Activity activity, String scanCardText, String positionCardText) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("scanCardText", scanCardText);
        intent.putExtra("positionCardText", positionCardText);
        intent.putExtra("apiKey", apiKey);
        activity.startActivityForResult(intent, 51234);
    }

    public static void warmUp(@NonNull Activity activity) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
    }

    public static void startDebug(@NonNull Activity activity) {
        ScanActivity.startDebug(activity, null);
    }

    public static void startDebug(@NonNull Activity activity, @Nullable TestingImageReader imageReader) {
        if (imageReader != null) {
            ScanBaseActivity.sTestingImageReader = new TestingImageBridge(imageReader);
        }
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("debug", true);
        intent.putExtra("apiKey", apiKey);
        activity.startActivityForResult(intent, 51234);
    }

    public static boolean isScanResult(int requestCode) {
        return requestCode == 51234;
    }

    @Nullable
    public static CreditCard creditCardFromResult(Intent intent) {
        String number = intent.getStringExtra("cardNumber");
        String month = intent.getStringExtra("expiryMonth");
        String year = intent.getStringExtra("expiryYear");
        if (TextUtils.isEmpty((CharSequence)number)) {
            return null;
        }
        return new CreditCard(number, month, year);
    }

    public static CountingIdlingResource getScanningIdleResource() {
        return IdleResourceManager.getScanningIdleResource();
    }
}

