/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.getbouncer.cardscan.base.CreditCardUtils;
import java.io.Serializable;

public class CreditCard
implements Parcelable {
    @NonNull
    public final String number;
    @NonNull
    public final Network network;
    @Nullable
    public final String expiryMonth;
    @Nullable
    public final String expiryYear;
    public static final Parcelable.Creator<CreditCard> CREATOR = new Parcelable.Creator<CreditCard>(){

        public CreditCard createFromParcel(Parcel in) {
            return new CreditCard(in);
        }

        public CreditCard[] newArray(int size) {
            return new CreditCard[size];
        }
    };

    CreditCard(@NonNull String number, @Nullable String expiryMonth, @Nullable String expiryYear) {
        this.number = number;
        this.expiryMonth = expiryMonth;
        this.expiryYear = expiryYear;
        this.network = CreditCardUtils.isVisa((String)number) ? Network.VISA : (CreditCardUtils.isAmex((String)number) ? Network.AMEX : (CreditCardUtils.isDiscover((String)number) ? Network.DISCOVER : (CreditCardUtils.isMastercard((String)number) ? Network.MASTERCARD : Network.UNKNOWN)));
    }

    @NonNull
    public String last4() {
        return this.number.substring(this.number.length() - 4);
    }

    @Nullable
    public String expiryForDisplay() {
        String year;
        if (this.expiryMonth == null || this.expiryYear == null) {
            return null;
        }
        String month = this.expiryMonth;
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((year = this.expiryYear).length() == 4) {
            year = year.substring(2);
        }
        return month + "/" + year;
    }

    private CreditCard(Parcel in) {
        String number = in.readString();
        this.expiryMonth = in.readString();
        this.expiryYear = in.readString();
        Network network = (Network)((Object)in.readSerializable());
        this.number = number == null ? "" : number;
        this.network = network == null ? Network.UNKNOWN : network;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.number);
        parcel.writeString(this.expiryMonth);
        parcel.writeString(this.expiryYear);
        parcel.writeSerializable((Serializable)((Object)this.network));
    }

    public static enum Network {
        VISA,
        MASTERCARD,
        AMEX,
        DISCOVER,
        UNKNOWN;

    }
}

