/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import com.getbase.floatingactionbutton.AddFloatingActionButton;
import com.getbase.floatingactionbutton.R;

public class FloatingActionsMenu
extends ViewGroup {
    private static final int ANIMATION_DURATION = 300;
    private static final float COLLAPSED_PLUS_ROTATION = 0.0f;
    private static final float EXPANDED_PLUS_ROTATION = 135.0f;
    private int mAddButtonPlusColor;
    private int mAddButtonColorNormal;
    private int mAddButtonColorPressed;
    private int mButtonSpacing;
    private boolean mExpanded;
    private AnimatorSet mExpandAnimation = new AnimatorSet().setDuration(300L);
    private AnimatorSet mCollapseAnimation = new AnimatorSet().setDuration(300L);
    private AddFloatingActionButton mAddButton;
    private RotatingDrawable mRotatingDrawable;
    private static Interpolator sExpandInterpolator = new OvershootInterpolator();
    private static Interpolator sCollapseInterpolator = new DecelerateInterpolator(3.0f);
    private static Interpolator sAlphaExpandInterpolator = new DecelerateInterpolator();

    public FloatingActionsMenu(Context context) {
        this(context, null);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attributeSet) {
        TypedArray attr2;
        this.mAddButtonPlusColor = this.getColor(17170443);
        this.mAddButtonColorNormal = this.getColor(17170451);
        this.mAddButtonColorPressed = this.getColor(17170450);
        this.mButtonSpacing = (int)(this.getResources().getDimension(R.dimen.fab_actions_spacing) - this.getResources().getDimension(R.dimen.fab_shadow_radius) - this.getResources().getDimension(R.dimen.fab_shadow_offset));
        if (attributeSet != null && (attr2 = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionsMenu, 0, 0)) != null) {
            try {
                this.mAddButtonPlusColor = attr2.getColor(2, this.getColor(17170443));
                this.mAddButtonColorNormal = attr2.getColor(1, this.getColor(17170451));
                this.mAddButtonColorPressed = attr2.getColor(0, this.getColor(17170450));
            }
            finally {
                attr2.recycle();
            }
        }
        this.createAddButton(context);
    }

    private void createAddButton(Context context) {
        this.mAddButton = new AddFloatingActionButton(context){

            @Override
            void updateBackground() {
                this.mPlusColor = FloatingActionsMenu.this.mAddButtonPlusColor;
                this.mColorNormal = FloatingActionsMenu.this.mAddButtonColorNormal;
                this.mColorPressed = FloatingActionsMenu.this.mAddButtonColorPressed;
                super.updateBackground();
            }

            @Override
            Drawable getIconDrawable() {
                RotatingDrawable rotatingDrawable = new RotatingDrawable(super.getIconDrawable());
                FloatingActionsMenu.this.mRotatingDrawable = rotatingDrawable;
                OvershootInterpolator interpolator = new OvershootInterpolator();
                ObjectAnimator collapseAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{0.0f});
                ObjectAnimator expandAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{135.0f});
                collapseAnimator.setInterpolator((TimeInterpolator)interpolator);
                expandAnimator.setInterpolator((TimeInterpolator)interpolator);
                FloatingActionsMenu.this.mExpandAnimation.play((Animator)expandAnimator);
                FloatingActionsMenu.this.mCollapseAnimation.play((Animator)collapseAnimator);
                return rotatingDrawable;
            }
        };
        this.mAddButton.setId(R.id.fab_expand_menu_button);
        this.mAddButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionsMenu.this.toggle();
            }
        });
        this.addView((View)this.mAddButton, super.generateDefaultLayoutParams());
    }

    private int getColor(int id2) {
        return this.getResources().getColor(id2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int width = 0;
        int height = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            width = Math.max(width, child.getMeasuredWidth());
            height += child.getMeasuredHeight();
        }
        height += this.mButtonSpacing * (this.getChildCount() - 1);
        height = height * 12 / 10;
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int addButtonY = b - t - this.mAddButton.getMeasuredHeight();
        this.mAddButton.layout(0, addButtonY, this.mAddButton.getMeasuredWidth(), addButtonY + this.mAddButton.getMeasuredHeight());
        int bottomY = addButtonY - this.mButtonSpacing;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child == this.mAddButton) continue;
            int childY = bottomY - child.getMeasuredHeight();
            child.layout(0, childY, child.getMeasuredWidth(), childY + child.getMeasuredHeight());
            float collapsedTranslation = addButtonY - childY;
            float expandedTranslation = 0.0f;
            child.setTranslationY(this.mExpanded ? expandedTranslation : collapsedTranslation);
            child.setAlpha(this.mExpanded ? 1.0f : 0.0f);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            params.mCollapseY.setFloatValues(new float[]{collapsedTranslation});
            params.mExpandY.setFloatValues(new float[]{expandedTranslation});
            params.setAnimationsTarget(child);
            bottomY = childY - this.mButtonSpacing;
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(super.generateDefaultLayoutParams());
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(super.generateLayoutParams(attrs));
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(super.generateLayoutParams(p));
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bringChildToFront((View)this.mAddButton);
    }

    public void collapse() {
        if (this.mExpanded) {
            this.mExpanded = false;
            this.mCollapseAnimation.start();
            this.mExpandAnimation.cancel();
        }
    }

    public void toggle() {
        if (this.mExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void expand() {
        if (!this.mExpanded) {
            this.mExpanded = true;
            this.mCollapseAnimation.cancel();
            this.mExpandAnimation.start();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mExpanded = this.mExpanded;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            this.mExpanded = savedState.mExpanded;
            if (this.mRotatingDrawable != null) {
                this.mRotatingDrawable.setRotation(this.mExpanded ? 135.0f : 0.0f);
            }
            super.onRestoreInstanceState(savedState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public boolean mExpanded;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcel) {
            super(parcel);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mExpanded = in.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mExpanded ? 1 : 0);
        }
    }

    private class LayoutParams
    extends ViewGroup.LayoutParams {
        private ObjectAnimator mExpandY;
        private ObjectAnimator mExpandAlpha;
        private ObjectAnimator mCollapseY;
        private ObjectAnimator mCollapseAlpha;

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
            this.mExpandY = new ObjectAnimator();
            this.mExpandAlpha = new ObjectAnimator();
            this.mCollapseY = new ObjectAnimator();
            this.mCollapseAlpha = new ObjectAnimator();
            this.mExpandY.setInterpolator((TimeInterpolator)sExpandInterpolator);
            this.mExpandAlpha.setInterpolator((TimeInterpolator)sAlphaExpandInterpolator);
            this.mCollapseY.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setProperty(View.ALPHA);
            this.mCollapseAlpha.setFloatValues(new float[]{0.0f});
            this.mExpandAlpha.setProperty(View.ALPHA);
            this.mExpandAlpha.setFloatValues(new float[]{1.0f});
            this.mCollapseY.setProperty(View.TRANSLATION_Y);
            this.mExpandY.setProperty(View.TRANSLATION_Y);
            FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandAlpha);
            FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandY);
            FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseAlpha);
            FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseY);
        }

        public void setAnimationsTarget(View view) {
            this.mCollapseAlpha.setTarget((Object)view);
            this.mCollapseY.setTarget((Object)view);
            this.mExpandAlpha.setTarget((Object)view);
            this.mExpandY.setTarget((Object)view);
        }
    }

    private static class RotatingDrawable
    extends LayerDrawable {
        private float mRotation;

        public RotatingDrawable(Drawable drawable2) {
            super(new Drawable[]{drawable2});
        }

        public float getRotation() {
            return this.mRotation;
        }

        public void setRotation(float rotation) {
            this.mRotation = rotation;
            this.invalidateSelf();
        }

        public void draw(Canvas canvas) {
            canvas.save();
            canvas.rotate(this.mRotation, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            super.draw(canvas);
            canvas.restore();
        }
    }
}

