/*
 * Decompiled with CFR 0.152.
 */
package com.geronimostudios.ui;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.geronimostudios.ui.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class BottomMenuView
extends View {
    public static final int LINE_AUTO = -1;
    public static final int LINE_FULL_WIDTH = -2;
    public static final int LINE_CUSTOM = -3;
    private List<Tab> mTabs;
    private Drawable mUnderlineDrawable;
    @Nullable
    private ViewPager mViewPager;
    private float mItemSize;
    private float mUnderlineHeight;
    private float mUnderlineWidth;
    private int mUnderlineMode;
    private int mCurrentPage;
    private int mLastPage;
    private float mLastTouchX;
    private Listener mListener;
    private int mScrollCurrentPage;
    @FloatRange(from=0.0, to=1.0)
    private float mScrollPageOffset;
    @Nullable
    private Drawable mDefaultTabBackground;
    private ViewPager.OnPageChangeListener mViewPagerPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int page, @FloatRange(from=0.0, to=1.0) float positionOffset, int positionOffsetPixels) {
            BottomMenuView.this.mScrollCurrentPage = page;
            BottomMenuView.this.mScrollPageOffset = positionOffset;
            BottomMenuView.this.invalidate();
        }

        public void onPageSelected(int position) {
            BottomMenuView.this.internalChangePage(position);
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public BottomMenuView(Context context) {
        super(context);
        this.init(context, null);
    }

    public BottomMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BottomMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @RequiresApi(api=21)
    public BottomMenuView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mUnderlineDrawable = new ShapeDrawable((Shape)new RectShape());
        int lineColor = -1;
        this.mUnderlineHeight = -1.0f;
        this.mItemSize = -1.0f;
        this.mUnderlineMode = -1;
        this.mDefaultTabBackground = null;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BottomMenuView);
            lineColor = a.getColor(R.styleable.BottomMenuView_tabLineColor, -1);
            this.mUnderlineHeight = a.getDimension(R.styleable.BottomMenuView_tabLineHeight, -1.0f);
            this.mItemSize = a.getDimension(R.styleable.BottomMenuView_tabIconSize, -1.0f);
            this.mDefaultTabBackground = a.getDrawable(R.styleable.BottomMenuView_tabBackground);
            TypedValue tv = new TypedValue();
            a.getValue(R.styleable.BottomMenuView_tabLineWidth, tv);
            if (tv.type != 0) {
                switch (tv.type) {
                    case 5: {
                        this.mUnderlineMode = -3;
                        this.mUnderlineWidth = a.getDimension(R.styleable.BottomMenuView_tabLineWidth, 0.0f);
                        break;
                    }
                    case 4: {
                        int mode = a.getInteger(R.styleable.BottomMenuView_tabLineWidth, -1);
                        if (mode == -1) {
                            this.mUnderlineMode = -1;
                            break;
                        }
                        this.mUnderlineMode = -2;
                        break;
                    }
                    default: {
                        this.mUnderlineMode = -1;
                    }
                }
            }
            a.recycle();
        }
        Resources res = context.getResources();
        if (this.mItemSize == -1.0f) {
            this.mItemSize = res.getDimension(R.dimen.menu_item_size);
        }
        if (this.mUnderlineHeight == -1.0f) {
            this.mUnderlineHeight = res.getDimension(R.dimen.menu_underline_height);
        }
        if (lineColor == -1) {
            TypedValue value = new TypedValue();
            context.getTheme().resolveAttribute(R.attr.colorAccent, value, true);
            lineColor = value.data;
        }
        this.mUnderlineDrawable.setColorFilter(lineColor, PorterDuff.Mode.SRC);
        this.setClickable(true);
        if (this.isInEditMode()) {
            this.fillWithFakeData();
        }
    }

    protected void drawableStateChanged() {
        int[] stateSet = this.getDrawableState();
        if (this.mTabs != null) {
            int widthPerItem = this.getWidth() / this.mTabs.size();
            int index = (int)(this.mLastTouchX / (float)widthPerItem);
            for (int tabIndex = 0; tabIndex < this.mTabs.size(); ++tabIndex) {
                int[] newState;
                Tab tab = this.mTabs.get(tabIndex);
                Drawable drawable2 = tab.getBackgroundDrawable();
                if (drawable2 == null || !drawable2.isStateful()) continue;
                if (index == tabIndex) {
                    newState = new int[stateSet.length + 1];
                    System.arraycopy(stateSet, 0, newState, 0, stateSet.length);
                    newState[stateSet.length] = 0x10100A1;
                } else {
                    newState = new int[stateSet.length];
                    System.arraycopy(stateSet, 0, newState, 0, stateSet.length);
                    for (int i = 0; i < newState.length; ++i) {
                        int state = newState[i];
                        if (state != 0x10100A1 && state != 16842919) continue;
                        newState[i] = 0;
                    }
                }
                drawable2.setState(newState);
                this.invalidate();
            }
        }
        super.drawableStateChanged();
    }

    public void drawableHotspotChanged(float x, float y) {
        int widthPerItem;
        int index;
        Tab tab;
        Drawable drawable2;
        if (Build.VERSION.SDK_INT >= 21 && this.mTabs != null && (drawable2 = (tab = this.mTabs.get(index = (int)(x / (float)(widthPerItem = this.getWidth() / this.mTabs.size())))).getBackgroundDrawable()) != null) {
            drawable2.setHotspot(x, y);
        }
        super.drawableHotspotChanged(x, y);
    }

    public void jumpDrawablesToCurrentState() {
        if (this.mTabs != null) {
            for (Tab tab : this.mTabs) {
                Drawable drawable2 = tab.getBackgroundDrawable();
                if (drawable2 == null) continue;
                drawable2.jumpToCurrentState();
            }
        }
        super.jumpDrawablesToCurrentState();
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        boolean verified = false;
        if (this.mTabs != null) {
            for (Tab tab : this.mTabs) {
                Drawable drawable2 = tab.getBackgroundDrawable();
                if (drawable2 == null || who != drawable2) continue;
                verified = true;
            }
        }
        return super.verifyDrawable(who) || verified;
    }

    private void fillWithFakeData() {
        this.mTabs = new ArrayList<Tab>();
        this.mTabs.add(new Tab(this.getContext(), 17301577, this.getCopyOfDefaultTabBackground()));
        this.mTabs.add(new Tab(this.getContext(), 17301559, this.getCopyOfDefaultTabBackground()));
        this.mTabs.add(new Tab(this.getContext(), 17301567, this.getCopyOfDefaultTabBackground()));
    }

    public void setupWith(ViewPager viewPager) {
        this.unregisterDrawableCallback();
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener(this.mViewPagerPageChangeListener);
        this.mScrollCurrentPage = this.mViewPager.getCurrentItem();
        this.mScrollPageOffset = 0.0f;
        this.mLastPage = this.mViewPager.getCurrentItem();
        this.mCurrentPage = this.mViewPager.getCurrentItem();
        PagerAdapter vpAdapter = this.mViewPager.getAdapter();
        if (vpAdapter == null || !(this.mViewPager.getAdapter() instanceof Adapter)) {
            throw new IllegalArgumentException("Adapter not implemented");
        }
        Adapter adapter = (Adapter)vpAdapter;
        this.mTabs = new ArrayList<Tab>();
        for (int i = 0; i < vpAdapter.getCount(); ++i) {
            this.mTabs.add(new Tab(this.getContext(), adapter.getMenuIcon(i), this.getCopyOfDefaultTabBackground()));
        }
        this.invalidate();
    }

    public void setupWith(@Nullable List<Tab> tabs) {
        if (this.mViewPager != null) {
            this.mViewPager.removeOnPageChangeListener(this.mViewPagerPageChangeListener);
            this.mViewPager = null;
        }
        this.unregisterDrawableCallback();
        this.mScrollCurrentPage = 0;
        this.mScrollPageOffset = 0.0f;
        this.mLastPage = 0;
        this.mCurrentPage = 0;
        this.mTabs = tabs;
        if (this.mTabs != null) {
            for (Tab tab : this.mTabs) {
                Drawable drawable2 = tab.getBackgroundDrawable();
                if (drawable2 == null) continue;
                drawable2.setCallback((Drawable.Callback)this);
            }
        }
        this.invalidate();
    }

    private void unregisterDrawableCallback() {
        if (this.mTabs != null) {
            for (Tab tab : this.mTabs) {
                Drawable drawable2 = tab.getBackgroundDrawable();
                if (drawable2 == null) continue;
                drawable2.setCallback(null);
            }
        }
    }

    private Drawable getCopyOfDefaultTabBackground() {
        Drawable.ConstantState state;
        if (this.mDefaultTabBackground != null && (state = this.mDefaultTabBackground.getConstantState()) != null) {
            Drawable drawable2 = state.newDrawable();
            drawable2.setCallback((Drawable.Callback)this);
            return drawable2;
        }
        return null;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mTabs == null) {
            return;
        }
        int itemCount = this.mTabs.size();
        int widthPerItem = this.getWidth() / itemCount;
        for (int i = 0; i < itemCount; ++i) {
            Tab tab = this.mTabs.get(i);
            float offsetX = (float)(widthPerItem * i + widthPerItem / 2) - this.mItemSize / 2.0f;
            float offsetY = this.getIconOffsetY(i);
            Drawable background = tab.getBackgroundDrawable();
            if (background != null) {
                background.setBounds(i * widthPerItem, 0, (i + 1) * widthPerItem, this.getMeasuredHeight());
                background.draw(canvas);
            }
            Drawable iconDrawable = tab.getIconDrawable();
            iconDrawable.setBounds((int)offsetX, (int)offsetY, (int)(offsetX + this.mItemSize), (int)(offsetY + this.mItemSize));
            iconDrawable.draw(canvas);
        }
        int offsetX = (int)((float)(widthPerItem * this.mScrollCurrentPage) + (float)widthPerItem / 2.0f - this.mUnderlineWidth / 2.0f + (float)widthPerItem * this.mScrollPageOffset);
        int offsetY = (int)((float)this.getHeight() - this.mUnderlineHeight);
        this.mUnderlineDrawable.setBounds(offsetX, offsetY, (int)((float)offsetX + this.mUnderlineWidth), this.getHeight());
        this.mUnderlineDrawable.draw(canvas);
    }

    private int getIconOffsetY(int iconPage) {
        if (iconPage != this.mScrollCurrentPage && iconPage != this.mScrollCurrentPage + 1 || iconPage != this.mCurrentPage && iconPage != this.mLastPage) {
            return this.getPaddingTop();
        }
        float percent = iconPage == this.mScrollCurrentPage ? 1.0f - this.mScrollPageOffset : this.mScrollPageOffset;
        return (int)((float)this.getPaddingTop() - (float)this.getPaddingTop() / 4.0f * percent);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), (int)((float)this.getPaddingTop() + this.mItemSize + (float)this.getPaddingBottom()));
        switch (this.mUnderlineMode) {
            case -1: {
                this.mUnderlineWidth = this.mItemSize * 2.0f;
                break;
            }
            case -2: {
                if (this.mTabs == null) break;
                int itemCount = this.mTabs.size();
                this.mUnderlineWidth = this.getMeasuredWidth() / itemCount;
                break;
            }
            case -3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode");
            }
        }
    }

    private void setInternalPageScrolled(float page) {
        this.mScrollCurrentPage = (int)Math.floor(page);
        this.mScrollPageOffset = page - (float)this.mScrollCurrentPage;
        this.invalidate();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.mLastTouchX = event.getX();
        boolean handled = super.dispatchTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                return this.mViewPager != null && this.mTabs != null && !this.mTabs.isEmpty() || handled;
            }
            case 1: {
                int widthPerItem = this.getWidth() / this.mTabs.size();
                int page = (int)(event.getX() / (float)widthPerItem);
                if (this.mViewPager != null) {
                    this.mViewPager.setCurrentItem(page);
                } else {
                    this.setCurrentPage(page);
                }
                return true;
            }
        }
        return handled;
    }

    public void setCurrentPage(int position) {
        this.setCurrentPage(position, true);
    }

    public void setCurrentPage(int position, boolean animate) {
        if (animate) {
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"internalPageScrolled", (float[])new float[]{this.mCurrentPage, position});
            animator.setAutoCancel(true);
            animator.setDuration(150L);
            animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.internalChangePage(position);
            animator.start();
        } else {
            this.mScrollCurrentPage = position;
            this.mScrollPageOffset = 0.0f;
            this.internalChangePage(position);
        }
    }

    private void internalChangePage(int position) {
        this.mLastPage = this.mCurrentPage;
        this.mCurrentPage = position;
        if (this.mListener != null) {
            this.mListener.onMenuPageChanged(position);
        }
        this.invalidate();
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public static interface Listener {
        public void onMenuPageChanged(int var1);
    }

    public static interface Adapter {
        @DrawableRes
        public int getMenuIcon(int var1);
    }

    public static class Tab {
        @Nullable
        private Drawable mDrawable;
        @NonNull
        private Drawable mIconDrawable;

        public Tab(Context context, @DrawableRes int icon) {
            this.mIconDrawable = ContextCompat.getDrawable((Context)context, (int)icon);
        }

        public Tab(Context context, @DrawableRes int icon, @Nullable Drawable drawable2) {
            this.mDrawable = drawable2;
            this.mIconDrawable = ContextCompat.getDrawable((Context)context, (int)icon);
        }

        @Nullable
        Drawable getBackgroundDrawable() {
            return this.mDrawable;
        }

        @NonNull
        Drawable getIconDrawable() {
            return this.mIconDrawable;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineMode {
    }
}

