/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.database;

import com.genonbeta.android.database.SQLType;
import java.util.HashMap;

public class SQLValues {
    private HashMap<String, Table> mIndex = new HashMap();

    public Table defineTable(String name) {
        Table table = new Table(name);
        this.getTables().put(name, table);
        return table;
    }

    public Table defineTable(String name, boolean mayExist) {
        Table table = new Table(name, mayExist);
        this.getTables().put(name, table);
        return table;
    }

    public HashMap<String, Table> getTables() {
        return this.mIndex;
    }

    public static class Table {
        private String mName;
        private HashMap<String, Column> mColumns = new HashMap();
        private boolean mMayExist;

        public Table(String name) {
            this.setName(name);
        }

        public Table(String name, boolean mayExist) {
            this(name);
            this.mMayExist = mayExist;
        }

        public boolean columnExist(String columnName) {
            return this.mColumns.containsKey(columnName);
        }

        public Table define(Column column) {
            this.getColumns().put(column.getName(), column);
            return this;
        }

        public Column getColumn(String name) {
            return this.getColumns().get(name);
        }

        public HashMap<String, Column> getColumns() {
            return this.mColumns;
        }

        public String getName() {
            return this.mName;
        }

        public boolean mayExist() {
            return this.mMayExist;
        }

        public void setName(String mName) {
            this.mName = mName;
        }
    }

    public static class Column {
        private String mName;
        private String mExtra;
        private String mValue;
        private SQLType mType;
        private boolean mNullable;

        public Column(String columnName, Object value) {
            this.setName(columnName);
            this.setValue(String.valueOf(value));
        }

        public Column(String columnName, SQLType type, boolean nullable) {
            this.setName(columnName);
            this.setType(type);
            this.setNullable(nullable);
        }

        public Column(String columnName, SQLType type, boolean nullable, String extra) {
            this(columnName, type, nullable);
            this.setExtra(extra);
        }

        public String getExtra() {
            return this.mExtra;
        }

        public String getName() {
            return this.mName;
        }

        public SQLType getType() {
            return this.mType;
        }

        public String getValue() {
            return this.mValue;
        }

        public boolean isNullable() {
            return this.mNullable;
        }

        public Column setExtra(String mExtra) {
            this.mExtra = mExtra;
            return this;
        }

        public Column setName(String mName) {
            this.mName = mName;
            return this;
        }

        public Column setNullable(boolean mNullable) {
            this.mNullable = mNullable;
            return this;
        }

        public Column setType(SQLType mType) {
            this.mType = mType;
            return this;
        }

        public void setValue(String mValue) {
            this.mValue = mValue;
        }

        public String toString() {
            return "`" + this.getName() + "` " + this.getType().toString() + " " + (this.isNullable() ? "null" : "not null") + (this.getExtra() != null ? " " + this.mExtra : "");
        }
    }
}

