/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.genonbeta.android.database.CursorItem;
import com.genonbeta.android.database.DatabaseObject;
import com.genonbeta.android.database.SQLQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SQLiteDatabase
extends SQLiteOpenHelper {
    private Context mContext;
    private int mMaxHeapSize = 250;

    public SQLiteDatabase(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.mContext = context;
    }

    public void bindContentValue(SQLiteStatement statement, int iteratorPosition, Object bindingObject) {
        if (bindingObject == null) {
            statement.bindNull(iteratorPosition);
        } else if (bindingObject instanceof Long) {
            statement.bindLong(iteratorPosition, ((Long)bindingObject).longValue());
        } else if (bindingObject instanceof Integer) {
            statement.bindLong(iteratorPosition, (long)((Integer)bindingObject).intValue());
        } else if (bindingObject instanceof Double) {
            statement.bindDouble(iteratorPosition, ((Double)bindingObject).doubleValue());
        } else if (bindingObject instanceof byte[]) {
            statement.bindBlob(iteratorPosition, (byte[])bindingObject);
        } else {
            statement.bindString(iteratorPosition, bindingObject instanceof String ? (String)bindingObject : String.valueOf(bindingObject));
        }
    }

    public <T extends DatabaseObject> ArrayList<T> castQuery(SQLQuery.Select select, Class<T> clazz) {
        return this.castQuery(select, clazz, null);
    }

    public <T extends DatabaseObject> ArrayList<T> castQuery(SQLQuery.Select select, Class<T> clazz, CastQueryListener<T> listener) {
        return this.castQuery(this.getReadableDatabase(), select, clazz, listener);
    }

    public <T extends DatabaseObject> ArrayList<T> castQuery(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select, Class<T> clazz, CastQueryListener<T> listener) {
        ArrayList<DatabaseObject> returnedList = new ArrayList<DatabaseObject>();
        ArrayList<CursorItem> itemList = this.getTable(db, select);
        try {
            for (CursorItem item : itemList) {
                DatabaseObject newClazz = (DatabaseObject)clazz.newInstance();
                newClazz.reconstruct(item);
                if (listener != null) {
                    listener.onObjectReconstructed(this, item, newClazz);
                }
                returnedList.add(newClazz);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return returnedList;
    }

    public Map<String, List<DatabaseObject>> explodePerTable(List<? extends DatabaseObject> objects) {
        HashMap<String, List<DatabaseObject>> tables = new HashMap<String, List<DatabaseObject>>();
        for (DatabaseObject databaseObject : objects) {
            String tableName = databaseObject.getWhere().tableName;
            ArrayList<DatabaseObject> availTable = (ArrayList<DatabaseObject>)tables.get(tableName);
            if (availTable == null) {
                availTable = new ArrayList<DatabaseObject>();
                tables.put(tableName, availTable);
            }
            availTable.add(databaseObject);
        }
        return tables;
    }

    public Context getContext() {
        return this.mContext;
    }

    public CursorItem getFirstFromTable(SQLQuery.Select select) {
        return this.getFirstFromTable(this.getReadableDatabase(), select);
    }

    public CursorItem getFirstFromTable(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select) {
        ArrayList<CursorItem> list = this.getTable(db, select.setLimit(1));
        return list.size() > 0 ? list.get(0) : null;
    }

    public ArrayList<CursorItem> getTable(SQLQuery.Select select) {
        return this.getTable(this.getReadableDatabase(), select);
    }

    public ArrayList<CursorItem> getTable(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select) {
        ArrayList<CursorItem> list = new ArrayList<CursorItem>();
        Cursor cursor = db.query(select.tableName, select.columns, select.where, select.whereArgs, select.groupBy, select.having, select.orderBy, select.limit);
        if (cursor.moveToFirst()) {
            if (select.loadListener != null) {
                select.loadListener.onOpen(this, cursor);
            }
            do {
                CursorItem item = new CursorItem();
                for (int i = 0; i < cursor.getColumnCount(); ++i) {
                    item.put(cursor.getColumnName(i), cursor.getString(i));
                }
                if (select.loadListener != null) {
                    select.loadListener.onLoad(this, cursor, item);
                }
                list.add(item);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return list;
    }

    public long insert(DatabaseObject object) {
        return this.insert(this.getWritableDatabase(), object);
    }

    public long insert(android.database.sqlite.SQLiteDatabase db, DatabaseObject object) {
        object.onCreateObject(this);
        return this.insert(db, object.getWhere().tableName, null, object.getValues());
    }

    public long insert(android.database.sqlite.SQLiteDatabase db, String tableName, String nullColumnHack, ContentValues contentValues) {
        return db.insert(tableName, nullColumnHack, contentValues);
    }

    public void insert(List<? extends DatabaseObject> objects) {
        this.insert(objects, null);
    }

    public void insert(List<? extends DatabaseObject> objects, ProgressUpdater updater) {
        this.insert(this.getWritableDatabase(), objects, updater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(android.database.sqlite.SQLiteDatabase openDatabase, List<? extends DatabaseObject> objects, ProgressUpdater updater) {
        Map<String, List<DatabaseObject>> tables = this.explodePerTable(objects);
        openDatabase.beginTransaction();
        try {
            if (tables.size() > 0) {
                block5: for (String tableName : tables.keySet()) {
                    ArrayList baseKeys = new ArrayList();
                    List<DatabaseObject> databaseObjects = tables.get(tableName);
                    StringBuilder valueTemplate = new StringBuilder();
                    int indexPosition = 0;
                    if (databaseObjects == null) continue;
                    for (DatabaseObject thisObject : databaseObjects) {
                        ContentValues contentValues = thisObject.getValues();
                        if (baseKeys.size() == 0) {
                            baseKeys.addAll(contentValues.keySet());
                        }
                        if (valueTemplate.length() == 0) {
                            valueTemplate.append("(");
                            for (int columnIterator = 0; columnIterator < baseKeys.size(); ++columnIterator) {
                                if (columnIterator > 0) {
                                    valueTemplate.append(",");
                                }
                                valueTemplate.append("?");
                            }
                            valueTemplate.append(")");
                        }
                        StringBuilder sqlQuery = new StringBuilder();
                        StringBuilder columnIndex = new StringBuilder();
                        sqlQuery.append(String.format("INSERT INTO `%s` (", tableName));
                        for (String columnName : baseKeys) {
                            if (columnIndex.length() > 0) {
                                columnIndex.append(",");
                            }
                            columnIndex.append(String.format("`%s`", columnName));
                        }
                        sqlQuery.append((CharSequence)columnIndex);
                        sqlQuery.append(") VALUES ");
                        sqlQuery.append((CharSequence)valueTemplate);
                        sqlQuery.append(";");
                        if (updater != null && !updater.onProgressState()) continue block5;
                        SQLiteStatement statement = openDatabase.compileStatement(sqlQuery.toString());
                        int iterator = 0;
                        for (String baseKey : baseKeys) {
                            this.bindContentValue(statement, ++iterator, contentValues.get(baseKey));
                        }
                        statement.execute();
                        statement.close();
                        if (updater != null) {
                            updater.onProgressChange(objects.size(), indexPosition++);
                        }
                        thisObject.onCreateObject(this);
                    }
                }
            }
            openDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
    }

    public void publish(DatabaseObject object) {
        this.publish(this.getWritableDatabase(), object);
    }

    public void publish(android.database.sqlite.SQLiteDatabase database, DatabaseObject object) {
        if (this.getFirstFromTable(object.getWhere()) != null) {
            this.update(database, object);
        } else {
            this.insert(database, object);
        }
    }

    public <T extends DatabaseObject> boolean publish(Class<T> clazz, List<T> objects) {
        return this.publish(clazz, objects, null);
    }

    public <T extends DatabaseObject> boolean publish(Class<T> clazz, List<T> objects, ProgressUpdater updater) {
        return this.publish(this.getWritableDatabase(), clazz, objects, updater);
    }

    public <T extends DatabaseObject> boolean publish(android.database.sqlite.SQLiteDatabase openDatabase, Class<T> clazz, List<T> objects, ProgressUpdater updater) {
        Map<String, List<DatabaseObject>> tables = this.explodePerTable(objects);
        if (tables.size() > 0) {
            try {
                DatabaseObject exampleClazz = (DatabaseObject)clazz.newInstance();
                for (String tableName : tables.keySet()) {
                    List<DatabaseObject> objectList = tables.get(tableName);
                    if (objectList == null) continue;
                    ArrayList<DatabaseObject> updatingObjects = new ArrayList<DatabaseObject>();
                    ArrayList<DatabaseObject> insertingObjects = new ArrayList<DatabaseObject>();
                    int existenceIterator = 0;
                    for (DatabaseObject currentObject : objectList) {
                        if (updater != null && !updater.onProgressState()) {
                            return false;
                        }
                        if (this.getFirstFromTable(currentObject.getWhere()) == null) {
                            insertingObjects.add(currentObject);
                        } else {
                            updatingObjects.add(currentObject);
                        }
                        if (updater == null) continue;
                        updater.onProgressChange(objectList.size(), existenceIterator++);
                    }
                    this.insert(openDatabase, insertingObjects, updater);
                    this.update(openDatabase, updatingObjects, updater);
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void reconstruct(DatabaseObject object) throws Exception {
        this.reconstruct(this.getReadableDatabase(), object);
    }

    public void reconstruct(android.database.sqlite.SQLiteDatabase db, DatabaseObject object) throws Exception {
        CursorItem item = this.getFirstFromTable(db, object.getWhere());
        if (item == null) {
            SQLQuery.Select select = object.getWhere();
            StringBuilder whereArgs = new StringBuilder();
            for (String arg : select.whereArgs) {
                if (whereArgs.length() > 0) {
                    whereArgs.append(", ");
                }
                whereArgs.append("[] ");
                whereArgs.append(arg);
            }
            throw new Exception("No data was returned from: query; tableName: " + select.tableName + "; where: " + select.where + "; whereArgs: " + whereArgs.toString());
        }
        object.reconstruct(item);
    }

    public void remove(DatabaseObject object) {
        object.onRemoveObject(this);
        this.remove(this.getWritableDatabase(), object.getWhere());
    }

    public void remove(android.database.sqlite.SQLiteDatabase db, DatabaseObject object) {
        object.onRemoveObject(this);
        this.remove(db, object.getWhere());
    }

    public int remove(SQLQuery.Select select) {
        return this.remove(this.getWritableDatabase(), select);
    }

    public int remove(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select) {
        return db.delete(select.tableName, select.where, select.whereArgs);
    }

    public void remove(List<? extends DatabaseObject> objects) {
        this.remove(objects, null);
    }

    public void remove(List<? extends DatabaseObject> objects, ProgressUpdater updater) {
        this.remove(this.getWritableDatabase(), objects, updater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(android.database.sqlite.SQLiteDatabase openDatabase, List<? extends DatabaseObject> objects, ProgressUpdater updater) {
        int progress = 0;
        openDatabase.beginTransaction();
        try {
            for (DatabaseObject databaseObject : objects) {
                if (updater != null && !updater.onProgressState()) break;
                SQLQuery.Select select = databaseObject.getWhere();
                openDatabase.delete(select.tableName, select.where, select.whereArgs);
                if (updater == null) continue;
                updater.onProgressChange(objects.size(), progress++);
            }
            openDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
    }

    public int update(DatabaseObject object) {
        return this.update(this.getWritableDatabase(), object);
    }

    public int update(android.database.sqlite.SQLiteDatabase db, DatabaseObject object) {
        object.onUpdateObject(this);
        return this.update(db, object.getWhere(), object.getValues());
    }

    public int update(SQLQuery.Select select, ContentValues values) {
        return this.update(this.getWritableDatabase(), select, values);
    }

    public int update(android.database.sqlite.SQLiteDatabase database, SQLQuery.Select select, ContentValues values) {
        return database.update(select.tableName, values, select.where, select.whereArgs);
    }

    public void update(List<? extends DatabaseObject> objects) {
        this.update(objects, null);
    }

    public void update(List<? extends DatabaseObject> objects, ProgressUpdater updater) {
        this.update(this.getWritableDatabase(), objects, updater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(android.database.sqlite.SQLiteDatabase openDatabase, List<? extends DatabaseObject> objects, ProgressUpdater updater) {
        int progress = 0;
        openDatabase.beginTransaction();
        try {
            for (DatabaseObject databaseObject : objects) {
                if (updater != null && !updater.onProgressState()) break;
                SQLQuery.Select select = databaseObject.getWhere();
                openDatabase.update(select.tableName, databaseObject.getValues(), select.where, select.whereArgs);
                if (updater == null) continue;
                updater.onProgressChange(objects.size(), progress++);
            }
            openDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
    }

    public static interface ProgressUpdater {
        public void onProgressChange(int var1, int var2);

        public boolean onProgressState();
    }

    public static interface CastQueryListener<T extends DatabaseObject> {
        public void onObjectReconstructed(SQLiteDatabase var1, CursorItem var2, T var3);
    }
}

