/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.util.actionperformer;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.genonbeta.android.framework.object.Selectable;
import com.genonbeta.android.framework.util.actionperformer.CouldNotAlterException;
import com.genonbeta.android.framework.util.actionperformer.IEngineConnection;
import com.genonbeta.android.framework.util.actionperformer.IPerformerEngine;
import com.genonbeta.android.framework.util.actionperformer.PerformerEngineProvider;
import com.genonbeta.android.framework.util.actionperformer.SelectableHost;
import com.genonbeta.android.framework.util.actionperformer.SelectableNotFoundException;
import com.genonbeta.android.framework.util.actionperformer.SelectableProvider;
import java.util.ArrayList;
import java.util.List;

public class EngineConnection<T extends Selectable>
implements IEngineConnection<T> {
    public static final String TAG = EngineConnection.class.getSimpleName();
    private PerformerEngineProvider mEngineProvider;
    private SelectableProvider<T> mSelectableProvider;
    private SelectableHost<T> mSelectableHost;
    private CharSequence mDefinitiveTitle;
    private final List<IEngineConnection.SelectionListener<T>> mSelectionListenerList = new ArrayList<IEngineConnection.SelectionListener<T>>();

    public EngineConnection(@NonNull PerformerEngineProvider provider, @NonNull SelectableHost<T> host) {
        this.setEngineProvider(provider);
        this.setSelectableHost(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSelectionListener(IEngineConnection.SelectionListener<T> listener) {
        List<IEngineConnection.SelectionListener<T>> list = this.mSelectionListenerList;
        synchronized (list) {
            return this.mSelectionListenerList.contains(listener) || this.mSelectionListenerList.add(listener);
        }
    }

    protected boolean changeSelectionState(T selectable, boolean selected, int position) {
        if (selected != selectable.isSelectableSelected() && selectable.setSelectableSelected(selected)) {
            IPerformerEngine engine = this.getEngineProvider().getPerformerEngine();
            SelectableHost<T> host = this.getSelectableHost();
            if (selected) {
                host.getSelectableList().add(selectable);
            } else {
                host.getSelectableList().remove(selectable);
            }
            if (engine != null) {
                for (IEngineConnection.SelectionListener<T> listener : this.mSelectionListenerList) {
                    listener.onSelected(engine, this, selectable, selected, position);
                }
                engine.informListeners(this, selectable, selected, position);
            } else {
                Log.d((String)TAG, (String)"changeSelectionState: Engine is empty. Skipping the call for listeners!");
            }
            return true;
        }
        return false;
    }

    protected void changeSelectionState(List<T> selectableList, boolean selected, int[] positions) {
        IPerformerEngine engine = this.getEngineProvider().getPerformerEngine();
        for (Selectable selectable : selectableList) {
            if (selected == selectable.isSelectableSelected() || !selectable.setSelectableSelected(selected)) continue;
            if (selected) {
                this.getSelectedItemList().add(selectable);
                continue;
            }
            this.getSelectedItemList().remove(selectable);
        }
        if (engine != null) {
            for (IEngineConnection.SelectionListener selectionListener : this.mSelectionListenerList) {
                selectionListener.onSelected(engine, this, selectableList, selected, positions);
            }
            engine.informListeners(this, selectableList, selected, positions);
        } else {
            Log.d((String)TAG, (String)"changeSelectionState: Engine is empty. Skipping the call for listeners!");
        }
    }

    @Override
    @Nullable
    public CharSequence getDefinitiveTitle() {
        return this.mDefinitiveTitle;
    }

    @Override
    public PerformerEngineProvider getEngineProvider() {
        return this.mEngineProvider;
    }

    @Override
    public List<? extends Selectable> getGenericSelectedItemList() {
        return this.getSelectedItemList();
    }

    @Override
    public List<? extends Selectable> getGenericAvailableList() {
        return this.getAvailableList();
    }

    @Override
    public List<T> getSelectedItemList() {
        return this.getSelectableHost().getSelectableList();
    }

    @Override
    public List<T> getAvailableList() {
        return this.getSelectableProvider().getSelectableList();
    }

    @Override
    public SelectableHost<T> getSelectableHost() {
        return this.mSelectableHost;
    }

    @Override
    public SelectableProvider<T> getSelectableProvider() {
        return this.mSelectableProvider;
    }

    @Override
    public boolean isSelectedOnHost(T selectable) {
        return this.getSelectedItemList().contains(selectable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSelectionListener(IEngineConnection.SelectionListener<T> listener) {
        List<IEngineConnection.SelectionListener<T>> list = this.mSelectionListenerList;
        synchronized (list) {
            return this.mSelectionListenerList.remove(listener);
        }
    }

    @Override
    public void setDefinitiveTitle(CharSequence title) {
        this.mDefinitiveTitle = title;
    }

    @Override
    public void setEngineProvider(@Nullable PerformerEngineProvider engineProvider) {
        this.mEngineProvider = engineProvider;
    }

    @Override
    public void setSelectableHost(SelectableHost<T> host) {
        this.mSelectableHost = host;
    }

    @Override
    public void setSelectableProvider(@Nullable SelectableProvider<T> provider) {
        this.mSelectableProvider = provider;
    }

    @Override
    public boolean setSelected(RecyclerView.ViewHolder holder) throws SelectableNotFoundException, CouldNotAlterException {
        return this.setSelected(holder.getAdapterPosition());
    }

    @Override
    public boolean setSelected(int position) throws SelectableNotFoundException, CouldNotAlterException {
        try {
            return this.setSelected((Selectable)this.mSelectableProvider.getSelectableList().get(position), position);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SelectableNotFoundException("The selectable at the given position " + position + " could not be found. ");
        }
    }

    @Override
    public boolean setSelected(T selectable) throws CouldNotAlterException {
        return this.setSelected(selectable, -1);
    }

    @Override
    public boolean setSelected(T selectable, boolean selected) {
        return this.setSelected(selectable, -1, selected);
    }

    @Override
    public boolean setSelected(T selectable, int position) throws CouldNotAlterException {
        boolean newState;
        boolean bl = newState = !this.isSelectedOnHost(selectable);
        if (!this.setSelected(selectable, position, newState, true)) {
            throw new CouldNotAlterException("The selectable " + selectable + " state couldn't be altered. The reason may be that the engine was not available or selectable was not allowed to alter state");
        }
        return newState;
    }

    @Override
    public boolean setSelected(T selectable, int position, boolean selected) {
        return this.setSelected(selectable, position, selected, false);
    }

    @Override
    public boolean setSelected(List<T> selectableList, int[] positions, boolean selected) {
        IPerformerEngine engine = this.getEngineProvider().getPerformerEngine();
        if (engine != null && engine.check(this, selectableList, selected, positions)) {
            this.changeSelectionState(selectableList, selected, positions);
            return true;
        }
        return false;
    }

    private boolean setSelected(T selectable, int position, boolean selected, boolean checked) {
        if (!checked && selected == this.isSelectedOnHost(selectable)) {
            if (selectable.isSelectableSelected() != selected && !selectable.setSelectableSelected(selected)) {
                this.getSelectedItemList().remove(selectable);
                return false;
            }
            return selected;
        }
        IPerformerEngine performerEngine = this.getEngineProvider().getPerformerEngine();
        return performerEngine != null && performerEngine.check(this, selectable, selected, position) && this.changeSelectionState(selectable, selected, position);
    }
}

