/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.ui;

import android.content.Context;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.appcompat.view.SupportMenuInflater;
import com.genonbeta.android.framework.object.Selectable;
import com.genonbeta.android.framework.util.actionperformer.IBaseEngineConnection;
import com.genonbeta.android.framework.util.actionperformer.IPerformerEngine;
import com.genonbeta.android.framework.util.actionperformer.PerformerCallback;
import com.genonbeta.android.framework.util.actionperformer.PerformerListener;
import java.util.List;

public class PerformerMenu
implements PerformerCallback,
PerformerListener,
MenuItem.OnMenuItemClickListener {
    private final Context mContext;
    private final MenuInflater mMenuInflater;
    private final Callback mCallback;

    public PerformerMenu(Context context, @NonNull Callback callback) {
        this.mContext = context;
        this.mMenuInflater = new SupportMenuInflater(this.getContext());
        this.mCallback = callback;
    }

    public Context getContext() {
        return this.mContext;
    }

    public MenuInflater getMenuInflater() {
        return this.mMenuInflater;
    }

    public boolean invokeMenuItemSelected(MenuItem menuItem) {
        return this.mCallback.onPerformerMenuSelected(this, menuItem);
    }

    public boolean load(Menu targetMenu) {
        if (!this.populateMenu(targetMenu)) {
            return false;
        }
        for (int i = 0; i < targetMenu.size(); ++i) {
            targetMenu.getItem(i).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
        }
        return true;
    }

    public boolean populateMenu(Menu targetMenu) {
        return this.mCallback.onPerformerMenuList(this, this.getMenuInflater(), targetMenu);
    }

    public void setUp(IPerformerEngine engine) {
        engine.addPerformerListener(this);
        engine.addPerformerCallback(this);
    }

    public void dismantle(IPerformerEngine engine) {
        engine.removePerformerCallback(this);
        engine.removePerformerListener(this);
    }

    @Override
    public boolean onSelection(IPerformerEngine engine, IBaseEngineConnection owner, Selectable selectable, boolean isSelected, int position) {
        return this.mCallback.onPerformerMenuItemSelection(this, engine, owner, selectable, isSelected, position);
    }

    @Override
    public boolean onSelection(IPerformerEngine engine, IBaseEngineConnection owner, List<? extends Selectable> selectableList, boolean isSelected, int[] positions) {
        return this.mCallback.onPerformerMenuItemSelection(this, engine, owner, selectableList, isSelected, positions);
    }

    @Override
    public void onSelected(IPerformerEngine engine, IBaseEngineConnection owner, Selectable selectable, boolean isSelected, int position) {
        this.mCallback.onPerformerMenuItemSelected(this, engine, owner, selectable, isSelected, position);
    }

    @Override
    public void onSelected(IPerformerEngine engine, IBaseEngineConnection owner, List<? extends Selectable> selectableList, boolean isSelected, int[] positions) {
        this.mCallback.onPerformerMenuItemSelected(this, engine, owner, selectableList, isSelected, positions);
    }

    public boolean onMenuItemClick(MenuItem item) {
        return this.mCallback.onPerformerMenuSelected(this, item);
    }

    public static interface Callback {
        public boolean onPerformerMenuList(PerformerMenu var1, MenuInflater var2, Menu var3);

        public boolean onPerformerMenuSelected(PerformerMenu var1, MenuItem var2);

        public boolean onPerformerMenuItemSelection(PerformerMenu var1, IPerformerEngine var2, IBaseEngineConnection var3, Selectable var4, boolean var5, int var6);

        public boolean onPerformerMenuItemSelection(PerformerMenu var1, IPerformerEngine var2, IBaseEngineConnection var3, List<? extends Selectable> var4, boolean var5, int[] var6);

        public void onPerformerMenuItemSelected(PerformerMenu var1, IPerformerEngine var2, IBaseEngineConnection var3, Selectable var4, boolean var5, int var6);

        public void onPerformerMenuItemSelected(PerformerMenu var1, IPerformerEngine var2, IBaseEngineConnection var3, List<? extends Selectable> var4, boolean var5, int[] var6);
    }
}

