/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.io;

import android.net.Uri;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.genonbeta.android.framework.io.DocumentFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class LocalDocumentFile
extends DocumentFile {
    private File mFile;

    public LocalDocumentFile(DocumentFile parent, File file) {
        super(parent, Uri.fromFile((File)file));
        this.mFile = file;
    }

    @Override
    public DocumentFile createFile(String mimeType, String displayName) {
        String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
        if (extension != null) {
            displayName = displayName + "." + extension;
        }
        File target = new File(this.mFile, displayName);
        try {
            target.createNewFile();
            return new LocalDocumentFile((DocumentFile)this, target);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DocumentFile createDirectory(String displayName) {
        File target = new File(this.mFile, displayName);
        if (target.isDirectory() || target.mkdir()) {
            return new LocalDocumentFile((DocumentFile)this, target);
        }
        return null;
    }

    public File getFile() {
        return this.mFile;
    }

    @Override
    public Uri getUri() {
        return Uri.fromFile((File)this.mFile);
    }

    @Override
    public String getName() {
        return this.mFile.getName();
    }

    @Override
    public DocumentFile getParentFile() {
        File parentFile = this.mFile.getParentFile();
        return parentFile == null || File.separator.equals(parentFile.getAbsolutePath()) ? null : new LocalDocumentFile(null, parentFile);
    }

    @Override
    public String getType() {
        if (this.mFile.isDirectory()) {
            return "*/*";
        }
        return LocalDocumentFile.getTypeForName(this.mFile.getName());
    }

    @Override
    public boolean isDirectory() {
        return this.mFile.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.mFile.isFile();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public long lastModified() {
        return this.mFile.lastModified();
    }

    @Override
    public long length() {
        return this.mFile.length();
    }

    @Override
    public boolean canRead() {
        return this.mFile.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.mFile.canWrite();
    }

    @Override
    public boolean delete() {
        LocalDocumentFile.deleteContents(this.mFile);
        return this.mFile.delete();
    }

    @Override
    public boolean exists() {
        return this.mFile.exists();
    }

    @Override
    public DocumentFile findFile(String displayName) {
        File file = new File(this.mFile, displayName);
        return file.exists() ? new LocalDocumentFile((DocumentFile)this, file) : null;
    }

    @Override
    public DocumentFile[] listFiles() {
        ArrayList<LocalDocumentFile> results = new ArrayList<LocalDocumentFile>();
        File[] files = this.mFile.listFiles();
        if (files != null) {
            for (File file : files) {
                results.add(new LocalDocumentFile((DocumentFile)this, file));
            }
        }
        return results.toArray(new DocumentFile[results.size()]);
    }

    @Override
    public boolean renameTo(String displayName) {
        File target = new File(this.mFile.getParentFile(), displayName);
        if (this.mFile.renameTo(target)) {
            this.mFile = target;
            return true;
        }
        return false;
    }

    @Override
    public void sync() {
    }

    private static String getTypeForName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            String extension = name.substring(lastDot + 1).toLowerCase();
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            if (mime != null) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    private static boolean deleteContents(File dir) {
        File[] files = dir.listFiles();
        boolean success = true;
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    success &= LocalDocumentFile.deleteContents(file);
                }
                if (file.delete()) continue;
                Log.w((String)TAG, (String)("Failed to delete " + file));
                success = false;
            }
        }
        return success;
    }
}

