/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.util.date;

public class ElapsedTime {
    private long mElapsedTime;
    private long mYears;
    private long mMonths;
    private long mDays;
    private long mHours;
    private long mMinutes;
    private long mSeconds;

    public ElapsedTime(long time) {
        this.set(time);
    }

    public long getElapsedTime() {
        return this.mElapsedTime;
    }

    public long getDays() {
        return this.mDays;
    }

    public long getHours() {
        return this.mHours;
    }

    public long getMinutes() {
        return this.mMinutes;
    }

    public long getMonths() {
        return this.mMonths;
    }

    public long getSeconds() {
        return this.mSeconds;
    }

    public long getYears() {
        return this.mYears;
    }

    public void set(long time) {
        this.mElapsedTime = time;
        ElapsedTimeCalculator calculator = new ElapsedTimeCalculator(time / 1000L);
        this.mYears = calculator.crop(62208000L);
        this.mMonths = calculator.crop(2592000L);
        this.mDays = calculator.crop(86400L);
        this.mHours = calculator.crop(3600L);
        this.mMinutes = calculator.crop(60L);
        this.mSeconds = calculator.getLeftTime();
    }

    public static class ElapsedTimeCalculator {
        private long mTime;

        public ElapsedTimeCalculator(long time) {
            this.mTime = time;
        }

        public long crop(long summonBy) {
            long result = 0L;
            if (this.getLeftTime() > summonBy) {
                result = this.getLeftTime() / summonBy;
                this.setTime(this.getLeftTime() - result * summonBy);
            }
            return result;
        }

        public long getLeftTime() {
            return this.mTime;
        }

        public void setTime(long time) {
            this.mTime = time;
        }
    }
}

