/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.io;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.genonbeta.android.framework.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.URI;

public class StreamInfo {
    public String friendlyName;
    public String mimeType;
    public Uri uri;
    public Type type;
    public long size;
    @Nullable
    public File file;
    private ContentResolver mResolver;

    public StreamInfo() {
    }

    public StreamInfo(Context context, Uri uri) throws FileNotFoundException, StreamCorruptedException, FolderStateException {
        if (!this.loadStream(context, uri)) {
            throw new StreamCorruptedException("Content was not able to route a stream. Empty result is returned");
        }
    }

    public static StreamInfo getStreamInfo(Context context, Uri uri) throws FileNotFoundException, StreamCorruptedException, FolderStateException {
        return new StreamInfo(context, uri);
    }

    private boolean loadStream(Context context, Uri uri) throws FolderStateException, FileNotFoundException {
        File file;
        String uriType = uri.toString();
        this.uri = uri;
        if (uriType.startsWith("content")) {
            this.mResolver = context.getContentResolver();
            Cursor cursor = this.mResolver.query(uri, null, null, null, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    int nameIndex = cursor.getColumnIndex("_display_name");
                    int sizeIndex = cursor.getColumnIndex("_size");
                    if (nameIndex != -1 && sizeIndex != -1) {
                        this.friendlyName = cursor.getString(nameIndex);
                        this.size = cursor.getLong(sizeIndex);
                        this.mimeType = this.mResolver.getType(uri);
                        this.type = Type.Stream;
                        return true;
                    }
                }
                cursor.close();
            }
        } else if (uriType.startsWith("file") && (file = new File(URI.create(uriType))).canRead()) {
            if (file.isDirectory()) {
                throw new FolderStateException();
            }
            this.friendlyName = file.getName();
            this.size = file.length();
            this.mimeType = FileUtils.getFileContentType(file.getName());
            this.type = Type.File;
            this.file = file;
            return true;
        }
        return false;
    }

    public ContentResolver getContentResolver() {
        return this.mResolver;
    }

    public OutputStream openOutputStream() throws FileNotFoundException {
        return this.file == null ? this.getContentResolver().openOutputStream(this.uri, "wa") : new FileOutputStream(this.file, true);
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return this.file == null ? this.getContentResolver().openInputStream(this.uri) : new FileInputStream(this.file);
    }

    public static class FolderStateException
    extends Exception {
    }

    public static enum Type {
        Stream,
        File;

    }
}

