/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.recyclerview.widget.RecyclerView;
import com.genonbeta.android.framework.object.Selectable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PowerfulActionEngine<ReturningObject extends PowerfulActionEngineImpl> {
    private Context mContext;
    private EngineCallback<ReturningObject> mEngineCallback;
    private Map<Callback, Holder> mActiveActionModes = new ArrayMap();

    public PowerfulActionEngine(Context context, EngineCallback<ReturningObject> engineCallback) {
        this.mContext = context;
        this.mEngineCallback = engineCallback;
    }

    public <T extends Selectable> boolean check(@NonNull Callback<T, ReturningObject> callback, T selectable, boolean selected, int position) {
        if (!selectable.setSelectableSelected(selected)) {
            return false;
        }
        if (!this.hasActive(callback)) {
            this.start(callback);
        }
        if (!this.mEngineCallback.onCheck(callback, selectable, selected, position)) {
            return false;
        }
        if (selected) {
            this.getHolder(callback).getSelectionList().add(selectable);
        } else {
            this.getHolder(callback).getSelectionList().remove(selectable);
        }
        callback.onItemChecked(this.getContext(), this.mEngineCallback.onReturningObject(), selectable, position);
        return true;
    }

    public void finish(@NonNull Callback callback) {
        Holder holder = this.mActiveActionModes.get(callback);
        if (holder != null && this.mEngineCallback.onFinish(callback)) {
            callback.onFinish(this.getContext(), this.mEngineCallback.onReturningObject());
            this.mActiveActionModes.remove(callback);
            this.reload(callback);
        }
    }

    public Map<Callback, Holder> getActiveActionModes() {
        return this.mActiveActionModes;
    }

    public Context getContext() {
        return this.mContext;
    }

    public <T extends Selectable> Holder<T> getHolder(Callback<T, ReturningObject> callback) {
        return this.mActiveActionModes.get(callback);
    }

    public boolean hasActive(Callback callback) {
        return this.mActiveActionModes.containsKey(callback);
    }

    public boolean reload(Callback callback) {
        if (callback == null || !this.mActiveActionModes.containsKey(callback) || !this.mEngineCallback.onReload(callback)) {
            this.finish(callback);
            return false;
        }
        return true;
    }

    public <T extends Selectable> boolean start(@NonNull Callback<T, ReturningObject> callback) {
        return this.start(callback, false);
    }

    public <T extends Selectable> boolean start(@NonNull Callback<T, ReturningObject> callback, boolean forceStart) {
        if (this.mActiveActionModes.containsKey(callback) && !forceStart || !this.mEngineCallback.onStart(callback, forceStart)) {
            this.finish(callback);
            return false;
        }
        this.mActiveActionModes.put(callback, new Holder());
        return this.reload(callback);
    }

    public static class Implementation
    implements PowerfulActionEngineImpl {
        private PowerfulActionEngine mEngine;

        public Implementation(PowerfulActionEngine engine) {
            this.mEngine = engine;
        }

        @Override
        public <T extends Selectable, M extends PowerfulActionEngineImpl> boolean check(@NonNull Callback<T, M> callback, T selectable, boolean selected, int position) {
            return this.mEngine.check(callback, selectable, selected, position);
        }

        @Override
        public void finish(@NonNull Callback callback) {
            this.mEngine.finish(callback);
        }

        @Override
        public <T extends Selectable, M extends PowerfulActionEngineImpl> Holder<T> getHolder(Callback<T, M> callback) {
            return this.mEngine.getHolder(callback);
        }

        @Override
        public boolean hasActive(Callback callback) {
            return this.mEngine.hasActive(callback);
        }

        @Override
        public boolean reload(Callback callback) {
            return this.mEngine.reload(callback);
        }

        @Override
        public <T extends Selectable, M extends PowerfulActionEngineImpl> boolean start(@NonNull Callback<T, M> callback) {
            return this.mEngine.start(callback);
        }

        @Override
        public <T extends Selectable, M extends PowerfulActionEngineImpl> boolean start(@NonNull Callback<T, M> callback, boolean forceStart) {
            return this.mEngine.start(callback, forceStart);
        }
    }

    public static interface OnSelectionTaskListener<ReturningObject extends PowerfulActionEngineImpl> {
        public void onSelectionTask(boolean var1, ReturningObject var2);
    }

    public static interface PowerfulActionEngineImpl {
        public <T extends Selectable, M extends PowerfulActionEngineImpl> boolean check(@NonNull Callback<T, M> var1, T var2, boolean var3, int var4);

        public void finish(@NonNull Callback var1);

        public <T extends Selectable, M extends PowerfulActionEngineImpl> Holder<T> getHolder(Callback<T, M> var1);

        public boolean hasActive(Callback var1);

        public boolean reload(Callback var1);

        public <T extends Selectable, M extends PowerfulActionEngineImpl> boolean start(@NonNull Callback<T, M> var1);

        public <T extends Selectable, M extends PowerfulActionEngineImpl> boolean start(@NonNull Callback<T, M> var1, boolean var2);
    }

    public static class Holder<T extends Selectable> {
        private final List<T> mSelectionList = new ArrayList<T>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<T> getSelectionList() {
            List<T> list = this.mSelectionList;
            synchronized (list) {
                return this.mSelectionList;
            }
        }
    }

    public static class SelectorConnection<T extends Selectable, ReturningObject extends PowerfulActionEngineImpl> {
        private ReturningObject mMode;
        private Callback<T, ReturningObject> mCallback;

        public SelectorConnection(ReturningObject mode, Callback<T, ReturningObject> callback) {
            this.mMode = mode;
            this.mCallback = callback;
        }

        public Callback<T, ReturningObject> getCallback() {
            return this.mCallback;
        }

        public ReturningObject getMode() {
            return this.mMode;
        }

        public List<T> getSelectedItemList() {
            Holder<T> holder = this.getMode().getHolder(this.getCallback());
            return holder == null ? new ArrayList() : holder.getSelectionList();
        }

        public boolean isSelected(T selectable) {
            Holder<T> holder = this.getMode().getHolder(this.getCallback());
            return holder != null && holder.getSelectionList().contains(selectable);
        }

        public boolean selectionActive() {
            return this.getMode().hasActive(this.getCallback());
        }

        public boolean setSelected(RecyclerView.ViewHolder holder) {
            return this.setSelected(holder.getAdapterPosition());
        }

        public boolean setSelected(int position) {
            return this.setSelected((Selectable)this.getCallback().getSelectableList().get(position), position);
        }

        public boolean setSelected(T selectable) {
            return this.setSelected(selectable, !this.isSelected(selectable), -1);
        }

        public boolean setSelected(T selectable, boolean selected) {
            return this.setSelected(selectable, selected, -1);
        }

        public boolean setSelected(T selectable, int position) {
            return this.setSelected(selectable, !this.isSelected(selectable), position);
        }

        public boolean setSelected(T selectable, boolean selected, int position) {
            if (selected == this.isSelected(selectable)) {
                return selected;
            }
            return this.getMode().check(this.getCallback(), selectable, selected, position);
        }

        public boolean removeSelected(T selectable) {
            if (!this.getMode().hasActive(this.getCallback())) {
                return false;
            }
            return this.getMode().getHolder(this.getCallback()).getSelectionList().remove(selectable);
        }
    }

    public static interface Callback<T extends Selectable, ReturningObject extends PowerfulActionEngineImpl> {
        public List<T> getSelectableList();

        public void onItemChecked(Context var1, ReturningObject var2, T var3, int var4);

        public void onFinish(Context var1, ReturningObject var2);
    }

    public static interface EngineCallback<ReturningObject extends PowerfulActionEngineImpl> {
        public <T extends Selectable> boolean onStart(@NonNull Callback<T, ReturningObject> var1, boolean var2);

        public boolean onReload(Callback var1);

        public <T extends Selectable> boolean onCheck(Callback<T, ReturningObject> var1, T var2, boolean var3, int var4);

        public boolean onFinish(Callback var1);

        public ReturningObject onReturningObject();
    }
}

