/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.content.Context;
import android.view.View;
import androidx.annotation.AnimatorRes;
import com.genonbeta.android.framework.R;

public class VisibilityAnimationManager {
    protected final View mView;
    protected AnimatorSet mHideAnimator;
    protected AnimatorSet mShowAnimator;
    private float mPivotXRelative;
    private float mPivotYRelative;

    protected VisibilityAnimationManager(final View view, @AnimatorRes int showAnimator, @AnimatorRes int hideAnimator, float pivotXRelative, float pivotYRelative, int hideDelay) {
        this.mView = view;
        this.mPivotXRelative = pivotXRelative;
        this.mPivotYRelative = pivotYRelative;
        this.mHideAnimator = (AnimatorSet)AnimatorInflater.loadAnimator((Context)view.getContext(), (int)hideAnimator);
        this.mHideAnimator.setStartDelay((long)hideDelay);
        this.mHideAnimator.setTarget((Object)view);
        this.mShowAnimator = (AnimatorSet)AnimatorInflater.loadAnimator((Context)view.getContext(), (int)showAnimator);
        this.mShowAnimator.setTarget((Object)view);
        this.mHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean mWasCanceled;

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (!this.mWasCanceled) {
                    view.setVisibility(4);
                }
                this.mWasCanceled = false;
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.mWasCanceled = true;
            }
        });
        this.updatePivot();
    }

    public void show() {
        this.mHideAnimator.cancel();
        if (this.mView.getVisibility() == 4) {
            this.mView.setVisibility(0);
            this.updatePivot();
            this.mShowAnimator.start();
        }
    }

    public void hide() {
        this.updatePivot();
        this.mHideAnimator.start();
    }

    protected void updatePivot() {
        this.mView.setPivotX(this.mPivotXRelative * (float)this.mView.getMeasuredWidth());
        this.mView.setPivotY(this.mPivotYRelative * (float)this.mView.getMeasuredHeight());
    }

    public static class Builder
    extends AbsBuilder<VisibilityAnimationManager> {
        public Builder(View view) {
            super(view);
        }

        @Override
        public VisibilityAnimationManager build() {
            return new VisibilityAnimationManager(this.mView, this.mShowAnimatorResource, this.mHideAnimatorResource, this.mPivotX, this.mPivotY, this.mHideDelay);
        }
    }

    public static abstract class AbsBuilder<T extends VisibilityAnimationManager> {
        protected final View mView;
        protected int mShowAnimatorResource = R.animator.genfw_fastscroll_default_show;
        protected int mHideAnimatorResource = R.animator.genfw_fastscroll_default_hide;
        protected int mHideDelay = 1000;
        protected float mPivotX = 0.5f;
        protected float mPivotY = 0.5f;

        public AbsBuilder(View view) {
            this.mView = view;
        }

        public AbsBuilder<T> withShowAnimator(@AnimatorRes int showAnimatorResource) {
            this.mShowAnimatorResource = showAnimatorResource;
            return this;
        }

        public AbsBuilder<T> withHideAnimator(@AnimatorRes int hideAnimatorResource) {
            this.mHideAnimatorResource = hideAnimatorResource;
            return this;
        }

        public AbsBuilder<T> withHideDelay(int hideDelay) {
            this.mHideDelay = hideDelay;
            return this;
        }

        public AbsBuilder<T> withPivotX(float pivotX) {
            this.mPivotX = pivotX;
            return this;
        }

        public AbsBuilder<T> withPivotY(float pivotY) {
            this.mPivotY = pivotY;
            return this;
        }

        public abstract T build();
    }
}

