/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.util;

import android.content.SharedPreferences;
import android.util.Log;
import com.genonbeta.android.framework.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class PreferenceUtils {
    public static final String TAG = PreferenceUtils.class.getSimpleName();

    public static <T> boolean applyGeneric(String key, T object, SharedPreferences.Editor editor) {
        Log.d((String)TAG, (String)("Put setting: " + key + " => " + String.valueOf(object)));
        if (object instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)object).booleanValue());
        } else if (object instanceof Float) {
            editor.putFloat(key, ((Float)object).floatValue());
        } else if (object instanceof Integer) {
            editor.putInt(key, ((Integer)object).intValue());
        } else if (object instanceof Long) {
            editor.putLong(key, ((Long)object).longValue());
        } else if (object instanceof String) {
            editor.putString(key, (String)object);
        } else if (object instanceof Set) {
            editor.putStringSet(key, (Set)object);
        } else {
            return false;
        }
        return true;
    }

    public static int sync(SharedPreferences ... objects) {
        if (objects.length < 2) {
            return 0;
        }
        ArrayList<SharedPreferences> preferencesList = new ArrayList<SharedPreferences>(Arrays.asList(objects));
        Collections.sort(preferencesList, new Comparator<SharedPreferences>(){

            @Override
            public int compare(SharedPreferences source1, SharedPreferences source2) {
                long comp1 = source1.getLong("__SYNC_TIME", (long)source1.getAll().size());
                long comp2 = source2.getLong("__SYNC_TIME", (long)source2.getAll().size());
                return MathUtils.compare(comp2, comp1);
            }
        });
        long syncTime = System.currentTimeMillis();
        SharedPreferences chosenSource = (SharedPreferences)preferencesList.get(0);
        chosenSource.edit().apply();
        Map items = chosenSource.getAll();
        preferencesList.remove(0);
        int totalRegistered = 0;
        for (SharedPreferences syncingPreference : preferencesList) {
            totalRegistered += PreferenceUtils.syncPreferences(items, syncingPreference, syncTime);
        }
        return totalRegistered;
    }

    public static int syncPreferences(SharedPreferences from, SharedPreferences to) {
        return PreferenceUtils.syncPreferences(from.getAll(), to);
    }

    public static int syncPreferences(Map<String, ?> from, SharedPreferences to) {
        return PreferenceUtils.syncPreferences(from, to, System.currentTimeMillis());
    }

    public static int syncPreferences(Map<String, ?> from, SharedPreferences to, long syncTime) {
        int totalRegistered = 0;
        SharedPreferences.Editor editor = to.edit();
        for (String key : from.keySet()) {
            if (!PreferenceUtils.applyGeneric(key, from.get(key), editor)) continue;
            ++totalRegistered;
        }
        editor.apply();
        return totalRegistered;
    }
}

