/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.genonbeta.android.framework.widget.recyclerview.FastScroller;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider.ViewBehavior;

public abstract class ScrollerViewProvider {
    private FastScroller mScroller;
    private ViewBehavior mHandleBehavior;
    private ViewBehavior mBubbleBehavior;

    public void setFastScroller(FastScroller scroller) {
        this.mScroller = scroller;
    }

    protected Context getContext() {
        return this.mScroller.getContext();
    }

    protected FastScroller getScroller() {
        return this.mScroller;
    }

    public abstract View provideHandleView(ViewGroup var1);

    public abstract View provideBubbleView(ViewGroup var1);

    public abstract TextView provideBubbleTextView();

    public abstract int getBubbleOffset();

    @Nullable
    protected abstract ViewBehavior provideHandleBehavior();

    @Nullable
    protected abstract ViewBehavior provideBubbleBehavior();

    protected ViewBehavior getHandleBehavior() {
        if (this.mHandleBehavior == null) {
            this.mHandleBehavior = this.provideHandleBehavior();
        }
        return this.mHandleBehavior;
    }

    protected ViewBehavior getBubbleBehavior() {
        if (this.mBubbleBehavior == null) {
            this.mBubbleBehavior = this.provideBubbleBehavior();
        }
        return this.mBubbleBehavior;
    }

    public void onHandleGrabbed() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onHandleGrabbed();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onHandleGrabbed();
        }
    }

    public void onHandleReleased() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onHandleReleased();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onHandleReleased();
        }
    }

    public void onScrollStarted() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onScrollStarted();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onScrollStarted();
        }
    }

    public void onScrollFinished() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onScrollFinished();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onScrollFinished();
        }
    }
}

