/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget;

import android.content.Context;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.AnimationUtils;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.Toolbar;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.framework.object.Selectable;
import com.genonbeta.android.framework.widget.PowerfulActionEngine;

public abstract class PowerfulActionToolbar<E extends Toolbar, ReturningObject extends PowerfulActionEngine.PowerfulActionEngineImpl>
implements PowerfulActionEngine.EngineCallback<ReturningObject> {
    private E mToolbar;
    private Context mContext;
    private View mContainerLayout;
    private MenuInflater mMenuInflater;
    private PowerfulActionEngine mEngine;
    private PowerfulActionEngine.OnSelectionTaskListener<ReturningObject> mTaskListener;
    private boolean mFinishAllowed = true;

    public PowerfulActionToolbar(Context context, E toolbar) {
        this.mContext = context;
        this.mToolbar = toolbar;
        this.mMenuInflater = new MenuInflater(this.getContext());
        this.mEngine = new PowerfulActionEngine(context, this);
    }

    public boolean isFinishAllowed() {
        return this.mFinishAllowed;
    }

    public View getContainerLayout() {
        return this.mContainerLayout;
    }

    public Context getContext() {
        return this.mContext;
    }

    public PowerfulActionEngine getEngine() {
        return this.mEngine;
    }

    public MenuInflater getMenuInflater() {
        return this.mMenuInflater;
    }

    public E getToolbar() {
        return this.mToolbar;
    }

    public void setContainerLayout(View containerLayout) {
        this.mContainerLayout = containerLayout;
    }

    public void setOnSelectionTaskListener(PowerfulActionEngine.OnSelectionTaskListener taskListener) {
        this.mTaskListener = taskListener;
    }

    public void setFinishAllowed(boolean allow) {
        this.mFinishAllowed = allow;
    }

    protected void updateVisibility(int visibility) {
        Object view;
        int animationId = visibility == 0 ? 0x10A0000 : 0x10A0001;
        Object object = view = this.getContainerLayout() == null ? this.mToolbar : this.getContainerLayout();
        if (visibility == 0) {
            view.setVisibility(visibility);
            view.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationId));
            if (this.mTaskListener != null) {
                this.mTaskListener.onSelectionTask(true, this.onReturningObject());
            }
        } else {
            view.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationId));
            view.setVisibility(visibility);
            if (this.mTaskListener != null) {
                this.mTaskListener.onSelectionTask(false, this.onReturningObject());
            }
        }
    }

    @Override
    public <T extends Selectable> boolean onStart(@NonNull PowerfulActionEngine.Callback<T, ReturningObject> callback, boolean forceStart) {
        return callback instanceof ToolbarCallback && ((ToolbarCallback)callback).onPrepareActionMenu(this.getContext(), this.onReturningObject());
    }

    @Override
    public boolean onReload(final PowerfulActionEngine.Callback callback) {
        boolean result;
        this.getToolbar().getMenu().clear();
        this.updateVisibility(0);
        if (this.mFinishAllowed) {
            this.getToolbar().setNavigationIcon(R.drawable.genfw_close_white_24dp);
            this.getToolbar().setNavigationContentDescription(0x1040000);
            this.getToolbar().setNavigationOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PowerfulActionToolbar.this.mEngine.finish(callback);
                }
            });
        }
        boolean bl = result = callback instanceof ToolbarCallback && ((ToolbarCallback)callback).onCreateActionMenu(this.getContext(), this.onReturningObject(), this.getToolbar().getMenu());
        if (result) {
            MenuItem.OnMenuItemClickListener defListener = new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem menuItem) {
                    boolean didTrigger;
                    boolean bl = didTrigger = callback instanceof ToolbarCallback && ((ToolbarCallback)callback).onActionMenuItemSelected(PowerfulActionToolbar.this.getContext(), PowerfulActionToolbar.this.onReturningObject(), menuItem);
                    if (didTrigger && PowerfulActionToolbar.this.mFinishAllowed) {
                        PowerfulActionToolbar.this.mEngine.finish(callback);
                    }
                    return didTrigger;
                }
            };
            for (int menuPos = 0; menuPos < this.getToolbar().getMenu().size(); ++menuPos) {
                this.getToolbar().getMenu().getItem(menuPos).setOnMenuItemClickListener(defListener);
            }
        }
        return true;
    }

    @Override
    public <E extends Selectable> boolean onCheck(PowerfulActionEngine.Callback<E, ReturningObject> callback, E selectable, boolean selected, int position) {
        return true;
    }

    @Override
    public boolean onFinish(PowerfulActionEngine.Callback callback) {
        this.updateVisibility(8);
        return true;
    }

    public static interface ToolbarCallback<T extends Selectable, ReturningObject extends PowerfulActionEngine.PowerfulActionEngineImpl>
    extends PowerfulActionEngine.Callback<T, ReturningObject> {
        public boolean onPrepareActionMenu(Context var1, ReturningObject var2);

        public boolean onCreateActionMenu(Context var1, ReturningObject var2, Menu var3);

        public boolean onActionMenuItemSelected(Context var1, ReturningObject var2, MenuItem var3);
    }
}

