/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import java.lang.ref.WeakReference;

public class SweetImageLoader<Object, ImageType>
extends AsyncTask<Object, Void, ImageType> {
    @SuppressLint(value={"StaticFieldLeak"})
    private Context mContext;
    private Object mObject;
    private Handler<Object, ImageType> mHandler;
    private WeakReference<ImageView> mImageViewReference;

    public SweetImageLoader(Handler<Object, ImageType> handler, Context context) {
        this.mHandler = handler;
        this.mContext = context;
    }

    protected void onPostExecute(ImageType image) {
        ImageView imageView = (ImageView)this.getImageViewReference().get();
        if (this.isCancelled() || imageView == null) {
            return;
        }
        Holder holder = (Holder)imageView.getTag();
        if (this.getObject().equals(holder.getObject())) {
            imageView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000));
            if (!this.isCancelled() && image != null) {
                if (image instanceof Bitmap) {
                    imageView.setImageBitmap((Bitmap)image);
                } else if (image instanceof Drawable) {
                    imageView.setImageDrawable((Drawable)image);
                } else {
                    throw new UnsupportedOperationException("Class for loading is not supported: " + image.getClass().getName());
                }
            }
        }
    }

    @SafeVarargs
    protected final ImageType doInBackground(Object ... params) {
        this.mObject = params[0];
        return this.mHandler.onLoadBitmap(this.getObject());
    }

    public Context getContext() {
        return this.mContext;
    }

    public WeakReference<ImageView> getImageViewReference() {
        return this.mImageViewReference;
    }

    public Object getObject() {
        return this.mObject;
    }

    public void setImageView(ImageView imageView) {
        this.mImageViewReference = new WeakReference<ImageView>(imageView);
    }

    public void setObject(Object object) {
        this.mObject = object;
    }

    public static <J, Y> void load(Handler<J, Y> handler, Context context, ImageView imageView, J object) {
        Holder viewHolder;
        if (imageView.getTag() == null) {
            imageView.setTag((Object)new Holder());
        }
        if (!object.equals((viewHolder = (Holder)imageView.getTag()).getObject())) {
            if (viewHolder.getSweetImageLoader() != null) {
                viewHolder.getSweetImageLoader().cancel(true);
            }
            imageView.setImageBitmap(null);
            viewHolder.object = object;
            viewHolder.sweetImageLoader = new SweetImageLoader<J, Y>(handler, context);
            viewHolder.getSweetImageLoader().setImageView(imageView);
            viewHolder.getSweetImageLoader().execute(new Object[]{object});
        }
    }

    private static class Holder {
        public SweetImageLoader sweetImageLoader;
        public Object object;

        private Holder() {
        }

        public Object getObject() {
            return this.object;
        }

        public SweetImageLoader getSweetImageLoader() {
            return this.sweetImageLoader;
        }
    }

    public static interface Handler<V, L> {
        public L onLoadBitmap(V var1);
    }
}

