/*
 * Decompiled with CFR 0.152.
 */
package com.gemalto.jp2;

import android.graphics.Bitmap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class JP2Encoder {
    private static final String TAG = "JP2Encoder";
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;
    private static final int DEFAULT_NUM_RESOLUTIONS = 6;
    public static final int FORMAT_J2K = 0;
    public static final int FORMAT_JP2 = 1;
    private int numResolutions = 6;
    private float[] compressionRatios = null;
    private float[] qualityValues = null;
    private int outputFormat = 1;
    private final Bitmap bmp;
    private static final int MIN_RESOLUTIONS = 1;
    private static final int MAX_RESOLUTIONS_GLOBAL = 32;
    private final int maxResolutions;

    public JP2Encoder(Bitmap bmp) {
        if (bmp == null) {
            throw new IllegalArgumentException("Bitmap must not be null!");
        }
        this.bmp = bmp;
        this.maxResolutions = Math.min(JP2Encoder.log2RoundedDown(Math.min(bmp.getWidth(), bmp.getHeight())) + 1, 32);
        if (this.numResolutions > this.maxResolutions) {
            this.numResolutions = this.maxResolutions;
        }
    }

    public JP2Encoder setNumResolutions(int numResolutions) {
        if (numResolutions < 1 || numResolutions > this.maxResolutions) {
            throw new IllegalArgumentException("Maximum number of resolutions for this image is between 1 and " + this.maxResolutions);
        }
        this.numResolutions = numResolutions;
        return this;
    }

    public JP2Encoder setCompressionRatio(float ... compressionRatios) {
        if (compressionRatios == null || compressionRatios.length == 0) {
            this.compressionRatios = null;
            return this;
        }
        for (float compressionRatio : compressionRatios) {
            if (!(compressionRatio < 1.0f)) continue;
            throw new IllegalArgumentException("compression ratio must be at least 1");
        }
        if (this.qualityValues != null) {
            throw new IllegalArgumentException("setCompressionRatios and setQualityValues must not be used together!");
        }
        compressionRatios = this.sort(compressionRatios, false, 1.0f);
        this.compressionRatios = compressionRatios;
        return this;
    }

    public JP2Encoder setVisualQuality(float ... qualityValues) {
        if (qualityValues == null || qualityValues.length == 0) {
            this.qualityValues = null;
            return this;
        }
        for (float qualityValue : qualityValues) {
            if (!(qualityValue < 0.0f)) continue;
            throw new IllegalArgumentException("quality values must not be negative");
        }
        if (this.compressionRatios != null) {
            throw new IllegalArgumentException("setCompressionRatios and setQualityValues must not be used together!");
        }
        qualityValues = this.sort(qualityValues, true, 0.0f);
        this.qualityValues = qualityValues;
        return this;
    }

    public JP2Encoder setOutputFormat(@OutputFormat int outputFormat) {
        if (outputFormat != 0 && outputFormat != 1) {
            throw new IllegalArgumentException("output format must be FORMAT_JP2 or FORMAT_J2K!");
        }
        this.outputFormat = outputFormat;
        return this;
    }

    public byte[] encode() {
        return this.encodeInternal(this.bmp);
    }

    public boolean encode(String fileName) {
        return this.encodeInternal(this.bmp, fileName);
    }

    public int encode(OutputStream out) throws IOException {
        byte[] data = this.encodeInternal(this.bmp);
        if (data == null) {
            return 0;
        }
        out.write(data);
        return data.length;
    }

    private byte[] encodeInternal(Bitmap bmp) {
        if (bmp == null) {
            return null;
        }
        int[] pixels = new int[bmp.getWidth() * bmp.getHeight()];
        bmp.getPixels(pixels, 0, bmp.getWidth(), 0, 0, bmp.getWidth(), bmp.getHeight());
        long start = 0L;
        byte[] ret = JP2Encoder.encodeJP2ByteArray(pixels, bmp.hasAlpha(), bmp.getWidth(), bmp.getHeight(), this.outputFormat, this.numResolutions, this.compressionRatios, this.qualityValues);
        return ret;
    }

    private boolean encodeInternal(Bitmap bmp, String fileName) {
        if (bmp == null) {
            return false;
        }
        int[] pixels = new int[bmp.getWidth() * bmp.getHeight()];
        bmp.getPixels(pixels, 0, bmp.getWidth(), 0, 0, bmp.getWidth(), bmp.getHeight());
        long start = 0L;
        int ret = JP2Encoder.encodeJP2File(fileName, pixels, bmp.hasAlpha(), bmp.getWidth(), bmp.getHeight(), this.outputFormat, this.numResolutions, this.compressionRatios, this.qualityValues);
        return ret == 0;
    }

    private static int log2RoundedDown(int n) {
        for (int i = 0; i < 32; ++i) {
            if (1 << i <= n) continue;
            return i - 1;
        }
        return 32;
    }

    private float[] sort(float[] array, final boolean ascending, final float losslessValue) {
        if (array == null || array.length == 0) {
            return null;
        }
        ArrayList<Float> list = new ArrayList<Float>();
        for (float value : array) {
            if (list.contains(Float.valueOf(value))) continue;
            list.add(Float.valueOf(value));
        }
        Collections.sort(list, new Comparator<Float>(){

            @Override
            public int compare(Float o1, Float o2) {
                if (o1.floatValue() == losslessValue && o2.floatValue() != losslessValue) {
                    return 1;
                }
                if (o2.floatValue() == losslessValue && o1.floatValue() != losslessValue) {
                    return -1;
                }
                return (int)Math.signum(ascending ? o1.floatValue() - o2.floatValue() : o2.floatValue() - o1.floatValue());
            }
        });
        float[] ret = new float[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((Float)list.get(i)).floatValue();
        }
        return ret;
    }

    private static native int encodeJP2File(String var0, int[] var1, boolean var2, int var3, int var4, int var5, int var6, float[] var7, float[] var8);

    private static native byte[] encodeJP2ByteArray(int[] var0, boolean var1, int var2, int var3, int var4, int var5, float[] var6, float[] var7);

    static {
        System.loadLibrary("openjpeg");
    }

    public static @interface OutputFormat {
    }
}

