/*
 * Decompiled with CFR 0.152.
 */
package com.gemalto.jp2;

import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class JP2Decoder {
    private static final String TAG = "JP2Decoder";
    private static final byte[] JP2_RFC3745_MAGIC;
    private static final byte[] JP2_MAGIC;
    private static final byte[] J2K_CODESTREAM_MAGIC;
    private byte[] data = null;
    private String fileName = null;
    private InputStream is = null;
    private int skipResolutions = 0;
    private int layersToDecode = 0;
    private boolean premultiplication = true;

    public JP2Decoder(byte[] data) {
        this.data = data;
    }

    public JP2Decoder(String fileName) {
        this.fileName = fileName;
    }

    public JP2Decoder(InputStream is) {
        this.is = is;
    }

    public JP2Decoder setSkipResolutions(int skipResolutions) {
        if (skipResolutions < 0) {
            throw new IllegalArgumentException("skipResolutions cannot be a negative number!");
        }
        this.skipResolutions = skipResolutions;
        return this;
    }

    public JP2Decoder setLayersToDecode(int layersToDecode) {
        if (layersToDecode < 0) {
            throw new IllegalArgumentException("layersToDecode cannot be a negative number!");
        }
        this.layersToDecode = layersToDecode;
        return this;
    }

    @RequiresApi(api=19)
    public JP2Decoder disableBitmapPremultiplication() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.premultiplication = false;
        } else {
            Log.e((String)TAG, (String)"Pre-multiplication cannot be disabled on API < 19. Ignoring.");
        }
        return this;
    }

    public static boolean isJPEG2000(byte[] data) {
        if (data == null) {
            return false;
        }
        if (JP2Decoder.startsWith(data, JP2_RFC3745_MAGIC)) {
            return true;
        }
        if (JP2Decoder.startsWith(data, JP2_MAGIC)) {
            return true;
        }
        return JP2Decoder.startsWith(data, J2K_CODESTREAM_MAGIC);
    }

    public Bitmap decode() {
        int[] res = null;
        if (this.fileName != null) {
            res = JP2Decoder.decodeJP2File(this.fileName, this.skipResolutions, this.layersToDecode);
        } else {
            if (this.data == null && this.is != null) {
                this.data = JP2Decoder.readInputStream(this.is);
            }
            if (this.data == null) {
                Log.e((String)TAG, (String)"Data is null, nothing to decode");
            } else {
                res = JP2Decoder.decodeJP2ByteArray(this.data, this.skipResolutions, this.layersToDecode);
            }
        }
        return this.nativeToBitmap(res);
    }

    public Header readHeader() {
        int[] res = null;
        if (this.fileName != null) {
            res = JP2Decoder.readJP2HeaderFile(this.fileName);
        } else {
            if (this.data == null && this.is != null) {
                this.data = JP2Decoder.readInputStream(this.is);
            }
            if (this.data == null) {
                Log.e((String)TAG, (String)"Data is null, nothing to decode");
            } else {
                res = JP2Decoder.readJP2HeaderByteArray(this.data);
            }
        }
        return JP2Decoder.nativeToHeader(res);
    }

    private static byte[] readInputStream(InputStream in) {
        if (in == null) {
            Log.e((String)TAG, (String)"input stream is null!");
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(in.available());
            byte[] buffer = new byte[16384];
            int bytesRead = in.read(buffer);
            while (bytesRead >= 0) {
                out.write(buffer, 0, bytesRead);
                bytesRead = in.read(buffer);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Bitmap nativeToBitmap(int[] data) {
        if (data == null || data.length < 3) {
            return null;
        }
        int width = data[0];
        int height = data[1];
        int alpha = data[2];
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (!this.premultiplication && Build.VERSION.SDK_INT >= 19) {
            bmp.setPremultiplied(false);
        }
        bmp.setPixels(data, 3, width, 0, 0, width, height);
        bmp.setHasAlpha(alpha != 0);
        return bmp;
    }

    private static Header nativeToHeader(int[] data) {
        if (data == null || data.length < 5) {
            return null;
        }
        Header ret = new Header();
        ret.width = data[0];
        ret.height = data[1];
        ret.hasAlpha = data[2] != 0;
        ret.numResolutions = data[3];
        ret.numQualityLayers = data[4];
        return ret;
    }

    private static boolean startsWith(@NonNull byte[] array1, @NonNull byte[] array2) {
        if (array1.length < array2.length) {
            return false;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private static native int[] decodeJP2File(String var0, int var1, int var2);

    private static native int[] decodeJP2ByteArray(byte[] var0, int var1, int var2);

    private static native int[] readJP2HeaderFile(String var0);

    private static native int[] readJP2HeaderByteArray(byte[] var0);

    static {
        System.loadLibrary("openjpeg");
        JP2_RFC3745_MAGIC = new byte[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, -121, 10};
        JP2_MAGIC = new byte[]{13, 10, -121, 10};
        J2K_CODESTREAM_MAGIC = new byte[]{-1, 79, -1, 81};
    }

    public static class Header {
        public int width;
        public int height;
        public boolean hasAlpha;
        public int numResolutions;
        public int numQualityLayers;
    }
}

