/*
 * Decompiled with CFR 0.152.
 */
package com.gdacciaro.iOSDialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.gdacciaro.iOSDialog.R;

public class iOSDialog {
    private Dialog dialog;
    private TextView dialogButtonOk;
    private TextView dialogButtonNo;
    private TextView title_lbl;
    private TextView subtitle_lbl;
    private View separator;
    private boolean negativeExist = false;

    public iOSDialog(Context context) {
        this.dialog = new Dialog(context);
        this.dialog.setContentView(R.layout.alerts_two_buttons);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.initViews();
    }

    public void setPositiveListener(View.OnClickListener okListener) {
        this.dialogButtonOk.setOnClickListener(okListener);
    }

    public void setNegativeListener(View.OnClickListener okListener) {
        if (!this.negativeExist) {
            Log.e((String)"iOSDialog", (String)"!!! Negative button isn't visible, set it with setNegativeLabel()!!!");
        }
        this.dialogButtonNo.setOnClickListener(okListener);
    }

    public void show() {
        if (!this.negativeExist) {
            this.dialogButtonNo.setVisibility(8);
            this.separator.setVisibility(8);
        }
        this.dialog.show();
    }

    public void dismiss() {
        this.dialog.dismiss();
    }

    public void setTitle(String title) {
        this.title_lbl.setText((CharSequence)title);
    }

    public void setSubtitle(String subtitle) {
        this.subtitle_lbl.setText((CharSequence)subtitle);
    }

    public void setPositiveLabel(String positive) {
        this.dialogButtonOk.setText((CharSequence)positive);
    }

    public void setNegativeLabel(String negative) {
        this.negativeExist = true;
        this.dialogButtonNo.setText((CharSequence)negative);
    }

    public void setBoldPositiveLabel(boolean bold) {
        if (bold) {
            this.dialogButtonOk.setTypeface(null, 1);
        } else {
            this.dialogButtonOk.setTypeface(null, 0);
        }
    }

    private void initViews() {
        this.title_lbl = (TextView)this.dialog.findViewById(R.id.title);
        this.subtitle_lbl = (TextView)this.dialog.findViewById(R.id.subtitle);
        this.dialogButtonOk = (TextView)this.dialog.findViewById(R.id.dialogButtonOK);
        this.dialogButtonNo = (TextView)this.dialog.findViewById(R.id.dialogButtonNO);
        this.separator = this.dialog.findViewById(R.id.separator);
    }
}

