/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.utils;

import com.galarzaa.tibiakt.core.builders.LastPostBuilder;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.enums.Vocation;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.character.GuildMembershipWithTitle;
import com.galarzaa.tibiakt.core.models.forums.BaseForumAuthor;
import com.galarzaa.tibiakt.core.models.forums.ForumAuthor;
import com.galarzaa.tibiakt.core.models.forums.LastPost;
import com.galarzaa.tibiakt.core.models.forums.TournamentForumAuthor;
import com.galarzaa.tibiakt.core.models.forums.UnavailableForumAuthor;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"TRADED_TAG", "", "parseLastPostFromCell", "Lcom/galarzaa/tibiakt/core/models/forums/LastPost;", "cell", "Lorg/jsoup/nodes/Element;", "titles", "", "charInfoRegex", "Lkotlin/text/Regex;", "authorPostsRegex", "titleRegex", "parseAuthorTable", "Lcom/galarzaa/tibiakt/core/models/forums/BaseForumAuthor;", "table", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nForums.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Forums.kt\ncom/galarzaa/tibiakt/core/utils/ForumsKt\n+ 2 LastPostBuilder.kt\ncom/galarzaa/tibiakt/core/builders/LastPostBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n*L\n1#1,112:1\n27#2:113\n24#2:114\n1863#3,2:115\n1#4:117\n1#4:119\n33#5:118\n*S KotlinDebug\n*F\n+ 1 Forums.kt\ncom/galarzaa/tibiakt/core/utils/ForumsKt\n*L\n44#1:113\n44#1:114\n73#1:115,2\n104#1:119\n104#1:118\n*E\n"})
public final class ForumsKt {
    @NotNull
    public static final String TRADED_TAG = "(traded)";
    @NotNull
    private static final List<String> titles;
    @NotNull
    private static final Regex charInfoRegex;
    @NotNull
    private static final Regex authorPostsRegex;
    @NotNull
    private static final Regex titleRegex;

    @Nullable
    public static final LastPost parseLastPostFromCell(@NotNull Element cell) {
        LastPostBuilder lastPostBuilder;
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Element element = cell.selectFirst("span.LastPostInfo");
        if (element == null) {
            return null;
        }
        Element postDate = element;
        Object object = cell.selectFirst("a");
        if (object == null || (object = ElementsKt.getLinkInformation((Element)object)) == null) {
            return null;
        }
        Object permalink = object;
        Element element2 = cell.selectFirst("font");
        if (element2 == null) {
            return null;
        }
        Element authorTag = element2;
        Element element3 = authorTag.selectFirst("a");
        LinkInformation authorLink = element3 != null ? ElementsKt.getLinkInformation(element3) : null;
        String authorName = null;
        authorName = StringsKt.removePrefix((String)ElementsKt.cleanText(authorTag), (CharSequence)"by ");
        boolean isTraded = false;
        if (StringsKt.contains$default((CharSequence)authorName, (CharSequence)TRADED_TAG, (boolean)false, (int)2, null)) {
            authorName = StringExtensionsKt.remove$default(authorName, TRADED_TAG, false, 2, null);
            isTraded = true;
        }
        boolean $i$f$lastPost = false;
        boolean $i$f$lastPostBuilder = false;
        LastPostBuilder $this$parseLastPostFromCell_u24lambda_u240 = lastPostBuilder = new LastPostBuilder();
        boolean bl = false;
        List<String> list = ((LinkInformation)permalink).getQueryParams().get("postid");
        Intrinsics.checkNotNull(list);
        $this$parseLastPostFromCell_u24lambda_u240.setPostId(Integer.parseInt((String)CollectionsKt.first(list)));
        $this$parseLastPostFromCell_u24lambda_u240.setDate(DatesKt.parseTibiaForumDateTime(ElementsKt.cleanText(postDate)));
        $this$parseLastPostFromCell_u24lambda_u240.setAuthor(authorName);
        $this$parseLastPostFromCell_u24lambda_u240.setDeleted(authorLink == null && !isTraded);
        $this$parseLastPostFromCell_u24lambda_u240.setTraded(isTraded);
        return lastPostBuilder.build();
    }

    @NotNull
    public static final BaseForumAuthor parseAuthorTable(@NotNull Element table) {
        Enum enum_;
        int n;
        String string;
        String postsText;
        String vocation;
        String world;
        Object object;
        GuildMembershipWithTitle guildMembership;
        boolean isRecentlyTraded;
        String position;
        String title;
        block15: {
            Enum[] enumArray;
            Object object2;
            LinkInformation charLink;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Element element = table.selectFirst("a");
            LinkInformation linkInformation = charLink = element != null ? ElementsKt.getLinkInformation(element) : null;
            if (charLink == null) {
                String name = ElementsKt.cleanText(table);
                boolean isTraded = StringsKt.contains$default((CharSequence)name, (CharSequence)TRADED_TAG, (boolean)false, (int)2, null);
                return new UnavailableForumAuthor(((Object)StringsKt.trim((CharSequence)StringExtensionsKt.remove$default(name, TRADED_TAG, false, 2, null))).toString(), !isTraded, isTraded);
            }
            Element charInfo = table.selectFirst("font.ff_infotext");
            Element positionInfo = table.selectFirst("font.ff_smallinfo");
            title = null;
            position = null;
            isRecentlyTraded = false;
            if (!(positionInfo == null || charInfo != null && Intrinsics.areEqual((Object)positionInfo.parent(), (Object)charInfo))) {
                String[] stringArray = new String[]{"\n"};
                Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)ElementsKt.wholeCleanText(ElementsKt.replaceBrs(positionInfo)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (titles.contains(it)) {
                        position = it;
                        continue;
                    }
                    if (StringsKt.contains$default((CharSequence)it, (CharSequence)"traded", (boolean)false, (int)2, null)) {
                        isRecentlyTraded = true;
                        continue;
                    }
                    title = it;
                }
            }
            guildMembership = null;
            Element element2 = charInfo;
            if (element2 != null && (element2 = element2.selectFirst("font.ff_smallinfo")) != null) {
                Object object3;
                Element guildLink;
                Element it = element2;
                boolean bl = false;
                Element element3 = guildLink = it.selectFirst("a");
                LinkInformation linkInformation2 = element3 != null ? ElementsKt.getLinkInformation(element3) : null;
                Intrinsics.checkNotNull((Object)linkInformation2);
                LinkInformation guildLinkInfo = linkInformation2;
                String guildName = guildLinkInfo.getTitle();
                guildLink.remove();
                String rank = null;
                rank = ElementsKt.cleanText(it);
                Object object4 = Regex.find$default((Regex)titleRegex, (CharSequence)rank, (int)0, (int)2, null);
                if (object4 != null && (object4 = object4.getGroupValues()) != null && (object4 = (String)object4.get(1)) != null) {
                    Object g = object = object4;
                    boolean bl2 = false;
                    rank = ((Object)StringsKt.trim((CharSequence)StringExtensionsKt.remove$default(rank, '(' + (String)g + ')', false, 2, null))).toString();
                    object3 = object;
                } else {
                    object3 = null;
                }
                Object guildTitle = object3;
                rank = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)rank, (CharSequence)"of the"))).toString();
                guildMembership = new GuildMembershipWithTitle(guildName, rank, (String)guildTitle);
            }
            Element element4 = charInfo;
            if (element4 != null) {
                ElementsKt.replaceBrs(element4);
            }
            boolean bl = (object2 = charInfo) != null && (object2 = ElementsKt.cleanText(object2)) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"Tournament - ", (boolean)false, (int)2, null) : false;
            if (bl) {
                return new TournamentForumAuthor(charLink.getTitle(), StringExtensionsKt.findInteger(ElementsKt.cleanText(charInfo)));
            }
            Element element5 = charInfo;
            Intrinsics.checkNotNull((Object)element5);
            Object object5 = Regex.find$default((Regex)charInfoRegex, (CharSequence)ElementsKt.wholeCleanText(element5), (int)0, (int)2, null);
            if (object5 == null || (object5 = object5.getGroupValues()) == null) {
                throw new ParsingException("Could not find character info", null, 2, null);
            }
            Object object6 = object5;
            world = (String)object6.get(1);
            vocation = (String)object6.get(2);
            String level = (String)object6.get(3);
            MatchResult matchResult = Regex.find$default((Regex)authorPostsRegex, (CharSequence)ElementsKt.wholeCleanText(charInfo), (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            postsText = (String)matchResult.getGroupValues().get(1);
            string = charLink.getTitle();
            n = Integer.parseInt(level);
            StringEnum.Companion this_$iv = StringEnum.Companion;
            boolean $i$f$fromValue = false;
            Enum[] it$iv = enumArray = Vocation.class;
            boolean bl3 = false;
            Object object7 = it$iv.isEnum() ? enumArray : null;
            if (object7 != null && (object7 = (Enum[])object7.getEnumConstants()) != null) {
                Enum[] enumArray2 = object7;
                int n2 = enumArray2.length;
                for (int i = 0; i < n2; ++i) {
                    Enum enum_2;
                    Enum it$iv2 = enum_2 = enumArray2[i];
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv2)).getValue(), (Object)vocation) || Intrinsics.areEqual((Object)it$iv2.name(), (Object)vocation))) continue;
                    enum_ = enum_2;
                    break block15;
                }
                enum_ = null;
            } else {
                enum_ = null;
            }
        }
        Vocation vocation2 = (Vocation)enum_;
        if (vocation2 == null) {
            throw new ParsingException("Unknown vocation: " + vocation, null, 2, null);
        }
        object = vocation2;
        String string2 = position;
        String string3 = title;
        GuildMembershipWithTitle guildMembershipWithTitle = guildMembership;
        int n3 = StringExtensionsKt.parseInteger(postsText);
        boolean bl = isRecentlyTraded;
        return new ForumAuthor(string, n, world, string2, string3, (Vocation)object, guildMembershipWithTitle, n3, bl);
    }

    static {
        Object[] objectArray = new String[]{"Tutor", "Community Manager", "Customer Support", "Programmer", "Game Content Designer", "Tester"};
        titles = CollectionsKt.listOf((Object[])objectArray);
        charInfoRegex = new Regex("Inhabitant of (\\w+)\\nVocation: ([\\w\\s]+)\\nLevel: (\\d+)");
        authorPostsRegex = new Regex("Posts: (\\d+)");
        titleRegex = new Regex("\\(([\\w\\s]+)\\)");
    }
}

