/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.utils;

import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u0005*\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\n\u001a\u00020\u0006*\u0004\u0018\u00010\u0003H\u0000\u001a\u000e\u0010\n\u001a\u00020\u0006*\u0004\u0018\u00010\u0006H\u0000\u001a\u000e\u0010\u000b\u001a\u00020\u0006*\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r*\u00020\u0003H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u000fH\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0006H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u0012\u0012\u0004\u0012\u00020\u00030\u0014j\b\u0012\u0004\u0012\u00020\u0003`\u0015H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0003H\u0000\u001a\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0003H\u0000\u001a\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0001H\u0000\u001a\u000e\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u0003H\u0000\u001a4\u0010$\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010&0%j\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010&`'*\u00020(H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"TABLE_SELECTOR", "", "boxContent", "Lorg/jsoup/nodes/Element;", "parseTables", "", "Lorg/jsoup/select/Elements;", "contentTableSelector", "parseTablesMap", "contentSelector", "rows", "cells", "cellsText", "", "cleanText", "Lorg/jsoup/nodes/TextNode;", "wholeCleanText", "replaceBrs", "replaceBr", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "formData", "Lcom/galarzaa/tibiakt/core/utils/FormData;", "pageRegex", "Lkotlin/text/Regex;", "resultsRegex", "parsePagination", "Lcom/galarzaa/tibiakt/core/utils/PaginationData;", "parsePopup", "Lkotlin/Pair;", "Lorg/jsoup/nodes/Document;", "content", "queryStringRegex", "getLinkInformation", "Lcom/galarzaa/tibiakt/core/utils/LinkInformation;", "queryParams", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "Ljava/net/URL;", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Elements.kt\ncom/galarzaa/tibiakt/core/utils/ElementsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,213:1\n1557#2:214\n1628#2,3:215\n1863#2,2:218\n1863#2,2:220\n1863#2,2:222\n1863#2:224\n1863#2:225\n1864#2:233\n1864#2:234\n1863#2:235\n1864#2:250\n1863#2:251\n1864#2:259\n381#3,7:226\n381#3,7:236\n381#3,7:243\n381#3,7:252\n381#3,7:260\n*S KotlinDebug\n*F\n+ 1 Elements.kt\ncom/galarzaa/tibiakt/core/utils/ElementsKt\n*L\n68#1:214\n68#1:215,3\n83#1:218,2\n87#1:220,2\n100#1:222,2\n101#1:224\n102#1:225\n102#1:233\n101#1:234\n109#1:235\n109#1:250\n115#1:251\n115#1:259\n105#1:226,7\n112#1:236,7\n113#1:243,7\n118#1:252,7\n209#1:260,7\n*E\n"})
public final class ElementsKt {
    @NotNull
    public static final String TABLE_SELECTOR = "table.TableContent";
    @NotNull
    private static final Regex pageRegex = new Regex("(?:page|pagenumber)=(\\d+)");
    @NotNull
    private static final Regex resultsRegex = new Regex("Results: ([\\d,]+)");
    @NotNull
    private static final Regex queryStringRegex = new Regex("([^&=]+)=([^&]*)");

    @NotNull
    public static final Element boxContent(@NotNull Element $this$boxContent) {
        Intrinsics.checkNotNullParameter((Object)$this$boxContent, (String)"<this>");
        Element element = $this$boxContent.selectFirst("div.BoxContent");
        if (element == null) {
            throw new ParsingException("BoxContent container not found", null, 2, null);
        }
        return element;
    }

    @NotNull
    public static final Map<String, Elements> parseTables(@NotNull Element $this$parseTables, @NotNull String contentTableSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$parseTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentTableSelector, (String)"contentTableSelector");
        Elements elements = $this$parseTables.select("div.TableContainer");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements tables = elements;
        Map output = new LinkedHashMap();
        Iterator iterator = tables.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Elements rows;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element table = (Element)e;
            Element captionContainer = table.selectFirst("div.CaptionContainer");
            Element contentTable = table.selectFirst(contentTableSelector);
            Object object = captionContainer;
            if (object == null || (object = object.text()) == null) {
                throw new ParsingException("table has no caption container", null, 2, null);
            }
            Object caption = object;
            if (contentTable == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)contentTable.select("tr"), (String)"select(...)");
            output.put(caption, rows);
        }
        return output;
    }

    public static /* synthetic */ Map parseTables$default(Element element, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = TABLE_SELECTOR;
        }
        return ElementsKt.parseTables(element, string);
    }

    @NotNull
    public static final Map<String, Element> parseTablesMap(@NotNull Element $this$parseTablesMap, @NotNull String contentSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$parseTablesMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentSelector, (String)"contentSelector");
        Elements elements = $this$parseTablesMap.select("div.TableContainer");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements tables = elements;
        Map output = new LinkedHashMap();
        Iterator iterator = tables.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element element;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element table = (Element)e;
            Object object = table.selectFirst("div.Text");
            if (object == null || (object = ElementsKt.cleanText(object)) == null) {
                throw new ParsingException("table has no caption", null, 2, null);
            }
            Object caption = object;
            Element contentTable = table.selectFirst(contentSelector);
            Map map = output;
            if (contentTable == null) continue;
            map.put(caption, element);
        }
        return output;
    }

    public static /* synthetic */ Map parseTablesMap$default(Element element, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "div.TableContentContainer";
        }
        return ElementsKt.parseTablesMap(element, string);
    }

    @NotNull
    public static final Elements rows(@Nullable Element $this$rows) {
        Element element = $this$rows;
        if (element == null || (element = element.select("tr")) == null) {
            element = new Elements();
        }
        return element;
    }

    @NotNull
    public static final Elements rows(@Nullable Elements $this$rows) {
        Elements elements = $this$rows;
        if (elements == null || (elements = elements.select("tr")) == null) {
            elements = new Elements();
        }
        return elements;
    }

    @NotNull
    public static final Elements cells(@Nullable Element $this$cells) {
        Element element = $this$cells;
        if (element == null || (element = element.select("td")) == null) {
            element = new Elements();
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> cellsText(@NotNull Element $this$cellsText) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cellsText, (String)"<this>");
        Iterable $this$map$iv = (Iterable)ElementsKt.cells($this$cellsText);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(ElementsKt.cleanText((Element)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String cleanText(@NotNull Element $this$cleanText) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanText, (String)"<this>");
        String string = $this$cleanText.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        return StringExtensionsKt.clean(string);
    }

    @NotNull
    public static final String cleanText(@NotNull TextNode $this$cleanText) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanText, (String)"<this>");
        String string = $this$cleanText.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        return StringExtensionsKt.clean(string);
    }

    @NotNull
    public static final String cleanText(@NotNull Elements $this$cleanText) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanText, (String)"<this>");
        String string = $this$cleanText.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        return StringExtensionsKt.clean(string);
    }

    @NotNull
    public static final String wholeCleanText(@NotNull Element $this$wholeCleanText) {
        Intrinsics.checkNotNullParameter((Object)$this$wholeCleanText, (String)"<this>");
        String string = $this$wholeCleanText.wholeText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wholeText(...)");
        return StringExtensionsKt.clean(string);
    }

    @NotNull
    public static final Element replaceBrs(@NotNull Element $this$replaceBrs) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)$this$replaceBrs, (String)"<this>");
        Element $this$replaceBrs_u24lambda_u242 = element = $this$replaceBrs;
        boolean bl = false;
        Elements elements = $this$replaceBrs_u24lambda_u242.select("br");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$forEach$iv = (Iterable)elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl2 = false;
            it.replaceWith((Node)new TextNode("\n"));
        }
        return element;
    }

    public static final void replaceBr(@NotNull ArrayList<Element> $this$replaceBr) {
        Intrinsics.checkNotNullParameter($this$replaceBr, (String)"<this>");
        Iterable $this$forEach$iv = $this$replaceBr;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            ElementsKt.replaceBrs(it);
        }
    }

    @NotNull
    public static final FormData formData(@NotNull Element $this$formData) {
        Object value$iv;
        String name;
        Map $this$getOrPut$iv;
        Element it;
        Intrinsics.checkNotNullParameter((Object)$this$formData, (String)"<this>");
        String string = $this$formData.tagName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)"form")) {
            boolean $i$a$-require-ElementsKt$formData$22 = false;
            String $i$a$-require-ElementsKt$formData$22 = "expected element with 'form' tag, got element with '" + $this$formData.tagName() + "' tag";
            throw new IllegalArgumentException($i$a$-require-ElementsKt$formData$22.toString());
        }
        Map data = new LinkedHashMap();
        Map dataMultiple = new LinkedHashMap();
        Map availableOptions = new LinkedHashMap();
        Elements elements = $this$formData.select("input[type=text], input[type=hidden]");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$forEach$iv = (Iterable)elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Element)element$iv;
            boolean bl = false;
            data.put(it.attr("name"), it.attr("value"));
        }
        Elements elements2 = $this$formData.select("select");
        Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
        $this$forEach$iv = (Iterable)elements2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Element)element$iv;
            boolean bl = false;
            Elements elements3 = it.select("option");
            Intrinsics.checkNotNullExpressionValue((Object)elements3, (String)"select(...)");
            Iterable $this$forEach$iv2 = (Iterable)elements3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String value;
                Object object;
                String name2;
                Element opt = (Element)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)opt.attr("value"), (String)"attr(...)");
                Intrinsics.checkNotNullExpressionValue((Object)it.attr("name"), (String)"attr(...)");
                Map $this$getOrPut$iv2 = availableOptions;
                boolean $i$f$getOrPut = false;
                Object value$iv2 = $this$getOrPut$iv2.get(name2);
                if (value$iv2 == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv2.put(name2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                ((List)object).add(value);
                if (!opt.hasAttr("selected")) continue;
                data.put(name2, value);
            }
        }
        Elements elements4 = $this$formData.select("input[type=checkbox]");
        Intrinsics.checkNotNullExpressionValue((Object)elements4, (String)"select(...)");
        $this$forEach$iv = (Iterable)elements4;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String value;
            Object object2;
            it = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.attr("name"), (String)"attr(...)");
            Intrinsics.checkNotNullExpressionValue((Object)it.attr("value"), (String)"attr(...)");
            $this$getOrPut$iv = availableOptions;
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl4 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((List)object2).add(value);
            if (!it.hasAttr("checked")) continue;
            $this$getOrPut$iv = dataMultiple;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl5 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(value);
        }
        Elements elements5 = $this$formData.select("input[type=radio]");
        Intrinsics.checkNotNullExpressionValue((Object)elements5, (String)"select(...)");
        $this$forEach$iv = (Iterable)elements5;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String value;
            Object object;
            it = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.attr("name"), (String)"attr(...)");
            Intrinsics.checkNotNullExpressionValue((Object)it.attr("value"), (String)"attr(...)");
            $this$getOrPut$iv = availableOptions;
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl6 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(value);
            if (!it.hasAttr("checked")) continue;
            data.put(name, value);
        }
        return new FormData(data, dataMultiple, availableOptions, $this$formData.attr("action"), $this$formData.attr("method"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final PaginationData parsePagination(@NotNull Element $this$parsePagination) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)$this$parsePagination, (String)"<this>");
        Elements elements = $this$parsePagination.select("small > div");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements elements2 = elements;
        Object e = ((List)elements2).get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"component1(...)");
        Element pagesDiv = (Element)e;
        Object e2 = ((List)elements2).get(1);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"component2(...)");
        Element resultsDiv = (Element)e2;
        Element currentPageLink = pagesDiv.selectFirst(".CurrentPageLink");
        Elements elements3 = pagesDiv.select(".PageLink");
        Intrinsics.checkNotNullExpressionValue((Object)elements3, (String)"select(...)");
        Elements pageLinks = elements3;
        Elements elements4 = pagesDiv.select(".FirstOrLastElement");
        Intrinsics.checkNotNullExpressionValue((Object)elements4, (String)"select(...)");
        Elements firstOrLastPages = elements4;
        if (!((Collection)firstOrLastPages).isEmpty()) {
            Element lastPageLink;
            Element element = firstOrLastPages.last();
            Object object = lastPageLink = element != null ? element.selectFirst("a") : null;
            if (lastPageLink != null) {
                String string = lastPageLink.attr("href");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                MatchResult matchResult = Regex.find$default((Regex)pageRegex, (CharSequence)string, (int)0, (int)2, null);
                if (matchResult == null) throw new ParsingException("Could not parse pagination info", null, 2, null);
                MatchResult it = matchResult;
                boolean bl = false;
                MatchGroup matchGroup = it.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                n3 = Integer.parseInt(matchGroup.getValue());
            } else {
                String string = ((Element)pageLinks.get(pageLinks.size() - 2)).text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                n3 = Integer.parseInt(string);
            }
        } else {
            Object object = pageLinks.last();
            if (object == null || (object = object.text()) == null) throw new ParsingException("could not find last page link", null, 2, null);
            n3 = Integer.parseInt((String)object);
        }
        int totalPages = n3;
        try {
            Object object = currentPageLink;
            n2 = object != null && (object = object.text()) != null ? Integer.parseInt((String)object) : totalPages;
        }
        catch (NumberFormatException nfe) {
            Object object = currentPageLink;
            n2 = (object != null && (object = object.text()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"First", (boolean)false, (int)2, null) : false) ? 1 : totalPages;
        }
        int page = n2;
        String string = resultsDiv.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        MatchResult matchResult = Regex.find$default((Regex)resultsRegex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            MatchGroup matchGroup = it.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            n = StringExtensionsKt.parseInteger(matchGroup.getValue());
        } else {
            n = 0;
        }
        int resultsCount = n;
        return new PaginationData(page, totalPages, resultsCount);
    }

    @NotNull
    public static final Pair<String, Document> parsePopup(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String[] stringArray = new String[]{","};
        List parts = StringsKt.split$default((CharSequence)content, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
        String title = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)((String)parts.get(1)), (String)"'", (String)"", (boolean)false, (int)4, null))).toString();
        String html = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)((String)parts.get(parts.size() - 1)), (String)"\\'", (String)"\"", (boolean)false, (int)4, null), (String)"'", (String)"", (boolean)false, (int)4, null), (String)",);", (String)"", (boolean)false, (int)4, null), (String)", );", (String)"", (boolean)false, (int)4, null))).toString();
        Document document = Jsoup.parse((String)html, (String)"", (Parser)Parser.xmlParser());
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document parsedHtml = document;
        return TuplesKt.to((Object)title, (Object)parsedHtml);
    }

    @Nullable
    public static final LinkInformation getLinkInformation(@NotNull Element $this$getLinkInformation) {
        Intrinsics.checkNotNullParameter((Object)$this$getLinkInformation, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$getLinkInformation.tagName(), (Object)"a")) {
            return null;
        }
        String string = $this$getLinkInformation.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        String string2 = $this$getLinkInformation.attr("href");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attr(...)");
        return new LinkInformation(string, string2);
    }

    @NotNull
    public static final HashMap<String, List<String>> queryParams(@NotNull URL $this$queryParams) {
        Intrinsics.checkNotNullParameter((Object)$this$queryParams, (String)"<this>");
        String string = $this$queryParams.getQuery();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
        Sequence matches = Regex.findAll$default((Regex)queryStringRegex, (CharSequence)string, (int)0, (int)2, null);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (MatchResult match : matches) {
            Object object;
            List list = match.getGroupValues();
            String name = (String)list.get(1);
            String value = (String)list.get(2);
            Map $this$getOrPut$iv = map;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(value);
        }
        return map;
    }
}

