/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.utils;

import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.ConvertersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\b\u001a\u00020\t\u001a\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r\u001a\u000e\u0010\f\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r\u001a\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"TIBIA_TIMEZONE", "Ljava/time/ZoneId;", "getTIBIA_TIMEZONE", "()Ljava/time/ZoneId;", "SERVER_SAVE_TIME", "Ljava/time/LocalTime;", "getSERVER_SAVE_TIME", "()Ljava/time/LocalTime;", "getTibiaWeekDay", "Ljava/time/DayOfWeek;", "getTibiaDateTime", "Ljava/time/LocalDateTime;", "getLastServerSaveTime", "Ljava/time/ZonedDateTime;", "currentTime", "Lkotlinx/datetime/Instant;", "getNextServerSaveTime", "parseTibiaDateTime", "input", "", "parseTibiaDate", "Ljava/time/LocalDate;", "parseTibiaFullDate", "parseTibiaForumDateTime", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dates.kt\ncom/galarzaa/tibiakt/core/utils/DatesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class DatesKt {
    @NotNull
    private static final ZoneId TIBIA_TIMEZONE;
    @NotNull
    private static final LocalTime SERVER_SAVE_TIME;

    @NotNull
    public static final ZoneId getTIBIA_TIMEZONE() {
        return TIBIA_TIMEZONE;
    }

    @NotNull
    public static final LocalTime getSERVER_SAVE_TIME() {
        return SERVER_SAVE_TIME;
    }

    @NotNull
    public static final DayOfWeek getTibiaWeekDay() {
        LocalDateTime localDateTime = DatesKt.getTibiaDateTime();
        long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.HOURS);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        DayOfWeek dayOfWeek = localDateTime.minus(duration).getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return dayOfWeek;
    }

    @NotNull
    public static final LocalDateTime getTibiaDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now(TIBIA_TIMEZONE);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        return localDateTime;
    }

    @NotNull
    public static final ZonedDateTime getLastServerSaveTime(@NotNull ZonedDateTime currentTime) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        ZonedDateTime serverSaveTime = ZonedDateTime.of(currentTime.toLocalDate(), SERVER_SAVE_TIME, TIBIA_TIMEZONE);
        if (currentTime.compareTo(serverSaveTime) < 0) {
            ZonedDateTime zonedDateTime2 = serverSaveTime.minusDays(1L);
            zonedDateTime = zonedDateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"minusDays(...)");
        } else {
            Intrinsics.checkNotNull((Object)serverSaveTime);
            zonedDateTime = serverSaveTime;
        }
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime getLastServerSaveTime$default(ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            zonedDateTime = ZonedDateTime.now(TIBIA_TIMEZONE);
        }
        return DatesKt.getLastServerSaveTime(zonedDateTime);
    }

    @NotNull
    public static final kotlinx.datetime.Instant getLastServerSaveTime(@NotNull kotlinx.datetime.Instant currentTime) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)currentTime), TIBIA_TIMEZONE);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(...)");
        Instant instant = DatesKt.getLastServerSaveTime(zonedDateTime).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return ConvertersKt.toKotlinInstant((Instant)instant);
    }

    @NotNull
    public static final ZonedDateTime getNextServerSaveTime(@NotNull ZonedDateTime currentTime) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        ZonedDateTime zonedDateTime = DatesKt.getLastServerSaveTime(currentTime).plusDays(1L);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"plusDays(...)");
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime getNextServerSaveTime$default(ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            zonedDateTime = ZonedDateTime.now(TIBIA_TIMEZONE);
        }
        return DatesKt.getNextServerSaveTime(zonedDateTime);
    }

    @NotNull
    public static final kotlinx.datetime.Instant getNextServerSaveTime(@NotNull kotlinx.datetime.Instant currentTime) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)currentTime), TIBIA_TIMEZONE);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(...)");
        Instant instant = DatesKt.getNextServerSaveTime(zonedDateTime).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return ConvertersKt.toKotlinInstant((Instant)instant);
    }

    @NotNull
    public static final kotlinx.datetime.Instant parseTibiaDateTime(@NotNull String input) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String it = StringExtensionsKt.clean(input);
        boolean bl = false;
        String string = it.substring(0, it.length() - 4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String timeString = ((Object)StringsKt.trim((CharSequence)string)).toString();
        try {
            localDateTime = LocalDateTime.parse(timeString, DateTimeFormatter.ofPattern("MMM dd yyyy, HH:mm:ss", Locale.US));
        }
        catch (DateTimeParseException dfe) {
            localDateTime = LocalDateTime.parse(timeString, DateTimeFormatter.ofPattern("MMM dd yyyy, HH:mm", Locale.US));
        }
        Instant instant = localDateTime.atZone(TIBIA_TIMEZONE).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return ConvertersKt.toKotlinInstant((Instant)instant);
    }

    @NotNull
    public static final LocalDate parseTibiaDate(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        LocalDate localDate = LocalDate.parse(StringExtensionsKt.clean(input), DateTimeFormatter.ofPattern("MMM dd yyyy", Locale.US));
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
        return localDate;
    }

    @NotNull
    public static final LocalDate parseTibiaFullDate(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        LocalDate localDate = LocalDate.parse(StringExtensionsKt.clean(input), DateTimeFormatter.ofPattern("MMMM d, yyyy", Locale.US));
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
        return localDate;
    }

    @NotNull
    public static final kotlinx.datetime.Instant parseTibiaForumDateTime(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Instant instant = LocalDateTime.parse(input, DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss", Locale.US)).atZone(TIBIA_TIMEZONE).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return ConvertersKt.toKotlinInstant((Instant)instant);
    }

    static {
        ZoneId zoneId = ZoneId.of("Europe/Berlin");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
        TIBIA_TIMEZONE = zoneId;
        LocalTime localTime = LocalTime.of(10, 0);
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"of(...)");
        SERVER_SAVE_TIME = localTime;
    }
}

