/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.WorldBuilder;
import com.galarzaa.tibiakt.core.enums.BattlEyeType;
import com.galarzaa.tibiakt.core.enums.PvpType;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.enums.TransferType;
import com.galarzaa.tibiakt.core.enums.Vocation;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.world.World;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import com.galarzaa.tibiakt.core.utils.MapExtensionsKt;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0011\u001a\u00020\f*\u00020\r2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0014\u0010\u0013\u001a\u00020\f*\u00020\r2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0014\u0010\u0014\u001a\u00020\f*\u00020\r2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0014\u0010\u0015\u001a\u00020\f*\u00020\r2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/WorldParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/world/World;", "<init>", "()V", "recordRegex", "Lkotlin/text/Regex;", "battlEyeRegex", "fromContent", "content", "", "parseOnlinePlayersTable", "", "Lcom/galarzaa/tibiakt/core/builders/WorldBuilder;", "table", "Lorg/jsoup/nodes/Element;", "parseWorldInformation", "parseTransferType", "value", "parseBattlEyeStatus", "parseOnlineRecord", "parseCreationDate", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nWorldParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldParser.kt\ncom/galarzaa/tibiakt/core/parsers/WorldParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 WorldBuilder.kt\ncom/galarzaa/tibiakt/core/builders/WorldBuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n*L\n1#1,140:1\n1#2:141\n1#2:148\n1#2:154\n31#3:142\n1557#4:143\n1628#4,3:144\n1557#4:149\n1628#4,3:150\n1557#4:155\n1628#4,3:156\n33#5:147\n33#5:153\n*S KotlinDebug\n*F\n+ 1 WorldParser.kt\ncom/galarzaa/tibiakt/core/parsers/WorldParser\n*L\n69#1:148\n85#1:154\n55#1:142\n66#1:143\n66#1:144,3\n76#1:149\n76#1:150,3\n90#1:155\n90#1:156,3\n69#1:147\n85#1:153\n*E\n"})
public final class WorldParser
implements Parser<World> {
    @NotNull
    public static final WorldParser INSTANCE = new WorldParser();
    @NotNull
    private static final Regex recordRegex = new Regex("(?<count>[\\d.,]+) players \\(on (?<date>[^)]+)\\)");
    @NotNull
    private static final Regex battlEyeRegex = new Regex("since ([^.]+).");

    private WorldParser() {
    }

    @Override
    @Nullable
    public World fromContent(@NotNull String content) {
        WorldBuilder builder;
        block4: {
            Element it;
            WorldBuilder worldBuilder;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Document document = Jsoup.parse((String)content, (String)"", (org.jsoup.parser.Parser)org.jsoup.parser.Parser.xmlParser());
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            Document document2 = document;
            Element element = document2.selectFirst("div.BoxContent");
            if (element == null) {
                throw new ParsingException("BoxContent container not found", null, 2, null);
            }
            Element boxContent = element;
            Map<String, Element> tables = ElementsKt.parseTablesMap(boxContent, "table.Table1, table.Table2");
            Element element2 = tables.get("Error");
            if (element2 != null) {
                Element $this$fromContent_u24lambda_u240 = element2;
                boolean bl = false;
                return null;
            }
            Object object = tables.get("World Selection");
            if (object == null || (object = object.selectFirst("option[selected]")) == null || (object = object.text()) == null || (object = StringExtensionsKt.clean((String)object)) == null) {
                throw new ParsingException("World Selection table not found", null, 2, null);
            }
            Object name = object;
            boolean $i$f$worldBuilder = false;
            WorldBuilder $this$fromContent_u24lambda_u241 = worldBuilder = new WorldBuilder();
            boolean bl = false;
            $this$fromContent_u24lambda_u241.setName((String)name);
            builder = worldBuilder;
            Element element3 = tables.get("World Information");
            if (element3 != null) {
                it = element3;
                boolean bl2 = false;
                INSTANCE.parseWorldInformation(builder, it);
            }
            Element element4 = (Element)MapExtensionsKt.getContaining$default(tables, "Players Online", null, 2, null);
            if (element4 == null) break block4;
            it = element4;
            boolean bl3 = false;
            INSTANCE.parseOnlinePlayersTable(builder, it);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final void parseOnlinePlayersTable(WorldBuilder $this$parseOnlinePlayersTable, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table), 2)) {
            Enum enum_;
            String string;
            int n;
            String vocation;
            Object object;
            block6: {
                Enum[] enumArray;
                void $this$mapTo$iv$iv;
                Elements columns;
                Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
                Element row = (Element)t;
                Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
                Iterable $this$map$iv = (Iterable)columns;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Element element = (Element)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.text();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
                    object.add(StringExtensionsKt.clean(string2));
                }
                List list = (List)destination$iv$iv;
                String name = (String)list.get(0);
                String level = (String)list.get(1);
                vocation = (String)list.get(2);
                StringEnum.Companion $i$f$mapTo22 = StringEnum.Companion;
                n = Integer.parseInt(level);
                string = name;
                object = $this$parseOnlinePlayersTable;
                boolean $i$f$fromValue = false;
                Enum[] it$iv = enumArray = Vocation.class;
                boolean bl = false;
                Object object2 = it$iv.isEnum() ? enumArray : null;
                if (object2 != null && (object2 = (Enum[])object2.getEnumConstants()) != null) {
                    Enum[] enumArray2 = object2;
                    int n2 = enumArray2.length;
                    for (int i = 0; i < n2; ++i) {
                        Enum enum_2;
                        Enum it$iv2 = enum_2 = enumArray2[i];
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv2)).getValue(), (Object)vocation) || Intrinsics.areEqual((Object)it$iv2.name(), (Object)vocation))) continue;
                        enum_ = enum_2;
                        break block6;
                    }
                    enum_ = null;
                } else {
                    enum_ = null;
                }
            }
            Enum enum_3 = enum_;
            Vocation vocation2 = (Vocation)enum_3;
            if (vocation2 == null) {
                throw new ParsingException("unknown vocation: " + vocation, null, 2, null);
            }
            ((WorldBuilder)object).addOnlinePlayer(string, n, vocation2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void parseWorldInformation(WorldBuilder $this$parseWorldInformation, Element table) {
        for (T v0 : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table), 1)) {
            Intrinsics.checkNotNullExpressionValue(v0, (String)"next(...)");
            row = (Element)v0;
            Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
            $this$map$iv = (Iterable)columns;
            $i$f$map = false;
            var9_10 = $this$map$iv;
            destination$iv$iv = (String[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                var14_17 = (Element)item$iv$iv;
                var21_30 = destination$iv$iv;
                $i$a$-map-WorldParser$parseWorldInformation$1 = false;
                v1 = it.text();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"text(...)");
                var21_30.add(StringExtensionsKt.clean(v1));
            }
            var6_6 = (List)destination$iv$iv;
            field = (String)var6_6.get(0);
            value = (String)var6_6.get(1);
            field = StringExtensionsKt.remove$default(field, ":", false, 2, null);
            var9_10 = field;
            tmp = -1;
            switch (var9_10.hashCode()) {
                case -1808614382: {
                    if (var9_10.equals("Status")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1623291825: {
                    if (var9_10.equals("Creation Date")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1274108337: {
                    if (var9_10.equals("Transfer Type")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1141385309: {
                    if (var9_10.equals("Premium Type")) {
                        tmp = 4;
                    }
                    break;
                }
                case 1123178518: {
                    if (var9_10.equals("Game World Type")) {
                        tmp = 5;
                    }
                    break;
                }
                case 954786286: {
                    if (var9_10.equals("BattlEye Status")) {
                        tmp = 6;
                    }
                    break;
                }
                case 1659632336: {
                    if (var9_10.equals("PvP Type")) {
                        tmp = 7;
                    }
                    break;
                }
                case -379870137: {
                    if (var9_10.equals("World Quest Titles")) {
                        tmp = 8;
                    }
                    break;
                }
                case -1167120191: {
                    if (var9_10.equals("Players Online")) {
                        tmp = 9;
                    }
                    break;
                }
                case -888142146: {
                    if (var9_10.equals("Online Record")) {
                        tmp = 10;
                    }
                    break;
                }
                case 1965687765: {
                    if (var9_10.equals("Location")) {
                        tmp = 11;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    $this$parseWorldInformation.setOnline(StringsKt.contains((CharSequence)value, (CharSequence)"online", (boolean)true));
                    break;
                }
                case 9: {
                    $this$parseWorldInformation.setOnlineCount(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case 10: {
                    this.parseOnlineRecord($this$parseWorldInformation, value);
                    break;
                }
                case 2: {
                    this.parseCreationDate($this$parseWorldInformation, value);
                    break;
                }
                case 11: {
                    $this$parseWorldInformation.setLocation(value);
                    break;
                }
                case 7: {
                    $i$f$mapTo = StringEnum.Companion;
                    var21_30 = $this$parseWorldInformation;
                    $i$f$fromValue = false;
                    it$iv = item$iv$iv = PvpType.class;
                    $i$a$-takeIf-StringEnum$Companion$fromValue$1$iv = false;
                    v2 /* !! */  = it$iv.isEnum() != false ? item$iv$iv : null;
                    if (v2 /* !! */  == null || (v2 /* !! */  = (Enum[])v2 /* !! */ .getEnumConstants()) == null) ** GOTO lbl117
                    var15_20 = v2 /* !! */ ;
                    var17_24 = var15_20.length;
                    for (var16_22 = 0; var16_22 < var17_24; ++var16_22) {
                        it$iv = var18_26 = var15_20[var16_22];
                        $i$a$-find-StringEnum$Companion$fromValue$2$iv = false;
                        if (!(Intrinsics.areEqual((Object)((StringEnum)it$iv).getValue(), (Object)value) != false || Intrinsics.areEqual((Object)it$iv.name(), (Object)value) != false)) continue;
                        v3 = var18_26;
                        ** GOTO lbl118
                    }
                    v3 = null;
                    ** GOTO lbl118
lbl117:
                    // 1 sources

                    v3 = null;
lbl118:
                    // 3 sources

                    v4 = (PvpType)v3;
                    if (v4 == null) {
                        throw new ParsingException("unknown pvp type found: " + value, null, 2, null);
                    }
                    var21_30.setPvpType(v4);
                    break;
                }
                case 4: {
                    $this$parseWorldInformation.setPremiumRestricted(true);
                    break;
                }
                case 3: {
                    this.parseTransferType($this$parseWorldInformation, value);
                    break;
                }
                case 8: {
                    if (StringsKt.contains((CharSequence)value, (CharSequence)"has no title", (boolean)true)) break;
                    destination$iv$iv = new String[]{","};
                    $this$map$iv = StringsKt.split$default((CharSequence)value, (String[])destination$iv$iv, (boolean)false, (int)0, (int)6, null);
                    $i$f$map = false;
                    $i$f$fromValue = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var17_25 = (String)item$iv$iv;
                        var21_30 = destination$iv$iv;
                        $i$a$-map-WorldParser$parseWorldInformation$2 = false;
                        var21_30.add($this$parseWorldInformation.worldQuest(StringExtensionsKt.clean((String)it)));
                    }
                    (List)destination$iv$iv;
                    break;
                }
                case 6: {
                    this.parseBattlEyeStatus($this$parseWorldInformation, value);
                    break;
                }
                case 5: {
                    $this$parseWorldInformation.setExperimental(StringsKt.contains((CharSequence)value, (CharSequence)"experimental", (boolean)true));
                }
            }
        }
    }

    private final void parseTransferType(WorldBuilder $this$parseTransferType, String value) {
        $this$parseTransferType.setTransferType(StringsKt.contains((CharSequence)value, (CharSequence)"locked", (boolean)true) ? TransferType.LOCKED : (StringsKt.contains((CharSequence)value, (CharSequence)"blocked", (boolean)true) ? TransferType.BLOCKED : TransferType.REGULAR));
    }

    private final void parseBattlEyeStatus(WorldBuilder $this$parseBattlEyeStatus, String value) {
        MatchResult matchResult = Regex.find$default((Regex)battlEyeRegex, (CharSequence)value, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult $this$parseBattlEyeStatus_u24lambda_u247 = matchResult;
            boolean bl = false;
            String since = (String)$this$parseBattlEyeStatus_u24lambda_u247.getGroupValues().get(1);
            if (StringsKt.contains$default((CharSequence)since, (CharSequence)"release", (boolean)false, (int)2, null)) {
                $this$parseBattlEyeStatus.setBattlEyeType(BattlEyeType.GREEN);
                $this$parseBattlEyeStatus.setBattlEyeStartDate(null);
            } else {
                $this$parseBattlEyeStatus.setBattlEyeType(BattlEyeType.YELLOW);
                $this$parseBattlEyeStatus.setBattlEyeStartDate(DatesKt.parseTibiaFullDate(since));
            }
            return;
        }
        $this$parseBattlEyeStatus.setBattlEyeType(BattlEyeType.UNPROTECTED);
        $this$parseBattlEyeStatus.setBattlEyeStartDate(null);
    }

    private final void parseOnlineRecord(WorldBuilder $this$parseOnlineRecord, String value) {
        block0: {
            MatchResult matchResult;
            MatchResult matchResult2 = Regex.find$default((Regex)recordRegex, (CharSequence)value, (int)0, (int)2, null);
            if (matchResult2 == null) break block0;
            MatchResult $this$parseOnlineRecord_u24lambda_u248 = matchResult = matchResult2;
            boolean bl = false;
            List list = $this$parseOnlineRecord_u24lambda_u248.getGroupValues();
            String count = (String)list.get(1);
            String date = (String)list.get(2);
            $this$parseOnlineRecord.setOnlineRecordCount(StringExtensionsKt.parseInteger(count));
            $this$parseOnlineRecord.setOnlineRecordDateTime(DatesKt.parseTibiaDateTime(date));
        }
    }

    private final void parseCreationDate(WorldBuilder $this$parseCreationDate, String value) {
        $this$parseCreationDate.setCreationDate(YearMonth.parse(value, DateTimeFormatter.ofPattern("MMMM yyyy", Locale.ENGLISH)));
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

