/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.WorldOverviewBuilder;
import com.galarzaa.tibiakt.core.enums.BattlEyeType;
import com.galarzaa.tibiakt.core.enums.PvpType;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.enums.TransferType;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.world.WorldOverview;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.time.format.DateTimeParseException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\f*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\f*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/WorldOverviewParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/world/WorldOverview;", "<init>", "()V", "recordRegex", "Lkotlin/text/Regex;", "battlEyeRegex", "fromContent", "content", "", "parseWorldsTable", "", "Lcom/galarzaa/tibiakt/core/builders/WorldOverviewBuilder;", "table", "Lorg/jsoup/nodes/Element;", "parseBattlEyeStatus", "Lcom/galarzaa/tibiakt/core/builders/WorldOverviewBuilder$WorldEntryBuilder;", "columns", "Lorg/jsoup/select/Elements;", "parseOnlineStatus", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nWorldOverviewParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldOverviewParser.kt\ncom/galarzaa/tibiakt/core/parsers/WorldOverviewParser\n+ 2 WorldOverviewBuilder.kt\ncom/galarzaa/tibiakt/core/builders/WorldOverviewBuilderKt\n+ 3 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n30#2:114\n33#3:115\n1#4:116\n*S KotlinDebug\n*F\n+ 1 WorldOverviewParser.kt\ncom/galarzaa/tibiakt/core/parsers/WorldOverviewParser\n*L\n47#1:114\n70#1:115\n70#1:116\n*E\n"})
public final class WorldOverviewParser
implements Parser<WorldOverview> {
    @NotNull
    public static final WorldOverviewParser INSTANCE = new WorldOverviewParser();
    @NotNull
    private static final Regex recordRegex = new Regex("(?<count>[\\d.,]+) players \\(on (?<date>[^)]+)\\)");
    @NotNull
    private static final Regex battlEyeRegex = new Regex("since ([^.]+).");

    private WorldOverviewParser() {
    }

    @Override
    @NotNull
    public WorldOverview fromContent(@NotNull String content) {
        WorldOverviewBuilder worldOverviewBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Document document = Jsoup.parse((String)content, (String)"", (org.jsoup.parser.Parser)org.jsoup.parser.Parser.xmlParser());
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        Element element = document2.selectFirst("div.BoxContent");
        if (element == null) {
            throw new ParsingException("BoxContent container not found", null, 2, null);
        }
        Element boxContent = element;
        Elements elements = boxContent.select("table.TableContent");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements tables = elements;
        boolean $i$f$worldOverviewBuilder = false;
        WorldOverviewBuilder $this$fromContent_u24lambda_u241 = worldOverviewBuilder = new WorldOverviewBuilder();
        boolean bl = false;
        Object object = tables.first();
        if (object == null || (object = object.text()) == null) {
            throw new ParsingException("No content tables found.", null, 2, null);
        }
        MatchResult matchResult = Regex.find$default((Regex)recordRegex, (CharSequence)((CharSequence)object), (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2;
            MatchResult $this$fromContent_u24lambda_u241_u24lambda_u240 = matchResult2 = matchResult;
            boolean bl2 = false;
            List list = $this$fromContent_u24lambda_u241_u24lambda_u240.getGroupValues();
            String recordCount = (String)list.get(1);
            String recordDate = (String)list.get(2);
            $this$fromContent_u24lambda_u241.setOverallMaximumCount(StringExtensionsKt.parseInteger(recordCount));
            $this$fromContent_u24lambda_u241.setOverallMaximumCountDateTime(DatesKt.parseTibiaDateTime(recordDate));
        }
        int n = CollectionsKt.getLastIndex((List)((List)tables));
        int i = 1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)1, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                Object object2 = tables.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                Element headerTable = (Element)object2;
                Object object3 = tables.get(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                Element worldsTable = (Element)object3;
                String string = headerTable.text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Regular", (boolean)false, (int)2, null)) {
                    INSTANCE.parseWorldsTable($this$fromContent_u24lambda_u241, worldsTable);
                }
                if (i == n2) break;
                i += 2;
            }
        }
        WorldOverviewBuilder builder = worldOverviewBuilder;
        return builder.build();
    }

    private final void parseWorldsTable(WorldOverviewBuilder $this$parseWorldsTable, Element table) {
        Elements elements = table.select("tr");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements rows = elements;
        for (Object e : rows.subList(1, rows.size())) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element row = (Element)e;
            $this$parseWorldsTable.addWorld((Function1<? super WorldOverviewBuilder.WorldEntryBuilder, Unit>)((Function1)arg_0 -> WorldOverviewParser.parseWorldsTable$lambda$2(row, arg_0)));
        }
    }

    private final void parseBattlEyeStatus(WorldOverviewBuilder.WorldEntryBuilder $this$parseBattlEyeStatus, Elements columns) {
        block3: {
            Element element;
            $this$parseBattlEyeStatus.setBattlEyeType(BattlEyeType.UNPROTECTED);
            Element element2 = ((Element)columns.get(4)).selectFirst("span.HelperDivIndicator");
            if (element2 == null) break block3;
            Element $this$parseBattlEyeStatus_u24lambda_u244 = element = element2;
            boolean bl = false;
            String string = $this$parseBattlEyeStatus_u24lambda_u244.attr("onmouseover");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            Document popUp = (Document)ElementsKt.parsePopup(string).component2();
            String string2 = popUp.text();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
            MatchResult matchResult = Regex.find$default((Regex)battlEyeRegex, (CharSequence)string2, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchResult matchResult2;
                MatchResult $this$parseBattlEyeStatus_u24lambda_u244_u24lambda_u243 = matchResult2 = matchResult;
                boolean bl2 = false;
                try {
                    MatchGroup matchGroup = $this$parseBattlEyeStatus_u24lambda_u244_u24lambda_u243.getGroups().get(1);
                    Intrinsics.checkNotNull((Object)matchGroup);
                    $this$parseBattlEyeStatus.setBattlEyeStartDate(DatesKt.parseTibiaFullDate(matchGroup.getValue()));
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
            $this$parseBattlEyeStatus.setBattlEyeType($this$parseBattlEyeStatus.getBattlEyeStartDate() == null ? BattlEyeType.GREEN : BattlEyeType.YELLOW);
        }
    }

    private final void parseOnlineStatus(WorldOverviewBuilder.WorldEntryBuilder $this$parseOnlineStatus, Elements columns) {
        try {
            String string = ((Element)columns.get(1)).text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            $this$parseOnlineStatus.setOnlineCount(StringExtensionsKt.parseInteger(string));
            $this$parseOnlineStatus.setOnline(true);
        }
        catch (NumberFormatException nfe) {
            $this$parseOnlineStatus.setOnlineCount(0);
            $this$parseOnlineStatus.setOnline(false);
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseWorldsTable$lambda$2(Element $row, WorldOverviewBuilder.WorldEntryBuilder $this$addWorld) {
        Enum enum_;
        WorldOverviewBuilder.WorldEntryBuilder worldEntryBuilder;
        Elements columns;
        block5: {
            Enum[] enumArray;
            Intrinsics.checkNotNullParameter((Object)$this$addWorld, (String)"$this$addWorld");
            Elements elements = $row.select("td");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            columns = elements;
            Object object = columns.first();
            if (object == null || (object = object.text()) == null) {
                throw new ParsingException("No columns in world row.", null, 2, null);
            }
            $this$addWorld.setName((String)object);
            INSTANCE.parseOnlineStatus($this$addWorld, columns);
            $this$addWorld.setLocation(((Element)columns.get(2)).text());
            StringEnum.Companion companion = StringEnum.Companion;
            String string = ((Element)columns.get(3)).text();
            worldEntryBuilder = $this$addWorld;
            boolean $i$f$fromValue = false;
            Enum[] it$iv = enumArray = PvpType.class;
            boolean bl = false;
            Object object2 = it$iv.isEnum() ? enumArray : null;
            if (object2 != null && (object2 = (Enum[])object2.getEnumConstants()) != null) {
                Enum[] enumArray2 = object2;
                int n = enumArray2.length;
                for (int i = 0; i < n; ++i) {
                    void value$iv;
                    Enum enum_2;
                    Enum it$iv2 = enum_2 = enumArray2[i];
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv2)).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)it$iv2.name(), (Object)value$iv))) continue;
                    enum_ = enum_2;
                    break block5;
                }
                enum_ = null;
            } else {
                enum_ = null;
            }
        }
        PvpType pvpType = (PvpType)enum_;
        if (pvpType == null) {
            throw new ParsingException("Unknown PvP type found: " + ((Element)columns.get(3)).text(), null, 2, null);
        }
        worldEntryBuilder.setPvpType(pvpType);
        INSTANCE.parseBattlEyeStatus($this$addWorld, columns);
        String string = ((Element)columns.get(5)).text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        String additionalProperties = string;
        $this$addWorld.setTransferType(StringsKt.contains$default((CharSequence)additionalProperties, (CharSequence)"blocked", (boolean)false, (int)2, null) ? TransferType.BLOCKED : (StringsKt.contains$default((CharSequence)additionalProperties, (CharSequence)"locked", (boolean)false, (int)2, null) ? TransferType.LOCKED : TransferType.REGULAR));
        $this$addWorld.setPremiumRestricted(StringsKt.contains$default((CharSequence)additionalProperties, (CharSequence)"premium", (boolean)false, (int)2, null));
        $this$addWorld.setExperimental(StringsKt.contains$default((CharSequence)additionalProperties, (CharSequence)"experimental", (boolean)false, (int)2, null));
        return Unit.INSTANCE;
    }
}

