/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.NewsBuilder;
import com.galarzaa.tibiakt.core.enums.NewsCategory;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.news.News;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/NewsParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/news/News;", "<init>", "()V", "fromContent", "content", "", "newsId", "", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nNewsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewsParser.kt\ncom/galarzaa/tibiakt/core/parsers/NewsParser\n+ 2 NewsBuilder.kt\ncom/galarzaa/tibiakt/core/builders/NewsBuilderKt\n*L\n1#1,62:1\n28#2:63\n25#2:64\n*S KotlinDebug\n*F\n+ 1 NewsParser.kt\ncom/galarzaa/tibiakt/core/parsers/NewsParser\n*L\n44#1:63\n44#1:64\n*E\n"})
public final class NewsParser
implements Parser<News> {
    @NotNull
    public static final NewsParser INSTANCE = new NewsParser();

    private NewsParser() {
    }

    @Override
    @Nullable
    public News fromContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return this.fromContent(content, 0);
    }

    @Nullable
    public final News fromContent(@NotNull String content, int newsId) {
        NewsBuilder newsBuilder;
        block7: {
            Element element;
            String newsDate;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Element boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
            Element element2 = boxContent.selectFirst("div.NewsHeadlineText");
            if (element2 == null) {
                Element element3 = boxContent.selectFirst("div.CaptionContainer");
                String string = element3 != null ? ElementsKt.cleanText(element3) : null;
                if (string == null) {
                    string = "";
                }
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"not found", (boolean)false, (int)2, null)) {
                    return null;
                }
                throw new ParsingException("News headline not found.", null, 2, null);
            }
            Element titleContainer = element2;
            Element element4 = boxContent.selectFirst("img.NewsHeadlineIcon");
            if (element4 == null) {
                throw new ParsingException("News icon not found.", null, 2, null);
            }
            Element icon = element4;
            boolean $i$f$news = false;
            boolean $i$f$newsBuilder = false;
            NewsBuilder $this$fromContent_u24lambda_u241 = newsBuilder = new NewsBuilder();
            boolean bl = false;
            $this$fromContent_u24lambda_u241.setId(newsId);
            $this$fromContent_u24lambda_u241.setTitle(ElementsKt.cleanText(titleContainer));
            String string = icon.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            NewsCategory newsCategory = NewsCategory.Companion.fromIcon(string);
            if (newsCategory == null) {
                throw new ParsingException("Unexpected news icon found: " + icon.attr("src"), null, 2, null);
            }
            $this$fromContent_u24lambda_u241.setCategory(newsCategory);
            Object object = boxContent.selectFirst("div.NewsHeadlineDate");
            String string2 = newsDate = object != null && (object = ElementsKt.cleanText(object)) != null && (object = StringExtensionsKt.remove$default((String)object, "-", false, 2, null)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
            if (string2 == null) {
                throw new ParsingException("News date not found.", null, 2, null);
            }
            $this$fromContent_u24lambda_u241.setDate(DatesKt.parseTibiaDate(string2));
            Object object2 = boxContent.selectFirst("td.NewsTableContainer");
            if (object2 == null || (object2 = object2.html()) == null) {
                throw new ParsingException("News content not found.", null, 2, null);
            }
            $this$fromContent_u24lambda_u241.setContent((String)object2);
            Element element5 = boxContent.selectFirst("div.NewsForumLink > a");
            if (element5 == null) break block7;
            Element $this$fromContent_u24lambda_u241_u24lambda_u240 = element = element5;
            boolean bl2 = false;
            Object object3 = ElementsKt.getLinkInformation($this$fromContent_u24lambda_u241_u24lambda_u240);
            $this$fromContent_u24lambda_u241.setThreadId(object3 != null && (object3 = ((LinkInformation)object3).getQueryParams()) != null && (object3 = (List)((HashMap)object3).get("threadid")) != null && (object3 = (String)object3.get(0)) != null ? Integer.valueOf(Integer.parseInt((String)object3)) : null);
        }
        return newsBuilder.build();
    }

    public static /* synthetic */ News fromContent$default(NewsParser newsParser, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return newsParser.fromContent(string, n);
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

