/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.NewsArchiveBuilder;
import com.galarzaa.tibiakt.core.builders.NewsArchiveBuilderKt;
import com.galarzaa.tibiakt.core.enums.NewsCategory;
import com.galarzaa.tibiakt.core.enums.NewsType;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.news.NewsArchive;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\t*\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/NewsArchiveParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/news/NewsArchive;", "<init>", "()V", "fromContent", "content", "", "parseResultsTable", "", "Lcom/galarzaa/tibiakt/core/builders/NewsArchiveBuilder;", "table", "Lorg/jsoup/nodes/Element;", "parseFilterTable", "element", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nNewsArchiveParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewsArchiveParser.kt\ncom/galarzaa/tibiakt/core/parsers/NewsArchiveParser\n+ 2 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n33#2:106\n1#3:107\n1#3:108\n*S KotlinDebug\n*F\n+ 1 NewsArchiveParser.kt\ncom/galarzaa/tibiakt/core/parsers/NewsArchiveParser\n*L\n74#1:106\n74#1:107\n*E\n"})
public final class NewsArchiveParser
implements Parser<NewsArchive> {
    @NotNull
    public static final NewsArchiveParser INSTANCE = new NewsArchiveParser();

    private NewsArchiveParser() {
    }

    @Override
    @NotNull
    public NewsArchive fromContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Document document = Jsoup.parse((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        Element element = document2.selectFirst("div.BoxContent");
        if (element == null) {
            throw new ParsingException("BoxContent container not found", null, 2, null);
        }
        Element boxContent = element;
        Map tables = ElementsKt.parseTablesMap$default(boxContent, null, 1, null);
        if (!tables.containsKey("News Archive Search")) {
            throw new ParsingException("news search not found in page", null, 2, null);
        }
        return NewsArchiveBuilderKt.newsArchive((Function1<? super NewsArchiveBuilder, Unit>)((Function1)arg_0 -> NewsArchiveParser.fromContent$lambda$2(boxContent, tables, arg_0)));
    }

    private final void parseResultsTable(NewsArchiveBuilder $this$parseResultsTable, Element table) {
        Iterator iterator = ElementsKt.rows(table).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Enum enum_;
            NewsArchiveBuilder newsArchiveBuilder;
            int n;
            String string;
            NewsCategory newsCategory;
            LocalDate localDate;
            String newsType;
            block9: {
                Enum[] enumArray;
                NewsCategory category;
                Element typeLabel;
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Element row = (Element)e;
                Elements rows = ElementsKt.cells(row);
                if (rows.size() != 3) continue;
                Object e2 = ((List)rows).get(0);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"component1(...)");
                Element iconColumn = (Element)e2;
                Object e3 = ((List)rows).get(1);
                Intrinsics.checkNotNullExpressionValue(e3, (String)"component2(...)");
                Element dateColumn = (Element)e3;
                Object e4 = ((List)rows).get(2);
                Intrinsics.checkNotNullExpressionValue(e4, (String)"component3(...)");
                Element titleColumn = (Element)e4;
                Object object = iconColumn.selectFirst("img");
                if (object == null || (object = object.attr("src")) == null) {
                    throw new ParsingException("category icon not found", null, 2, null);
                }
                Object iconUrl = object;
                if (NewsCategory.Companion.fromIcon((String)iconUrl) == null) {
                    throw new ParsingException("unknown category icon found: " + (String)iconUrl, null, 2, null);
                }
                Object object2 = titleColumn.selectFirst("a");
                if (object2 == null || (object2 = ElementsKt.getLinkInformation((Element)object2)) == null || (object2 = ((LinkInformation)object2).getQueryParams()) == null || (object2 = (List)((HashMap)object2).get("id")) == null || (object2 = (String)object2.get(0)) == null) {
                    throw new ParsingException("Could not find link", null, 2, null);
                }
                int newsId = Integer.parseInt((String)object2);
                if (dateColumn.selectFirst("small") == null) {
                    throw new ParsingException("could not find type label", null, 2, null);
                }
                newsType = ElementsKt.cleanText(typeLabel);
                typeLabel.remove();
                StringEnum.Companion companion = StringEnum.Companion;
                localDate = DatesKt.parseTibiaDate(ElementsKt.cleanText(dateColumn));
                newsCategory = category;
                string = ElementsKt.cleanText(titleColumn);
                n = newsId;
                newsArchiveBuilder = $this$parseResultsTable;
                boolean $i$f$fromValue = false;
                Enum[] it$iv = enumArray = NewsType.class;
                boolean bl = false;
                Object object3 = it$iv.isEnum() ? enumArray : null;
                if (object3 != null && (object3 = (Enum[])object3.getEnumConstants()) != null) {
                    Enum[] enumArray2 = object3;
                    int n2 = enumArray2.length;
                    for (int i = 0; i < n2; ++i) {
                        Enum enum_2;
                        Enum it$iv2 = enum_2 = enumArray2[i];
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv2)).getValue(), (Object)newsType) || Intrinsics.areEqual((Object)it$iv2.name(), (Object)newsType))) continue;
                        enum_ = enum_2;
                        break block9;
                    }
                    enum_ = null;
                } else {
                    enum_ = null;
                }
            }
            Enum enum_3 = enum_;
            NewsType newsType2 = (NewsType)enum_3;
            if (newsType2 == null) {
                throw new ParsingException("unexpected news type found: " + newsType, null, 2, null);
            }
            newsArchiveBuilder.addEntry(n, string, newsCategory, localDate, newsType2);
        }
    }

    private final void parseFilterTable(NewsArchiveBuilder $this$parseFilterTable, Element element) {
        Collection collection;
        FormData formData = ElementsKt.formData(element);
        String string = formData.getValues().get("filter_begin_year");
        if (string == null) {
            throw new ParsingException("could not find filter_begin_year in form", null, 2, null);
        }
        String string2 = formData.getValues().get("filter_begin_month");
        if (string2 == null) {
            throw new ParsingException("could not find filter_begin_month in form", null, 2, null);
        }
        String string3 = formData.getValues().get("filter_begin_day");
        if (string3 == null) {
            throw new ParsingException("could not find filter_begin_day in form", null, 2, null);
        }
        $this$parseFilterTable.setStartDate(LocalDate.of(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3)));
        String string4 = formData.getValues().get("filter_end_year");
        if (string4 == null) {
            throw new ParsingException("could not find filter_end_year in form", null, 2, null);
        }
        String string5 = formData.getValues().get("filter_end_month");
        if (string5 == null) {
            throw new ParsingException("could not find filter_end_month in form", null, 2, null);
        }
        String string6 = formData.getValues().get("filter_end_day");
        if (string6 == null) {
            throw new ParsingException("could not find filter_end_day in form", null, 2, null);
        }
        $this$parseFilterTable.setEndDate(LocalDate.of(Integer.parseInt(string4), Integer.parseInt(string5), Integer.parseInt(string6)));
        for (NewsCategory newsCategory : NewsCategory.values()) {
            collection = formData.getValuesMultiple().get(newsCategory.getFilterName());
            if (collection == null || collection.isEmpty()) continue;
            $this$parseFilterTable.addCategory(newsCategory);
        }
        for (Enum enum_ : NewsType.values()) {
            collection = formData.getValuesMultiple().get(((NewsType)enum_).getFilterName());
            if (collection == null || collection.isEmpty()) continue;
            $this$parseFilterTable.addType((NewsType)enum_);
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final Unit fromContent$lambda$2(Element $boxContent, Map $tables, NewsArchiveBuilder $this$newsArchive) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$newsArchive, (String)"$this$newsArchive");
            Element element = $boxContent.selectFirst("form");
            if (element != null) {
                Element element2;
                Element $this$fromContent_u24lambda_u242_u24lambda_u240 = element2 = element;
                boolean bl = false;
                INSTANCE.parseFilterTable($this$newsArchive, $this$fromContent_u24lambda_u242_u24lambda_u240);
            }
            Element element3 = (Element)$tables.get("Search Results");
            if (element3 == null) break block1;
            Element it = element3;
            boolean bl = false;
            INSTANCE.parseResultsTable($this$newsArchive, it);
        }
        return Unit.INSTANCE;
    }
}

