/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.LeaderboardBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.leaderboards.BaseLeaderboardEntry;
import com.galarzaa.tibiakt.core.models.leaderboards.DeletedLeaderboardEntry;
import com.galarzaa.tibiakt.core.models.leaderboards.Leaderboard;
import com.galarzaa.tibiakt.core.models.leaderboards.LeaderboardEntry;
import com.galarzaa.tibiakt.core.models.leaderboards.LeaderboardRotation;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/LeaderboardParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/leaderboards/Leaderboard;", "<init>", "()V", "rotationEndPattern", "Lkotlin/text/Regex;", "fromContent", "content", "", "parseLeaderboardEntries", "", "Lcom/galarzaa/tibiakt/core/builders/LeaderboardBuilder;", "entriesTable", "Lorg/jsoup/nodes/Element;", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nLeaderboardParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeaderboardParser.kt\ncom/galarzaa/tibiakt/core/parsers/LeaderboardParser\n+ 2 LeaderboardBuilder.kt\ncom/galarzaa/tibiakt/core/builders/LeaderboardBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n27#2:111\n1187#3,2:112\n1261#3,4:114\n*S KotlinDebug\n*F\n+ 1 LeaderboardParser.kt\ncom/galarzaa/tibiakt/core/parsers/LeaderboardParser\n*L\n50#1:111\n53#1:112,2\n53#1:114,4\n*E\n"})
public final class LeaderboardParser
implements Parser<Leaderboard> {
    @NotNull
    public static final LeaderboardParser INSTANCE = new LeaderboardParser();
    @NotNull
    private static final Regex rotationEndPattern = new Regex("ends on ([^)]+)");

    private LeaderboardParser() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Leaderboard fromContent(@NotNull String content) {
        void $this$associateTo$iv$iv;
        Iterator $this$associate$iv;
        LeaderboardBuilder leaderboardBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Element boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
        Elements elements = boxContent.select("table.TableContent");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements tables = elements;
        boolean $i$f$leaderboard = false;
        LeaderboardBuilder $this$fromContent_u24lambda_u241 = leaderboardBuilder = new LeaderboardBuilder();
        boolean bl = false;
        Object object = ((Element)tables.get(1)).selectFirst("form");
        if (object == null || (object = ElementsKt.formData((Element)object)) == null) {
            throw new ParsingException("form not found", null, 2, null);
        }
        Object formData = object;
        Elements elements2 = ((Element)tables.get(1)).select("select[name=rotation] > option");
        Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
        Iterable iterable = (Iterable)elements2;
        boolean $i$f$associate2 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
        void var12_14 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            String string = it.attr("value");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            Integer n = Integer.parseInt(string);
            Intrinsics.checkNotNull((Object)it);
            Pair pair = TuplesKt.to((Object)n, (Object)ElementsKt.cleanText(it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map rotationOptions = destination$iv$iv;
        for (Map.Entry $i$f$associate2 : rotationOptions.entrySet()) {
            String label;
            int rotationId = ((Number)$i$f$associate2.getKey()).intValue();
            String cleanLabel = label = (String)$i$f$associate2.getValue();
            boolean isCurrent = false;
            if (StringsKt.contains$default((CharSequence)label, (CharSequence)"Current", (boolean)false, (int)2, null)) {
                Object object2 = Regex.find$default((Regex)rotationEndPattern, (CharSequence)label, (int)0, (int)2, null);
                if (object2 == null || (object2 = object2.getGroupValues()) == null || (object2 = (String)CollectionsKt.last((List)object2)) == null) {
                    throw new ParsingException("rotation option label doesn't match expected format", null, 2, null);
                }
                cleanLabel = object2;
                isCurrent = true;
            }
            Instant rotationEnd = DatesKt.parseTibiaDateTime(cleanLabel);
            LeaderboardRotation rotation = new LeaderboardRotation(rotationId, isCurrent, rotationEnd);
            if (isCurrent) {
                $this$fromContent_u24lambda_u241.setRotation(rotation);
            }
            $this$fromContent_u24lambda_u241.addAvailableRotation(rotation);
        }
        String string = ((FormData)formData).getValues().get("world");
        if (string == null) {
            if (((FormData)formData).getAvailableOptions().containsKey("world")) {
                return null;
            }
            throw new ParsingException("world form parameter not found", null, 2, null);
        }
        $this$fromContent_u24lambda_u241.setWorld(string);
        if (tables.size() == 4) {
            String string2 = ((Element)tables.get(2)).text();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
            String lastUpdateString = string2;
            Object object3 = Regex.find$default((Regex)new Regex("(\\d+)"), (CharSequence)lastUpdateString, (int)0, (int)2, null);
            if (object3 == null || (object3 = object3.getGroups()) == null || (object3 = object3.get(0)) == null || (object3 = object3.getValue()) == null) {
                throw new ParsingException("unexpected last update text: " + lastUpdateString, null, 2, null);
            }
            int minutes = Integer.parseInt((String)object3);
            $this$fromContent_u24lambda_u241.setLastUpdated(Clock.System.INSTANCE.now().minus-LRDsOJo(DurationKt.toDuration((int)minutes, (DurationUnit)DurationUnit.MINUTES)));
        }
        Element entriesTable = tables.last();
        INSTANCE.parseLeaderboardEntries($this$fromContent_u24lambda_u241, entriesTable);
        Object object4 = boxContent.selectFirst("small");
        if (object4 == null || (object4 = ElementsKt.parsePagination((Element)object4)) == null) {
            object4 = PaginationData.Companion.default();
        }
        Object paginationData = object4;
        $this$fromContent_u24lambda_u241.setCurrentPage(((PaginationData)paginationData).getCurrentPage());
        $this$fromContent_u24lambda_u241.setResultsCount(((PaginationData)paginationData).getResultsCount());
        $this$fromContent_u24lambda_u241.setTotalPages(((PaginationData)paginationData).getTotalPages());
        return leaderboardBuilder.build();
    }

    private final void parseLeaderboardEntries(LeaderboardBuilder $this$parseLeaderboardEntries, Element entriesTable) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(entriesTable), 1)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            Elements cells = ElementsKt.cells(row);
            if (cells.size() != 3) continue;
            Object object = ((Element)cells.get(1)).selectFirst("a");
            String name = object != null && (object = ElementsKt.getLinkInformation((Element)object)) != null && (object = ((LinkInformation)object).getTitle()) != null ? StringExtensionsKt.clean((String)object) : null;
            String string = ((Element)cells.get(0)).text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            int rank = Integer.parseInt(StringExtensionsKt.remove$default(string, ".", false, 2, null));
            String string2 = ((Element)cells.get(2)).text();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
            int dromeLevel = Integer.parseInt(string2);
            $this$parseLeaderboardEntries.addEntry(name != null ? (BaseLeaderboardEntry)new LeaderboardEntry(rank, name, dromeLevel) : (BaseLeaderboardEntry)new DeletedLeaderboardEntry(rank, dromeLevel));
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

