/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.KillStatisticsBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.KillStatistics;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/KillStatisticsParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/KillStatistics;", "<init>", "()V", "fromContent", "content", "", "parseKillStatisticsTable", "", "Lcom/galarzaa/tibiakt/core/builders/KillStatisticsBuilder;", "table", "Lorg/jsoup/nodes/Element;", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nKillStatisticsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KillStatisticsParser.kt\ncom/galarzaa/tibiakt/core/parsers/KillStatisticsParser\n+ 2 KillStatisticsBuilder.kt\ncom/galarzaa/tibiakt/core/builders/KillStatisticsBuilderKt\n*L\n1#1,72:1\n25#2:73\n*S KotlinDebug\n*F\n+ 1 KillStatisticsParser.kt\ncom/galarzaa/tibiakt/core/parsers/KillStatisticsParser\n*L\n40#1:73\n*E\n"})
public final class KillStatisticsParser
implements Parser<KillStatistics> {
    @NotNull
    public static final KillStatisticsParser INSTANCE = new KillStatisticsParser();

    private KillStatisticsParser() {
    }

    @Override
    @Nullable
    public KillStatistics fromContent(@NotNull String content) {
        KillStatisticsBuilder $this$fromContent_u24lambda_u241;
        KillStatisticsBuilder killStatisticsBuilder;
        Object formData;
        Element boxContent;
        block8: {
            block7: {
                Element element;
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
                Object object = boxContent.selectFirst("form");
                if (object == null || (object = ElementsKt.formData((Element)object)) == null) {
                    throw new ParsingException("Could not find world selection form", null, 2, null);
                }
                formData = object;
                CharSequence charSequence = ((FormData)formData).getValues().get("world");
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return null;
                }
                Map<String, Element> tables = ElementsKt.parseTablesMap(boxContent, "table.Table1, table.Table3");
                boolean $i$f$killStatistics = false;
                $this$fromContent_u24lambda_u241 = killStatisticsBuilder = new KillStatisticsBuilder();
                boolean bl = false;
                Element element2 = tables.get("Kill Statistics");
                if (element2 == null) break block7;
                Element $this$fromContent_u24lambda_u241_u24lambda_u240 = element = element2;
                boolean bl2 = false;
                INSTANCE.parseKillStatisticsTable($this$fromContent_u24lambda_u241, $this$fromContent_u24lambda_u241_u24lambda_u240);
                element2 = element;
                if (element2 != null) break block8;
            }
            throw new ParsingException("kill statistics table not found", null, 2, null);
        }
        if (boxContent.selectFirst("form") == null) {
            throw new ParsingException("could not find form in value", null, 2, null);
        }
        String string = ((FormData)formData).getValues().get("world");
        if (string == null) {
            throw new ParsingException("could not find world value in form", null, 2, null);
        }
        $this$fromContent_u24lambda_u241.setWorld(string);
        return killStatisticsBuilder.build();
    }

    private final void parseKillStatisticsTable(KillStatisticsBuilder $this$parseKillStatisticsTable, Element table) {
        Element innerTable = table.selectFirst("table.TableContent");
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(innerTable), 2)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            List<String> columnns = ElementsKt.cellsText(row);
            KillStatisticsBuilder killStatisticsBuilder = Intrinsics.areEqual((Object)columnns.get(0), (Object)"Total") ? $this$parseKillStatisticsTable.total(Integer.parseInt(columnns.get(1)), Integer.parseInt(columnns.get(2)), Integer.parseInt(columnns.get(3)), Integer.parseInt(columnns.get(4))) : $this$parseKillStatisticsTable.addEntry(columnns.get(0), Integer.parseInt(columnns.get(1)), Integer.parseInt(columnns.get(2)), Integer.parseInt(columnns.get(3)), Integer.parseInt(columnns.get(4)));
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

