/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.HousesSectionBuilder;
import com.galarzaa.tibiakt.core.enums.HouseOrder;
import com.galarzaa.tibiakt.core.enums.HouseStatus;
import com.galarzaa.tibiakt.core.enums.HouseType;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.house.HousesSection;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import com.galarzaa.tibiakt.core.utils.MapExtensionsKt;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/HousesSectionParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/house/HousesSection;", "<init>", "()V", "auctionInfoRegex", "Lkotlin/text/Regex;", "fromContent", "content", "", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nHousesSectionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HousesSectionParser.kt\ncom/galarzaa/tibiakt/core/parsers/HousesSectionParser\n+ 2 HousesSectionBuilder.kt\ncom/galarzaa/tibiakt/core/builders/HousesSectionBuilderKt\n+ 3 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n29#2:96\n33#3:97\n33#3:99\n33#3:101\n1#4:98\n1#4:100\n1#4:102\n*S KotlinDebug\n*F\n+ 1 HousesSectionParser.kt\ncom/galarzaa/tibiakt/core/parsers/HousesSectionParser\n*L\n45#1:96\n52#1:97\n53#1:99\n55#1:101\n52#1:98\n53#1:100\n55#1:102\n*E\n"})
public final class HousesSectionParser
implements Parser<HousesSection> {
    @NotNull
    public static final HousesSectionParser INSTANCE = new HousesSectionParser();
    @NotNull
    private static final Regex auctionInfoRegex = new Regex("\\((?<bid>\\d+) gold; (?<timeLeft>\\w)+ (?<timeUnit>day|hour)s? left\\)");

    private HousesSectionParser() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public HousesSection fromContent(@NotNull String content) {
        HousesSectionBuilder housesSectionBuilder;
        block34: {
            block33: {
                Object object;
                Element element;
                Map tables;
                HousesSectionBuilder $this$fromContent_u24lambda_u246;
                block32: {
                    block31: {
                        Object object2;
                        Object this_$iv;
                        Element element2;
                        block30: {
                            Enum enum_;
                            String value$iv;
                            boolean bl;
                            Object object3;
                            Enum[] it$iv;
                            boolean $i$f$fromValue;
                            int n;
                            HousesSectionBuilder housesSectionBuilder2;
                            Object form;
                            block29: {
                                Enum enum_2;
                                StringEnum.Companion value$iv2;
                                block28: {
                                    Enum[] enumArray;
                                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                                    Element boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
                                    boolean $i$f$housesSection = false;
                                    $this$fromContent_u24lambda_u246 = housesSectionBuilder = new HousesSectionBuilder();
                                    boolean bl2 = false;
                                    tables = ElementsKt.parseTablesMap$default(boxContent, null, 1, null);
                                    element2 = (Element)tables.get("House Search");
                                    if (element2 == null) break block31;
                                    Element $this$fromContent_u24lambda_u246_u24lambda_u241 = element = element2;
                                    boolean bl3 = false;
                                    Object object4 = boxContent.selectFirst("div.BoxContent > form");
                                    if (object4 == null || (object4 = ElementsKt.formData((Element)object4)) == null) {
                                        throw new ParsingException("could not find house form", null, 2, null);
                                    }
                                    form = object4;
                                    String string = ((FormData)form).getValues().get("world");
                                    if (string == null) {
                                        throw new ParsingException("could not find world value in form", null, 2, null);
                                    }
                                    $this$fromContent_u24lambda_u246.setWorld(string);
                                    String string2 = ((FormData)form).getValues().get("town");
                                    if (string2 == null) {
                                        throw new ParsingException("could not find town value in form", null, 2, null);
                                    }
                                    $this$fromContent_u24lambda_u246.setTown(string2);
                                    StringEnum.Companion companion = StringEnum.Companion;
                                    String string3 = ((FormData)form).getValues().get("state");
                                    housesSectionBuilder2 = $this$fromContent_u24lambda_u246;
                                    boolean $i$f$fromValue2 = false;
                                    Enum[] it$iv2 = enumArray = HouseStatus.class;
                                    boolean bl42 = false;
                                    Object object5 = it$iv2.isEnum() ? enumArray : null;
                                    if (object5 != null && (object5 = (Enum[])object5.getEnumConstants()) != null) {
                                        Enum[] bl42 = object5;
                                        n = bl42.length;
                                        for (int i = 0; i < n; ++i) {
                                            Enum enum_3;
                                            Enum it$iv3 = enum_3 = bl42[i];
                                            boolean bl5 = false;
                                            if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv3)).getValue(), (Object)value$iv2) || Intrinsics.areEqual((Object)it$iv3.name(), (Object)value$iv2))) continue;
                                            enum_2 = enum_3;
                                            break block28;
                                        }
                                        enum_2 = null;
                                    } else {
                                        enum_2 = null;
                                    }
                                }
                                housesSectionBuilder2.setStatus((HouseStatus)enum_2);
                                value$iv2 = StringEnum.Companion;
                                String $i$f$fromValue2 = ((FormData)form).getValues().get("type");
                                housesSectionBuilder2 = $this$fromContent_u24lambda_u246;
                                $i$f$fromValue = false;
                                object = HouseType.class;
                                it$iv = object;
                                boolean bl62 = false;
                                Object object6 = it$iv.isEnum() ? object : null;
                                if (object6 != null && (object6 = (Enum[])object6.getEnumConstants()) != null) {
                                    Enum[] bl62 = object6;
                                    int n2 = bl62.length;
                                    for (n = 0; n < n2; ++n) {
                                        object3 = bl62[n];
                                        Enum it$iv4 = object3;
                                        bl = false;
                                        if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv4)).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)it$iv4.name(), (Object)value$iv))) continue;
                                        enum_ = object3;
                                        break block29;
                                    }
                                    enum_ = null;
                                } else {
                                    enum_ = null;
                                }
                            }
                            HouseType houseType = (HouseType)enum_;
                            if (houseType == null) {
                                throw new ParsingException("could not find type value in form", null, 2, null);
                            }
                            housesSectionBuilder2.setType(houseType);
                            this_$iv = StringEnum.Companion;
                            value$iv = ((FormData)form).getValues().get("order");
                            $i$f$fromValue = false;
                            object = HouseOrder.class;
                            it$iv = object;
                            boolean bl72 = false;
                            Object object7 = it$iv.isEnum() ? object : null;
                            if (object7 != null && (object7 = (Enum[])((Class)object7).getEnumConstants()) != null) {
                                Object bl72 = object7;
                                int n3 = ((Object)bl72).length;
                                for (n = 0; n < n3; ++n) {
                                    Object it$iv5 = object3 = bl72[n];
                                    bl = false;
                                    if (!(Intrinsics.areEqual((Object)((StringEnum)it$iv5).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv5).name(), (Object)value$iv))) continue;
                                    object2 = object3;
                                    break block30;
                                }
                                object2 = null;
                            } else {
                                object2 = null;
                            }
                        }
                        HouseOrder houseOrder = (HouseOrder)object2;
                        if (houseOrder != null) {
                            Object it = this_$iv = houseOrder;
                            boolean bl = false;
                            $this$fromContent_u24lambda_u246.setOrder((HouseOrder)it);
                        }
                        if ((element2 = element) != null) break block32;
                    }
                    throw new ParsingException("House Search table not found", null, 2, null);
                }
                Element element3 = (Element)MapExtensionsKt.getContaining$default(tables, "Available", null, 2, null);
                if (element3 == null) break block33;
                Element $this$fromContent_u24lambda_u246_u24lambda_u245 = element = element3;
                boolean bl = false;
                for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows($this$fromContent_u24lambda_u246_u24lambda_u245), 1)) {
                    Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
                    Element row = (Element)t;
                    Elements columns = ElementsKt.cells(row);
                    if (columns.size() != 5) break;
                    Object object8 = columns.get(3);
                    Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
                    String statusText = ElementsKt.cleanText((Element)object8);
                    Ref.ObjectRef timeLeft = new Ref.ObjectRef();
                    Ref.ObjectRef highestBid = new Ref.ObjectRef();
                    if (Regex.find$default((Regex)auctionInfoRegex, (CharSequence)statusText, (int)0, (int)2, null) != null) {
                        long l;
                        void it;
                        Object $this$fromContent_u24lambda_u246_u24lambda_u245_u24lambda_u243 = object;
                        boolean bl8 = false;
                        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$fromContent_u24lambda_u246_u24lambda_u245_u24lambda_u243.getGroups(), (String)"bid");
                        Intrinsics.checkNotNull((Object)matchGroup);
                        highestBid.element = Integer.parseInt(matchGroup.getValue());
                        MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$fromContent_u24lambda_u246_u24lambda_u245_u24lambda_u243.getGroups(), (String)"timeUnit");
                        Intrinsics.checkNotNull((Object)matchGroup2);
                        String timeUnit = matchGroup2.getValue();
                        MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$fromContent_u24lambda_u246_u24lambda_u245_u24lambda_u243.getGroups(), (String)"timeLeft");
                        Intrinsics.checkNotNull((Object)matchGroup3);
                        long l2 = Long.parseLong(matchGroup3.getValue());
                        Ref.ObjectRef objectRef = timeLeft;
                        boolean bl9 = false;
                        String string = timeUnit;
                        if (Intrinsics.areEqual((Object)string, (Object)"hour")) {
                            l = DurationKt.toDuration((long)it, (DurationUnit)DurationUnit.HOURS);
                        } else if (Intrinsics.areEqual((Object)string, (Object)"day")) {
                            l = DurationKt.toDuration((long)it, (DurationUnit)DurationUnit.DAYS);
                        } else {
                            throw new ParsingException("unknown time unit " + timeUnit, null, 2, null);
                        }
                        objectRef.element = Duration.box-impl((long)l);
                    }
                    $this$fromContent_u24lambda_u246.addEntry((Function1<? super HousesSectionBuilder.HouseEntryBuilder, Unit>)((Function1)arg_0 -> HousesSectionParser.fromContent$lambda$6$lambda$5$lambda$4(columns, statusText, timeLeft, highestBid, $this$fromContent_u24lambda_u246, arg_0)));
                }
                if ((element3 = element) != null) break block34;
            }
            return null;
        }
        return housesSectionBuilder.build();
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final Unit fromContent$lambda$6$lambda$5$lambda$4(Elements $columns, String $statusText, Ref.ObjectRef $timeLeft, Ref.ObjectRef $highestBid, HousesSectionBuilder $this_housesSection, HousesSectionBuilder.HouseEntryBuilder $this$addEntry) {
        Intrinsics.checkNotNullParameter((Object)$this$addEntry, (String)"$this$addEntry");
        Object object = $columns.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$addEntry.setName(ElementsKt.cleanText((Element)object));
        Object object2 = $columns.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        $this$addEntry.setSize(StringExtensionsKt.parseInteger(StringExtensionsKt.remove$default(ElementsKt.cleanText((Element)object2), "sqm", false, 2, null)));
        Object object3 = $columns.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        $this$addEntry.setRent(StringExtensionsKt.parseThousandSuffix(StringExtensionsKt.remove$default(ElementsKt.cleanText((Element)object3), "gold", false, 2, null)));
        $this$addEntry.setStatus(StringsKt.contains$default((CharSequence)$statusText, (CharSequence)"auctioned", (boolean)false, (int)2, null) ? HouseStatus.AUCTIONED : HouseStatus.RENTED);
        Object object4 = ((Element)$columns.get(4)).selectFirst("input[name=houseid]");
        if (object4 == null || (object4 = object4.val()) == null) {
            throw new ParsingException("could not find view button for house", null, 2, null);
        }
        $this$addEntry.setHouseId(Integer.parseInt((String)object4));
        $this$addEntry.setTimeLeft-BwNAW2A((Duration)$timeLeft.element);
        $this$addEntry.setHighestBid((Integer)$highestBid.element);
        $this$addEntry.setTown($this_housesSection.getTown());
        $this$addEntry.setWorld($this_housesSection.getWorld());
        $this$addEntry.setType($this_housesSection.getType());
        return Unit.INSTANCE;
    }
}

