/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.HouseBuilder;
import com.galarzaa.tibiakt.core.enums.HouseStatus;
import com.galarzaa.tibiakt.core.enums.HouseType;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.house.House;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0004R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0004R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/HouseParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/house/House;", "<init>", "()V", "rentedPattern", "Lkotlin/text/Regex;", "getRentedPattern$annotations", "auctionedPattern", "bidPattern", "getBidPattern$annotations", "moveOutPattern", "transferPattern", "getTransferPattern$annotations", "fromContent", "content", "", "parseStatusDescription", "", "Lcom/galarzaa/tibiakt/core/builders/HouseBuilder;", "stateLine", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nHouseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HouseParser.kt\ncom/galarzaa/tibiakt/core/parsers/HouseParser\n+ 2 HouseBuilder.kt\ncom/galarzaa/tibiakt/core/builders/HouseBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n26#2:101\n1557#3:102\n1628#3,3:103\n33#4:106\n33#4:108\n1#5:107\n1#5:109\n*S KotlinDebug\n*F\n+ 1 HouseParser.kt\ncom/galarzaa/tibiakt/core/parsers/HouseParser\n*L\n54#1:101\n59#1:102\n59#1:103,3\n76#1:106\n81#1:108\n76#1:107\n81#1:109\n*E\n"})
public final class HouseParser
implements Parser<House> {
    @NotNull
    public static final HouseParser INSTANCE = new HouseParser();
    @NotNull
    private static final Regex rentedPattern = new Regex("The (?<type>\\w+) has been rented by (?<owner>[^.]+)\\. (?<pronoun>\\w+) has paid the rent until (?<paidUntil>[^.]+)\\.");
    @NotNull
    private static final Regex auctionedPattern = new Regex("The (?<type>\\w+) is currently being auctioned.");
    @NotNull
    private static final Regex bidPattern = new Regex("The auction will end at (?<auctionEnd>[^.]+)\\. The highest bid so far is (?<highestBid>\\d+) gold and has been submitted by (?<bidder>[^.]+)");
    @NotNull
    private static final Regex moveOutPattern = new Regex("S?[Hh]e will move out on (?<moveDate>[^.]+) \\(time of daily");
    @NotNull
    private static final Regex transferPattern = new Regex("and (?<action>wants to|will) pass the house to (?<transferee>[\\w\\s]+) for (?<transferPrice>\\d+) gold coin");

    private HouseParser() {
    }

    private static /* synthetic */ void getRentedPattern$annotations() {
    }

    private static /* synthetic */ void getBidPattern$annotations() {
    }

    private static /* synthetic */ void getTransferPattern$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public House fromContent(@NotNull String content) {
        void $this$mapTo$iv$iv;
        String imageUrl;
        HouseBuilder houseBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Element boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
        Element infoTable = boxContent.selectFirst("table");
        boolean $i$f$house = false;
        HouseBuilder $this$fromContent_u24lambda_u241 = houseBuilder = new HouseBuilder();
        boolean bl = false;
        Elements elements = ElementsKt.cells(infoTable);
        Object e = ((List)elements).get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"component1(...)");
        Element imageRow = (Element)e;
        Object e2 = ((List)elements).get(1);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"component2(...)");
        Element descriptionRow = (Element)e2;
        String string = imageRow.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"No information about this house found", (boolean)false, (int)2, null)) {
            return null;
        }
        Element element = imageRow.selectFirst("img");
        String string2 = imageUrl = element != null ? element.attr("src") : null;
        if (string2 == null) {
            throw new ParsingException("House image not found", null, 2, null);
        }
        $this$fromContent_u24lambda_u241.setHouseId(StringExtensionsKt.findInteger(string2));
        Elements elements2 = descriptionRow.select("b");
        Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
        Iterable $this$map$iv = (Iterable)elements2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(ElementsKt.cleanText((Element)it));
        }
        List list = (List)destination$iv$iv;
        String title = (String)list.get(0);
        String sizeStr = (String)list.get(1);
        String rentStr = (String)list.get(2);
        String worldStr = (String)list.get(3);
        $this$fromContent_u24lambda_u241.setName(title);
        $this$fromContent_u24lambda_u241.setSize(Integer.parseInt(StringExtensionsKt.clean(StringExtensionsKt.remove$default(sizeStr, "square meters", false, 2, null))));
        $this$fromContent_u24lambda_u241.setRent(StringExtensionsKt.parseThousandSuffix(StringExtensionsKt.remove$default(rentStr, "gold", false, 2, null)));
        $this$fromContent_u24lambda_u241.setWorld(worldStr);
        String string3 = ElementsKt.replaceBrs(descriptionRow).wholeText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wholeText(...)");
        List descriptionLines = StringsKt.lines((CharSequence)string3);
        $this$fromContent_u24lambda_u241.setBeds(StringExtensionsKt.findInteger((String)descriptionLines.get(1)));
        String statusLine = StringExtensionsKt.clean((String)CollectionsKt.last((List)descriptionLines));
        INSTANCE.parseStatusDescription($this$fromContent_u24lambda_u241, statusLine);
        return houseBuilder.build();
    }

    private final void parseStatusDescription(HouseBuilder $this$parseStatusDescription, String stateLine) {
        block14: {
            String value$iv;
            boolean bl;
            Enum it$iv;
            Enum enum_;
            int n;
            int n2;
            Enum[] it$iv2;
            Enum[] enumArray;
            boolean $i$f$fromValue;
            HouseBuilder houseBuilder;
            MatchResult matchResult;
            MatchResult matchResult2 = Regex.find$default((Regex)rentedPattern, (CharSequence)stateLine, (int)0, (int)2, null);
            if (matchResult2 != null) {
                Enum enum_2;
                MatchResult $this$parseStatusDescription_u24lambda_u242;
                block12: {
                    $this$parseStatusDescription_u24lambda_u242 = matchResult = matchResult2;
                    boolean bl2 = false;
                    $this$parseStatusDescription.setStatus(HouseStatus.RENTED);
                    MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u242.getGroups(), (String)"owner");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    $this$parseStatusDescription.setOwner(StringExtensionsKt.clean(matchGroup.getValue()));
                    MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u242.getGroups(), (String)"paidUntil");
                    Intrinsics.checkNotNull((Object)matchGroup2);
                    $this$parseStatusDescription.setPaidUntil(DatesKt.parseTibiaDateTime(matchGroup2.getValue()));
                    StringEnum.Companion companion = StringEnum.Companion;
                    StringBuilder stringBuilder = new StringBuilder();
                    MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u242.getGroups(), (String)"type");
                    Intrinsics.checkNotNull((Object)matchGroup3);
                    String string = stringBuilder.append(matchGroup3.getValue()).append('s').toString();
                    houseBuilder = $this$parseStatusDescription;
                    $i$f$fromValue = false;
                    it$iv2 = enumArray = HouseType.class;
                    boolean bl32 = false;
                    Object object = it$iv2.isEnum() ? enumArray : null;
                    if (object != null && (object = (Enum[])object.getEnumConstants()) != null) {
                        Enum[] bl32 = object;
                        n2 = bl32.length;
                        for (n = 0; n < n2; ++n) {
                            it$iv = enum_ = bl32[n];
                            bl = false;
                            if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv)).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)it$iv.name(), (Object)value$iv))) continue;
                            enum_2 = enum_;
                            break block12;
                        }
                        enum_2 = null;
                    } else {
                        enum_2 = null;
                    }
                }
                HouseType houseType = (HouseType)enum_2;
                if (houseType == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown house type found: ");
                    MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u242.getGroups(), (String)"type");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    throw new ParsingException(stringBuilder.append(matchGroup.getValue()).toString(), null, 2, null);
                }
                houseBuilder.setHouseType(houseType);
            }
            MatchResult matchResult3 = Regex.find$default((Regex)auctionedPattern, (CharSequence)stateLine, (int)0, (int)2, null);
            if (matchResult3 != null) {
                Enum enum_3;
                MatchResult $this$parseStatusDescription_u24lambda_u243;
                block13: {
                    $this$parseStatusDescription_u24lambda_u243 = matchResult = matchResult3;
                    boolean bl4 = false;
                    $this$parseStatusDescription.setStatus(HouseStatus.AUCTIONED);
                    StringEnum.Companion this_$iv = StringEnum.Companion;
                    StringBuilder stringBuilder = new StringBuilder();
                    MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u243.getGroups(), (String)"type");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    value$iv = stringBuilder.append(matchGroup.getValue()).append('s').toString();
                    houseBuilder = $this$parseStatusDescription;
                    $i$f$fromValue = false;
                    it$iv2 = enumArray = HouseType.class;
                    boolean bl5 = false;
                    Object object = it$iv2.isEnum() ? enumArray : null;
                    if (object != null && (object = (Enum[])object.getEnumConstants()) != null) {
                        Enum[] enumArray2 = object;
                        n2 = enumArray2.length;
                        for (n = 0; n < n2; ++n) {
                            it$iv = enum_ = enumArray2[n];
                            bl = false;
                            if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv)).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)it$iv.name(), (Object)value$iv))) continue;
                            enum_3 = enum_;
                            break block13;
                        }
                        enum_3 = null;
                    } else {
                        enum_3 = null;
                    }
                }
                HouseType houseType = (HouseType)enum_3;
                if (houseType == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown house type found: ");
                    MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u243.getGroups(), (String)"type");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    throw new ParsingException(stringBuilder.append(matchGroup.getValue()).toString(), null, 2, null);
                }
                houseBuilder.setHouseType(houseType);
            }
            MatchResult matchResult4 = Regex.find$default((Regex)bidPattern, (CharSequence)stateLine, (int)0, (int)2, null);
            if (matchResult4 != null) {
                MatchResult $this$parseStatusDescription_u24lambda_u244 = matchResult = matchResult4;
                boolean bl6 = false;
                $this$parseStatusDescription.setStatus(HouseStatus.AUCTIONED);
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u244.getGroups(), (String)"auctionEnd");
                Intrinsics.checkNotNull((Object)matchGroup);
                $this$parseStatusDescription.setAuctionEnd(DatesKt.parseTibiaDateTime(matchGroup.getValue()));
                MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u244.getGroups(), (String)"highestBid");
                Intrinsics.checkNotNull((Object)matchGroup4);
                $this$parseStatusDescription.setHighestBid(StringExtensionsKt.parseInteger(matchGroup4.getValue()));
                MatchGroup matchGroup5 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u244.getGroups(), (String)"bidder");
                Intrinsics.checkNotNull((Object)matchGroup5);
                $this$parseStatusDescription.setHighestBidder(StringExtensionsKt.clean(matchGroup5.getValue()));
            }
            MatchResult matchResult5 = Regex.find$default((Regex)moveOutPattern, (CharSequence)stateLine, (int)0, (int)2, null);
            if (matchResult5 != null) {
                MatchResult $this$parseStatusDescription_u24lambda_u245 = matchResult = matchResult5;
                boolean bl7 = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u245.getGroups(), (String)"moveDate");
                Intrinsics.checkNotNull((Object)matchGroup);
                $this$parseStatusDescription.setMovingDate(DatesKt.parseTibiaDateTime(matchGroup.getValue()));
            }
            MatchResult matchResult6 = Regex.find$default((Regex)transferPattern, (CharSequence)stateLine, (int)0, (int)2, null);
            if (matchResult6 == null) break block14;
            MatchResult $this$parseStatusDescription_u24lambda_u246 = matchResult = matchResult6;
            boolean bl8 = false;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u246.getGroups(), (String)"action");
            Intrinsics.checkNotNull((Object)matchGroup);
            $this$parseStatusDescription.setTransferAccepted(Intrinsics.areEqual((Object)matchGroup.getValue(), (Object)"will"));
            MatchGroup matchGroup6 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u246.getGroups(), (String)"transferee");
            Intrinsics.checkNotNull((Object)matchGroup6);
            $this$parseStatusDescription.setTransferRecipient(StringExtensionsKt.clean(matchGroup6.getValue()));
            MatchGroup matchGroup7 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseStatusDescription_u24lambda_u246.getGroups(), (String)"transferPrice");
            Intrinsics.checkNotNull((Object)matchGroup7);
            $this$parseStatusDescription.setTransferPrice(Integer.parseInt(matchGroup7.getValue()));
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

