/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.HighscoresBuilder;
import com.galarzaa.tibiakt.core.enums.HighscoresBattlEyeType;
import com.galarzaa.tibiakt.core.enums.HighscoresCategory;
import com.galarzaa.tibiakt.core.enums.HighscoresProfession;
import com.galarzaa.tibiakt.core.enums.IntEnum;
import com.galarzaa.tibiakt.core.enums.PvpType;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.enums.Vocation;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.highscores.Highscores;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import com.galarzaa.tibiakt.core.utils.MapExtensionsKt;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/HighscoresParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/highscores/Highscores;", "<init>", "()V", "numericMatch", "Lkotlin/text/Regex;", "fromContent", "content", "", "parseHighscoresFilter", "", "Lcom/galarzaa/tibiakt/core/builders/HighscoresBuilder;", "formData", "Lcom/galarzaa/tibiakt/core/utils/FormData;", "parseHighscoresTable", "element", "Lorg/jsoup/nodes/Element;", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nHighscoresParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighscoresParser.kt\ncom/galarzaa/tibiakt/core/parsers/HighscoresParser\n+ 2 HighscoresBuilder.kt\ncom/galarzaa/tibiakt/core/builders/HighscoresBuilderKt\n+ 3 IntEnum.kt\ncom/galarzaa/tibiakt/core/enums/IntEnum$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n*L\n1#1,116:1\n30#2:117\n39#3:118\n33#3:119\n39#3:121\n33#3:122\n39#3:124\n33#3:125\n1#4:120\n1#4:123\n1#4:126\n1#4:128\n33#5:127\n*S KotlinDebug\n*F\n+ 1 HighscoresParser.kt\ncom/galarzaa/tibiakt/core/parsers/HighscoresParser\n*L\n55#1:117\n82#1:118\n82#1:119\n84#1:121\n84#1:122\n86#1:124\n86#1:125\n82#1:120\n84#1:123\n86#1:126\n106#1:128\n106#1:127\n*E\n"})
public final class HighscoresParser
implements Parser<Highscores> {
    @NotNull
    public static final HighscoresParser INSTANCE = new HighscoresParser();
    @NotNull
    private static final Regex numericMatch = new Regex("(\\d+)");

    private HighscoresParser() {
    }

    @Override
    @Nullable
    public Highscores fromContent(@NotNull String content) {
        Object object;
        Object object2;
        Element it;
        Element element;
        HighscoresBuilder highscoresBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Document document = Jsoup.parse((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        Element element2 = document2.selectFirst("div.BoxContent");
        if (element2 == null) {
            throw new ParsingException("BoxContent container not found", null, 2, null);
        }
        Element boxContent = element2;
        Map<String, Element> tables = ElementsKt.parseTablesMap(boxContent, "table.Table1, table.Table3");
        if (tables.containsKey("Error")) {
            return null;
        }
        boolean $i$f$highscores = false;
        HighscoresBuilder $this$fromContent_u24lambda_u243 = highscoresBuilder = new HighscoresBuilder();
        boolean bl = false;
        Element element3 = tables.get("Highscores Filter");
        if (element3 != null) {
            it = element = element3;
            boolean bl2 = false;
            Object object3 = boxContent.selectFirst("form");
            if (object3 == null || (object3 = ElementsKt.formData(object3)) == null) {
                throw new ParsingException("could not find highscores form", null, 2, null);
            }
            Object formData = object3;
            INSTANCE.parseHighscoresFilter($this$fromContent_u24lambda_u243, (FormData)formData);
        }
        Element element4 = (Element)MapExtensionsKt.getContaining$default(tables, "HighscoresLast", null, 2, null);
        if (element4 != null) {
            it = element = element4;
            boolean bl3 = false;
            INSTANCE.parseHighscoresTable($this$fromContent_u24lambda_u243, it);
        }
        if ((object2 = boxContent.selectFirst("span.RightArea")) == null || (object2 = ElementsKt.cleanText(object2)) == null) {
            throw new ParsingException("Could not find last update label", null, 2, null);
        }
        Object lastUpdateText = object2;
        MatchResult matchResult = Regex.find$default((Regex)numericMatch, (CharSequence)((CharSequence)lastUpdateText), (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2;
            MatchResult it2 = matchResult2 = matchResult;
            boolean bl4 = false;
            MatchGroup matchGroup = it2.getGroups().get(0);
            Intrinsics.checkNotNull((Object)matchGroup);
            int minutes = Integer.parseInt(matchGroup.getValue());
            $this$fromContent_u24lambda_u243.setLastUpdated(Clock.System.INSTANCE.now().minus-LRDsOJo(DurationKt.toDuration((int)minutes, (DurationUnit)DurationUnit.MINUTES)));
        }
        if ((object = boxContent.selectFirst("small")) == null || (object = ElementsKt.parsePagination((Element)object)) == null) {
            throw new ParsingException("could not find pagination block", null, 2, null);
        }
        Object paginationData = object;
        $this$fromContent_u24lambda_u243.setCurrentPage(((PaginationData)paginationData).getCurrentPage());
        $this$fromContent_u24lambda_u243.setTotalPages(((PaginationData)paginationData).getTotalPages());
        $this$fromContent_u24lambda_u243.setResultsCount(((PaginationData)paginationData).getResultsCount());
        return highscoresBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final void parseHighscoresFilter(HighscoresBuilder $this$parseHighscoresFilter, FormData formData) {
        Object object;
        HighscoresBuilder highscoresBuilder;
        block15: {
            Enum enum_;
            Object it$iv$iv;
            Enum[] it$iv$iv2;
            Object object2;
            boolean $i$f$fromValue;
            String value$iv$iv;
            Integer value$iv;
            IntEnum.Companion this_$iv;
            boolean $i$f$fromValue2;
            int n;
            block14: {
                Enum enum_2;
                Integer this_$iv2;
                block13: {
                    Enum[] enumArray;
                    void value$iv2;
                    $this$parseHighscoresFilter.setWorld(StringExtensionsKt.nullIfBlank(formData.getValues().get("world")));
                    IntEnum.Companion companion = IntEnum.Companion;
                    String string = formData.getValues().get("category");
                    Integer n2 = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                    highscoresBuilder = $this$parseHighscoresFilter;
                    boolean $i$f$fromValue3 = false;
                    void var7_9 = this_$iv2;
                    String value$iv$iv2 = String.valueOf(value$iv2);
                    boolean $i$f$fromValue4 = false;
                    Enum[] it$iv$iv3 = enumArray = HighscoresCategory.class;
                    boolean bl = false;
                    Object object3 = it$iv$iv3.isEnum() ? enumArray : null;
                    if (object3 != null && (object3 = (Enum[])object3.getEnumConstants()) != null) {
                        Enum[] enumArray2 = object3;
                        int n3 = enumArray2.length;
                        for (n = 0; n < n3; ++n) {
                            Enum enum_3;
                            Enum it$iv$iv4 = enum_3 = enumArray2[n];
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)((Object)it$iv$iv4)).getValue()), (Object)value$iv$iv2) || Intrinsics.areEqual((Object)it$iv$iv4.name(), (Object)value$iv$iv2))) continue;
                            enum_2 = enum_3;
                            break block13;
                        }
                        enum_2 = null;
                    } else {
                        enum_2 = null;
                    }
                }
                HighscoresCategory highscoresCategory = (HighscoresCategory)enum_2;
                if (highscoresCategory == null) {
                    throw new ParsingException("could not find category form value", null, 2, null);
                }
                highscoresBuilder.setCategory(highscoresCategory);
                IntEnum.Companion companion = IntEnum.Companion;
                String string = formData.getValues().get("beprotection");
                if (string == null) {
                    throw new ParsingException("could not find beprotection form value", null, 2, null);
                }
                this_$iv2 = Integer.parseInt(string);
                highscoresBuilder = $this$parseHighscoresFilter;
                $i$f$fromValue2 = false;
                void $i$f$fromValue3 = this_$iv;
                value$iv$iv = String.valueOf(value$iv);
                $i$f$fromValue = false;
                object2 = HighscoresBattlEyeType.class;
                it$iv$iv2 = object2;
                boolean bl = false;
                Object object4 = it$iv$iv2.isEnum() ? object2 : null;
                if (object4 != null && (object4 = (Enum[])object4.getEnumConstants()) != null) {
                    for (Enum enum_4 : object4) {
                        it$iv$iv = enum_4;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)it$iv$iv).getValue()), (Object)value$iv$iv) || Intrinsics.areEqual((Object)((Enum)it$iv$iv).name(), (Object)value$iv$iv))) continue;
                        enum_ = enum_4;
                        break block14;
                    }
                    enum_ = null;
                } else {
                    enum_ = null;
                }
            }
            highscoresBuilder.setBattlEyeType((HighscoresBattlEyeType)enum_);
            this_$iv = IntEnum.Companion;
            String string = formData.getValues().get("profession");
            value$iv = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            highscoresBuilder = $this$parseHighscoresFilter;
            $i$f$fromValue2 = false;
            IntEnum.Companion this_$iv$iv = this_$iv;
            value$iv$iv = String.valueOf(value$iv);
            $i$f$fromValue = false;
            object2 = HighscoresProfession.class;
            it$iv$iv2 = object2;
            boolean bl = false;
            Object object5 = it$iv$iv2.isEnum() ? object2 : null;
            if (object5 != null && (object5 = (Enum[])((Class)object5).getEnumConstants()) != null) {
                Object object6 = object5;
                n = ((Object)object6).length;
                for (int i = 0; i < n; ++i) {
                    Object object7;
                    it$iv$iv = object7 = object6[i];
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)it$iv$iv).getValue()), (Object)value$iv$iv) || Intrinsics.areEqual((Object)((Enum)it$iv$iv).name(), (Object)value$iv$iv))) continue;
                    object = object7;
                    break block15;
                }
                object = null;
            } else {
                object = null;
            }
        }
        highscoresBuilder.setVocation((HighscoresProfession)object);
        List list = formData.getValuesMultiple().get("worldtypes[]");
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (String pvpType : list) {
            PvpType pvpType2;
            if (PvpType.Companion.fromHighscoresFilterValue(Integer.parseInt(pvpType)) == null) continue;
            PvpType $this$parseHighscoresFilter_u24lambda_u244 = pvpType2;
            boolean bl = false;
            $this$parseHighscoresFilter.getWorldTypes().add($this$parseHighscoresFilter_u24lambda_u244);
        }
    }

    private final void parseHighscoresTable(HighscoresBuilder $this$parseHighscoresTable, Element element) {
        Element entriesTable = element.selectFirst("table.TableContent");
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(entriesTable), 1)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            List<String> columns = ElementsKt.cellsText(row);
            if (columns.size() < 6) {
                return;
            }
            int columnOffset = columns.size() == 7 ? 1 : 0;
            String loyaltyTitle = columns.size() == 7 ? columns.get(2) : null;
            $this$parseHighscoresTable.addEntry((Function1<? super HighscoresBuilder.HighscoresEntryBuilder, Unit>)((Function1)arg_0 -> HighscoresParser.parseHighscoresTable$lambda$5(columns, columnOffset, loyaltyTitle, arg_0)));
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseHighscoresTable$lambda$5(List $columns, int $columnOffset, String $loyaltyTitle, HighscoresBuilder.HighscoresEntryBuilder $this$addEntry) {
        Enum enum_;
        HighscoresBuilder.HighscoresEntryBuilder highscoresEntryBuilder;
        block4: {
            Enum[] enumArray;
            Intrinsics.checkNotNullParameter((Object)$this$addEntry, (String)"$this$addEntry");
            $this$addEntry.setRank(Integer.parseInt((String)$columns.get(0)));
            $this$addEntry.setName((String)$columns.get(1 + $columnOffset));
            StringEnum.Companion companion = StringEnum.Companion;
            String string = (String)$columns.get(2 + $columnOffset);
            highscoresEntryBuilder = $this$addEntry;
            boolean $i$f$fromValue = false;
            Enum[] it$iv = enumArray = Vocation.class;
            boolean bl = false;
            Object object = it$iv.isEnum() ? enumArray : null;
            if (object != null && (object = (Enum[])object.getEnumConstants()) != null) {
                Enum[] enumArray2 = object;
                int n = enumArray2.length;
                for (int i = 0; i < n; ++i) {
                    void value$iv;
                    Enum enum_2;
                    Enum it$iv2 = enum_2 = enumArray2[i];
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv2)).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)it$iv2.name(), (Object)value$iv))) continue;
                    enum_ = enum_2;
                    break block4;
                }
                enum_ = null;
            } else {
                enum_ = null;
            }
        }
        Vocation vocation = (Vocation)enum_;
        if (vocation == null) {
            throw new ParsingException("invalid vocation found: " + (String)$columns.get(2 + $columnOffset), null, 2, null);
        }
        highscoresEntryBuilder.setVocation(vocation);
        $this$addEntry.setWorld((String)$columns.get(3 + $columnOffset));
        $this$addEntry.setLevel(Integer.parseInt((String)$columns.get(4 + $columnOffset)));
        $this$addEntry.setValue(StringExtensionsKt.parseLong((String)$columns.get(5 + $columnOffset)));
        $this$addEntry.setAdditionalValue($loyaltyTitle);
        return Unit.INSTANCE;
    }
}

