/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.GuildsSectionBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.guild.GuildsSection;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/GuildsSectionParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/guild/GuildsSection;", "<init>", "()V", "fromContent", "content", "", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nGuildsSectionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuildsSectionParser.kt\ncom/galarzaa/tibiakt/core/parsers/GuildsSectionParser\n+ 2 GuildsSectionBuilder.kt\ncom/galarzaa/tibiakt/core/builders/GuildsSectionBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n29#2:59\n25#2:60\n1#3:61\n*S KotlinDebug\n*F\n+ 1 GuildsSectionParser.kt\ncom/galarzaa/tibiakt/core/parsers/GuildsSectionParser\n*L\n35#1:59\n35#1:60\n*E\n"})
public final class GuildsSectionParser
implements Parser<GuildsSection> {
    @NotNull
    public static final GuildsSectionParser INSTANCE = new GuildsSectionParser();

    private GuildsSectionParser() {
    }

    @Override
    @Nullable
    public GuildsSection fromContent(@NotNull String content) {
        GuildsSectionBuilder guildsSectionBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Document document = Jsoup.parse((String)content, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        Element boxContent = ElementsKt.boxContent((Element)document2);
        Elements elements = boxContent.select("table.TableContent");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements tables = elements;
        boolean $i$f$guildsSection = false;
        boolean $i$f$guildsSectionBuilder = false;
        GuildsSectionBuilder $this$fromContent_u24lambda_u241 = guildsSectionBuilder = new GuildsSectionBuilder();
        boolean bl = false;
        Element element = boxContent.selectFirst("select[name=world]");
        if (element == null || (element = element.selectFirst("option[selected]")) == null) {
            throw new ParsingException("Could not find selected world", null, 2, null);
        }
        Element selectedWorld = element;
        String string = selectedWorld.attr("value");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        $this$fromContent_u24lambda_u241.setWorld(ElementsKt.cleanText(selectedWorld));
        Iterator iterator = ((Iterable)tables).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Object t = iterator.next();
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element table = (Element)t;
            boolean isActive = index == 0;
            List list = (List)table.select("tr");
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List rows = list;
            for (Object t2 : ListExtensionsKt.offsetStart(rows, 1)) {
                CharSequence charSequence;
                Element nameContainer;
                Elements elements2;
                Intrinsics.checkNotNullExpressionValue(t2, (String)"next(...)");
                Element row = (Element)t2;
                Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
                Object e = ((List)elements2).get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"component1(...)");
                Element logoColumn = (Element)e;
                Object e2 = ((List)elements2).get(1);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"component2(...)");
                Element nameColumn = (Element)e2;
                if (nameColumn.selectFirst("b") == null) continue;
                Object object = logoColumn.selectFirst("img");
                if (object == null || (object = object.attr("src")) == null) {
                    throw new ParsingException("could not find logo URL", null, 2, null);
                }
                Object logoUrl = object;
                String name = ElementsKt.cleanText(nameContainer);
                nameContainer.remove();
                CharSequence charSequence2 = ElementsKt.cleanText(nameColumn);
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                String description = (String)charSequence;
                $this$fromContent_u24lambda_u241.addGuild(name, (String)logoUrl, description, isActive);
            }
        }
        return guildsSectionBuilder.build();
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

