/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.GuildBuilder;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.enums.Vocation;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.guild.Guild;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u00020\u000b*\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0014\u0010\u0017\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/GuildParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/guild/Guild;", "<init>", "()V", "descriptionRegex", "Lkotlin/text/Regex;", "guildHallRegex", "disbandingRegex", "fromContent", "content", "", "parseGuildMembers", "", "Lcom/galarzaa/tibiakt/core/builders/GuildBuilder;", "parsedContent", "Lorg/jsoup/nodes/Element;", "parseInviteRow", "columns", "Lorg/jsoup/select/Elements;", "parseMemberRow", "", "currentRank", "parseGuildInformation", "container", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nGuildParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuildParser.kt\ncom/galarzaa/tibiakt/core/parsers/GuildParser\n+ 2 GuildBuilder.kt\ncom/galarzaa/tibiakt/core/builders/GuildBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n*L\n1#1,125:1\n31#2:126\n28#2:127\n1#3:128\n1#3:134\n1557#4:129\n1628#4,3:130\n33#5:133\n*S KotlinDebug\n*F\n+ 1 GuildParser.kt\ncom/galarzaa/tibiakt/core/parsers/GuildParser\n*L\n51#1:126\n51#1:127\n96#1:134\n80#1:129\n80#1:130,3\n96#1:133\n*E\n"})
public final class GuildParser
implements Parser<Guild> {
    @NotNull
    public static final GuildParser INSTANCE = new GuildParser();
    @NotNull
    private static final Regex descriptionRegex;
    @NotNull
    private static final Regex guildHallRegex;
    @NotNull
    private static final Regex disbandingRegex;

    private GuildParser() {
    }

    @Override
    @Nullable
    public Guild fromContent(@NotNull String content) {
        GuildBuilder guildBuilder;
        block9: {
            Element guildImg;
            Element element;
            Map<String, Element> tables;
            GuildBuilder $this$fromContent_u24lambda_u243;
            Element boxContent;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    Document document = Jsoup.parse((String)content);
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
                    Document document2 = document;
                    boxContent = ElementsKt.boxContent((Element)document2);
                    boolean $i$f$guild = false;
                    boolean $i$f$guildBuilder = false;
                    $this$fromContent_u24lambda_u243 = guildBuilder = new GuildBuilder();
                    boolean bl = false;
                    tables = ElementsKt.parseTablesMap(boxContent, "table.Table1, table.Table3");
                    if (tables.containsKey("Error")) {
                        return null;
                    }
                    Element element2 = tables.get("Guild Information");
                    if (element2 == null) break block7;
                    Element $this$fromContent_u24lambda_u243_u24lambda_u240 = element = element2;
                    boolean bl2 = false;
                    INSTANCE.parseGuildInformation($this$fromContent_u24lambda_u243, $this$fromContent_u24lambda_u243_u24lambda_u240);
                    element2 = element;
                    if (element2 != null) break block8;
                }
                throw new ParsingException("Guild Information container not found", null, 2, null);
            }
            Object object = boxContent.selectFirst("h1");
            if (object == null || (object = object.text()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                throw new ParsingException("Guild title not found", null, 2, null);
            }
            $this$fromContent_u24lambda_u243.setName((String)object);
            Element element3 = guildImg = boxContent.selectFirst("img[width=64]");
            $this$fromContent_u24lambda_u243.setLogoUrl(element3 != null ? element3.attr("src") : null);
            Element element4 = tables.get("Guild Members");
            if (element4 != null) {
                Element $this$fromContent_u24lambda_u243_u24lambda_u241 = element = element4;
                boolean bl = false;
                INSTANCE.parseGuildMembers($this$fromContent_u24lambda_u243, $this$fromContent_u24lambda_u243_u24lambda_u241);
            }
            Element element5 = tables.get("Invited Characters");
            if (element5 == null) break block9;
            Element $this$fromContent_u24lambda_u243_u24lambda_u242 = element = element5;
            boolean bl = false;
            INSTANCE.parseGuildMembers($this$fromContent_u24lambda_u243, $this$fromContent_u24lambda_u243_u24lambda_u242);
        }
        return guildBuilder.build();
    }

    private final void parseGuildMembers(GuildBuilder $this$parseGuildMembers, Element parsedContent) {
        Elements elements = parsedContent.select("tr[bgcolor]");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements rows = elements;
        String currentRank = "";
        Iterator iterator = rows.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Elements columns;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element row = (Element)e;
            Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
            switch (columns.size()) {
                case 6: {
                    currentRank = this.parseMemberRow($this$parseGuildMembers, (List)columns, currentRank);
                    break;
                }
                case 2: {
                    this.parseInviteRow($this$parseGuildMembers, columns);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseInviteRow(GuildBuilder $this$parseInviteRow, Elements columns) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)columns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            collection.add(StringExtensionsKt.clean(string));
        }
        List list = (List)destination$iv$iv;
        String name = (String)list.get(0);
        String date = (String)list.get(1);
        if (StringsKt.contains$default((CharSequence)date, (CharSequence)"Invitation Date", (boolean)false, (int)2, null)) {
            return;
        }
        $this$parseInviteRow.addInvite(name, DatesKt.parseTibiaDate(date));
    }

    private final String parseMemberRow(GuildBuilder $this$parseMemberRow, List<? extends Element> columns, String currentRank) {
        Ref.ObjectRef rank = new Ref.ObjectRef();
        String string = columns.get(0).text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        rank.element = StringExtensionsKt.clean(string);
        if (StringsKt.isBlank((CharSequence)((CharSequence)rank.element))) {
            rank.element = currentRank;
        }
        Element element = columns.get(1).selectFirst("a");
        if (element == null) {
            return currentRank;
        }
        Element nameLink = element;
        Node titleNode = nameLink.nextSibling();
        $this$parseMemberRow.addMember((Function1<? super GuildBuilder.GuildMemberBuilder, Unit>)((Function1)arg_0 -> GuildParser.parseMemberRow$lambda$5(rank, nameLink, titleNode, columns, arg_0)));
        return (String)rank.element;
    }

    private final void parseGuildInformation(GuildBuilder $this$parseGuildInformation, Element container) {
        block3: {
            MatchResult matchResult;
            String containerText = ElementsKt.wholeCleanText(container);
            MatchResult matchResult2 = Regex.find$default((Regex)descriptionRegex, (CharSequence)containerText, (int)0, (int)2, null);
            if (matchResult2 != null) {
                MatchResult $this$parseGuildInformation_u24lambda_u246 = matchResult = matchResult2;
                boolean bl = false;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseGuildInformation_u24lambda_u246.getGroups(), (String)"description");
                $this$parseGuildInformation.setDescription(StringExtensionsKt.nullIfBlank(object != null && (object = object.getValue()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null));
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseGuildInformation_u24lambda_u246.getGroups(), (String)"date");
                Intrinsics.checkNotNull((Object)matchGroup);
                $this$parseGuildInformation.setFoundingDate(DatesKt.parseTibiaDate(matchGroup.getValue()));
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseGuildInformation_u24lambda_u246.getGroups(), (String)"world");
                Intrinsics.checkNotNull((Object)matchGroup2);
                $this$parseGuildInformation.setWorld(matchGroup2.getValue());
            }
            $this$parseGuildInformation.setHasOpenApplications(StringsKt.contains$default((CharSequence)containerText, (CharSequence)"opened for applications", (boolean)false, (int)2, null));
            $this$parseGuildInformation.setActive(StringsKt.contains((CharSequence)containerText, (CharSequence)"it is currently active", (boolean)true));
            Element element = container.selectFirst("a");
            if (element != null) {
                MatchResult $this$parseGuildInformation_u24lambda_u247 = matchResult = element;
                boolean bl = false;
                $this$parseGuildInformation.setHomepage($this$parseGuildInformation_u24lambda_u247.text());
            }
            MatchResult matchResult3 = Regex.find$default((Regex)guildHallRegex, (CharSequence)containerText, (int)0, (int)2, null);
            if (matchResult3 != null) {
                MatchResult $this$parseGuildInformation_u24lambda_u248 = matchResult = matchResult3;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseGuildInformation_u24lambda_u248.getGroups(), (String)"name");
                Intrinsics.checkNotNull((Object)matchGroup);
                String string = matchGroup.getValue();
                MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseGuildInformation_u24lambda_u248.getGroups(), (String)"paidUntil");
                Intrinsics.checkNotNull((Object)matchGroup3);
                $this$parseGuildInformation.guildHall(string, DatesKt.parseTibiaDate(matchGroup3.getValue()));
            }
            MatchResult matchResult4 = Regex.find$default((Regex)disbandingRegex, (CharSequence)containerText, (int)0, (int)2, null);
            if (matchResult4 == null) break block3;
            MatchResult $this$parseGuildInformation_u24lambda_u249 = matchResult = matchResult4;
            boolean bl = false;
            List list = $this$parseGuildInformation_u24lambda_u249.getGroupValues();
            String date = (String)list.get(1);
            String reason = (String)list.get(2);
            $this$parseGuildInformation.setDisbandingDate(DatesKt.parseTibiaDate(date));
            $this$parseGuildInformation.setDisbandingReason(reason);
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseMemberRow$lambda$5(Ref.ObjectRef $rank, Element $nameLink, Node $titleNode, List $columns, GuildBuilder.GuildMemberBuilder $this$addMember) {
        Enum enum_;
        GuildBuilder.GuildMemberBuilder guildMemberBuilder;
        block4: {
            Enum[] enumArray;
            Intrinsics.checkNotNullParameter((Object)$this$addMember, (String)"$this$addMember");
            $this$addMember.setRank((String)$rank.element);
            String string = $nameLink.text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            $this$addMember.setName(StringExtensionsKt.clean(string));
            Object object = $titleNode instanceof TextNode ? (TextNode)$titleNode : null;
            $this$addMember.setTitle(object != null && (object = object.text()) != null && (object = StringExtensionsKt.remove$default((String)object, "(", false, 2, null)) != null && (object = StringExtensionsKt.remove$default((String)object, ")", false, 2, null)) != null ? StringExtensionsKt.clean((String)object) : null);
            StringEnum.Companion companion = StringEnum.Companion;
            String string2 = ((Element)$columns.get(2)).text();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
            String string3 = StringExtensionsKt.clean(string2);
            guildMemberBuilder = $this$addMember;
            boolean $i$f$fromValue = false;
            Enum[] it$iv = enumArray = Vocation.class;
            boolean bl = false;
            Object object2 = it$iv.isEnum() ? enumArray : null;
            if (object2 != null && (object2 = (Enum[])object2.getEnumConstants()) != null) {
                Enum[] enumArray2 = object2;
                int n = enumArray2.length;
                for (int i = 0; i < n; ++i) {
                    void value$iv;
                    Enum enum_2;
                    Enum it$iv2 = enum_2 = enumArray2[i];
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv2)).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)it$iv2.name(), (Object)value$iv))) continue;
                    enum_ = enum_2;
                    break block4;
                }
                enum_ = null;
            } else {
                enum_ = null;
            }
        }
        Vocation vocation = (Vocation)enum_;
        if (vocation == null) {
            StringBuilder stringBuilder = new StringBuilder().append("unknown vocation in member: ");
            String string = ((Element)$columns.get(2)).text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            throw new ParsingException(stringBuilder.append(StringExtensionsKt.clean(string)).toString(), null, 2, null);
        }
        guildMemberBuilder.setVocation(vocation);
        String string = ((Element)$columns.get(3)).text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        $this$addMember.setLevel(Integer.parseInt(string));
        String string4 = ((Element)$columns.get(4)).text();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"text(...)");
        $this$addMember.setJoiningDate(DatesKt.parseTibiaDate(StringExtensionsKt.clean(string4)));
        String string5 = ((Element)$columns.get(5)).text();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text(...)");
        $this$addMember.setOnline(StringsKt.contains$default((CharSequence)string5, (CharSequence)"online", (boolean)false, (int)2, null));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        descriptionRegex = new Regex("(?<description>.*)?The guild was founded on (?<world>\\w+) on (?<date>[^.]+)\\.", SetsKt.setOf((Object[])objectArray));
        guildHallRegex = new Regex("Their home on (?<world>\\w+) is (?<name>[^.]+)\\. The rent is paid until (?<paidUntil>[^.]+)");
        disbandingRegex = new Regex("It will be disbanded on (\\w+\\s\\d+\\s\\d+)\\s([^.]+).");
    }
}

