/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.ForumThreadBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.forums.ForumEmoticon;
import com.galarzaa.tibiakt.core.models.forums.ForumThread;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.ForumsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/ForumThreadParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/forums/ForumThread;", "<init>", "()V", "SIGNATURE_SEPARATOR", "", "datesRegex", "Lkotlin/text/Regex;", "editedByRegex", "fromContent", "content", "parsePostContainer", "", "Lcom/galarzaa/tibiakt/core/builders/ForumThreadBuilder;", "container", "Lorg/jsoup/nodes/Element;", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nForumThreadParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForumThreadParser.kt\ncom/galarzaa/tibiakt/core/parsers/ForumThreadParser\n+ 2 ForumThreadBuilder.kt\ncom/galarzaa/tibiakt/core/builders/ForumThreadBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n32#2:149\n29#2:150\n1611#3,9:151\n1863#3:160\n1864#3:162\n1620#3:163\n1611#3,9:164\n1863#3:173\n1864#3:175\n1620#3:176\n1#4:161\n1#4:174\n*S KotlinDebug\n*F\n+ 1 ForumThreadParser.kt\ncom/galarzaa/tibiakt/core/parsers/ForumThreadParser\n*L\n41#1:149\n41#1:150\n50#1:151,9\n50#1:160\n50#1:162\n50#1:163\n77#1:164,9\n77#1:173\n77#1:175\n77#1:176\n50#1:161\n77#1:174\n*E\n"})
public final class ForumThreadParser
implements Parser<ForumThread> {
    @NotNull
    public static final ForumThreadParser INSTANCE = new ForumThreadParser();
    @NotNull
    private static final String SIGNATURE_SEPARATOR = "________________";
    @NotNull
    private static final Regex datesRegex = new Regex("(\\d{2}\\.\\d{2}\\.\\d{4}\\s\\d{2}:\\d{2}:\\d{2})");
    @NotNull
    private static final Regex editedByRegex = new Regex("Edited by (.*) on \\d{2}");

    private ForumThreadParser() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ForumThread fromContent(@NotNull String content) {
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Elements breadCrumbs;
        ForumThreadBuilder $this$fromContent_u24lambda_u242;
        ForumThreadBuilder forumThreadBuilder;
        Element boxContent;
        block20: {
            block22: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
                    boolean $i$f$forumThread = false;
                    boolean $i$f$forumThreadBuilder = false;
                    $this$fromContent_u24lambda_u242 = forumThreadBuilder = new ForumThreadBuilder();
                    boolean bl = false;
                    Elements elements = boxContent.select("div.ForumBreadCrumbs > a");
                    Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
                    breadCrumbs = elements;
                    if (!breadCrumbs.isEmpty()) break block20;
                    Element messageBox = boxContent.selectFirst("div.InnerTableContainer");
                    if (messageBox == null) break block21;
                    String string = messageBox.text();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"not found", (boolean)false, (int)2, null)) break block22;
                }
                throw new ParsingException("Could not find Forum Breadcrumbs", null, 2, null);
            }
            return null;
        }
        Iterable $this$mapNotNull$iv = (Iterable)breadCrumbs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LinkInformation it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (ElementsKt.getLinkInformation(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        LinkInformation sectionLink = (LinkInformation)list.get(0);
        LinkInformation boardLink = (LinkInformation)list.get(1);
        List<String> list2 = sectionLink.getQueryParams().get("sectionid");
        if (list2 == null || (list2 = (String)CollectionsKt.first(list2)) == null) {
            throw new ParsingException("Could not find section ID in link.", null, 2, null);
        }
        $this$fromContent_u24lambda_u242.setSectionId(Integer.parseInt((String)((Object)list2)));
        $this$fromContent_u24lambda_u242.setSection(sectionLink.getTitle());
        List<String> list3 = boardLink.getQueryParams().get("boardid");
        if (list3 == null || (list3 = (String)CollectionsKt.first(list3)) == null) {
            throw new ParsingException("Could not find board ID in link.", null, 2, null);
        }
        $this$fromContent_u24lambda_u242.setBoardId(Integer.parseInt((String)((Object)list3)));
        $this$fromContent_u24lambda_u242.setBoard(boardLink.getTitle());
        Element forumTitleContainer = boxContent.selectFirst("div.ForumTitleText");
        if (forumTitleContainer == null) {
            Object object = boxContent.selectFirst("div.ForumBreadCrumbs > b");
            if (object == null || (object = object.text()) == null) {
                throw new ParsingException("Could not find partial title", null, 2, null);
            }
            $this$fromContent_u24lambda_u242.setTitle((String)object);
            $this$fromContent_u24lambda_u242.setThreadId(0);
            $this$fromContent_u24lambda_u242.setCurrentPage(-1);
        } else {
            void $this$mapNotNullTo$iv$iv2;
            Element element = forumTitleContainer.parent();
            Intrinsics.checkNotNull((Object)element);
            Node node = element.previousSibling();
            Intrinsics.checkNotNull((Object)node);
            Node node2 = node.previousSibling();
            Intrinsics.checkNotNull((Object)node2);
            Node border = node2;
            String string = border.attr("style");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            $this$fromContent_u24lambda_u242.setHasGoldenFrame(StringsKt.contains$default((CharSequence)string, (CharSequence)"gold", (boolean)false, (int)2, null));
            $this$fromContent_u24lambda_u242.setTitle(ElementsKt.cleanText(forumTitleContainer));
            Element element2 = boxContent.selectFirst("table.TableContent");
            Intrinsics.checkNotNull((Object)element2);
            Element postTable = element2;
            Element element3 = postTable.selectFirst("div.ForumPostHeaderText");
            Intrinsics.checkNotNull((Object)element3);
            Element threadInfoContainer = element3;
            List list4 = threadInfoContainer.childNodes();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"childNodes(...)");
            List list5 = list4;
            Object e = list5.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"component1(...)");
            Node threadNumber = (Node)e;
            Object e2 = list5.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"component2(...)");
            Node navigationContainer = (Node)e2;
            Intrinsics.checkNotNull((Object)threadNumber, (String)"null cannot be cast to non-null type org.jsoup.nodes.TextNode");
            element$iv$iv = new String[]{"#"};
            $this$fromContent_u24lambda_u242.setThreadId(Integer.parseInt((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)ElementsKt.cleanText((TextNode)threadNumber), element$iv$iv, (boolean)false, (int)0, (int)6, null))));
            Intrinsics.checkNotNull((Object)navigationContainer, (String)"null cannot be cast to non-null type org.jsoup.nodes.Element");
            Elements elements = ((Element)navigationContainer).select("a");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Iterable $this$mapNotNull$iv2 = (Iterable)elements;
            boolean $i$f$mapNotNull2 = false;
            Iterable bl2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                LinkInformation it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it);
                if (ElementsKt.getLinkInformation(it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List navigationLinks = (List)destination$iv$iv2;
            if (navigationLinks.size() == 2) {
                LinkInformation prevLink = (LinkInformation)navigationLinks.get(0);
                LinkInformation nextLink = (LinkInformation)navigationLinks.get(1);
                List<String> list6 = prevLink.getQueryParams().get("threadid");
                if (list6 == null || (list6 = (String)CollectionsKt.first(list6)) == null) {
                    throw new ParsingException("Could not find previous topic number in link.", null, 2, null);
                }
                $this$fromContent_u24lambda_u242.setPreviousTopicNumber(Integer.parseInt((String)((Object)list6)));
                List<String> list7 = nextLink.getQueryParams().get("threadid");
                if (list7 == null || (list7 = (String)CollectionsKt.first(list7)) == null) {
                    throw new ParsingException("Could not find next topic number in link.", null, 2, null);
                }
                $this$fromContent_u24lambda_u242.setNextTopicNumber(Integer.parseInt((String)((Object)list7)));
            } else if (StringsKt.contains$default((CharSequence)((LinkInformation)CollectionsKt.first((List)navigationLinks)).getTitle(), (CharSequence)"Previous", (boolean)false, (int)2, null)) {
                List<String> list8 = ((LinkInformation)CollectionsKt.first((List)navigationLinks)).getQueryParams().get("threadid");
                if (list8 == null || (list8 = (String)CollectionsKt.first(list8)) == null) {
                    throw new ParsingException("Could not find previous topic number in link.", null, 2, null);
                }
                $this$fromContent_u24lambda_u242.setPreviousTopicNumber(Integer.parseInt((String)((Object)list8)));
            } else {
                List<String> list9 = ((LinkInformation)CollectionsKt.first((List)navigationLinks)).getQueryParams().get("threadid");
                if (list9 == null || (list9 = (String)CollectionsKt.first(list9)) == null) {
                    throw new ParsingException("Could not find next topic number in link.", null, 2, null);
                }
                $this$fromContent_u24lambda_u242.setNextTopicNumber(Integer.parseInt((String)((Object)list9)));
            }
            Element element4 = boxContent.selectFirst("td.PageNavigation");
            Intrinsics.checkNotNull((Object)element4);
            PaginationData paginationData = ElementsKt.parsePagination(element4);
            $this$fromContent_u24lambda_u242.setTotalPages(paginationData.getTotalPages());
            $this$fromContent_u24lambda_u242.setCurrentPage(paginationData.getCurrentPage());
            $this$fromContent_u24lambda_u242.setResultsCount(paginationData.getResultsCount());
            Elements elements2 = postTable.select("div.PostBody");
            Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
            Elements postContainers = elements2;
            Iterator iterator3 = postContainers.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"iterator(...)");
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Object e3 = iterator4.next();
                Intrinsics.checkNotNullExpressionValue(e3, (String)"next(...)");
                Element postContainer = (Element)e3;
                INSTANCE.parsePostContainer($this$fromContent_u24lambda_u242, postContainer);
            }
        }
        return forumThreadBuilder.build();
    }

    private final void parsePostContainer(ForumThreadBuilder $this$parsePostContainer, Element container) {
        $this$parsePostContainer.addPost((Function1<? super ForumThreadBuilder.ForumPostBuilder, Unit>)((Function1)arg_0 -> ForumThreadParser.parsePostContainer$lambda$6(container, arg_0)));
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final String parsePostContainer$lambda$6$lambda$5(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final Unit parsePostContainer$lambda$6(Element $container, ForumThreadBuilder.ForumPostBuilder $this$addPost) {
        Element it;
        Intrinsics.checkNotNullParameter((Object)$this$addPost, (String)"$this$addPost");
        Element element = $container.selectFirst("div.PostCharacterText");
        Intrinsics.checkNotNull((Object)element);
        $this$addPost.setAuthor(ForumsKt.parseAuthorTable(element));
        Element element2 = $container.selectFirst("div.PostText");
        Intrinsics.checkNotNull((Object)element2);
        Element contentContainer = element2;
        Element emoticonTag = null;
        Element titleTag = null;
        block5: while (true) {
            Element child;
            block13: {
                Intrinsics.checkNotNullExpressionValue((Object)contentContainer.child(0), (String)"child(...)");
                child.remove();
                String string = child.tagName();
                switch (string.hashCode()) {
                    case 99473: {
                        if (string.equals("div")) break block5;
                        continue block5;
                    }
                    case 104387: {
                        if (string.equals("img")) break;
                        continue block5;
                    }
                    case 98: {
                        if (!string.equals("b")) {
                            continue block5;
                        }
                        break block13;
                    }
                }
                emoticonTag = child;
                continue;
            }
            titleTag = child;
        }
        Element element3 = contentContainer.selectFirst("br");
        if (element3 != null) {
            element3.remove();
        }
        Element signatureContainer = $container.selectFirst("td.ff_pagetext");
        if (signatureContainer != null) {
            $this$addPost.setSignature(signatureContainer.html());
            signatureContainer.remove();
        }
        $this$addPost.setContent(contentContainer.html());
        if (signatureContainer != null) {
            String string = $this$addPost.getContent();
            Intrinsics.checkNotNull((Object)string);
            String[] stringArray = new String[]{SIGNATURE_SEPARATOR};
            List parts = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            $this$addPost.setContent(CollectionsKt.joinToString$default((Iterable)parts.subList(0, parts.size() - 1), (CharSequence)SIGNATURE_SEPARATOR, null, null, (int)0, null, null, (int)62, null));
        }
        Element element4 = emoticonTag;
        if (element4 != null) {
            it = element4;
            boolean bl = false;
            String string = it.attr("alt");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            String string2 = it.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attr(...)");
            $this$addPost.setEmoticon(new ForumEmoticon(string, string2));
        }
        Element element5 = titleTag;
        if (element5 != null) {
            it = element5;
            boolean bl = false;
            $this$addPost.setTitle(ElementsKt.cleanText(it));
        }
        Element element6 = $container.selectFirst("div.PostDetails");
        Intrinsics.checkNotNull((Object)element6);
        Element postDetails = element6;
        String string = postDetails.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        List dates = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)datesRegex, (CharSequence)string, (int)0, (int)2, null), ForumThreadParser::parsePostContainer$lambda$6$lambda$5));
        $this$addPost.setPostedDate(DatesKt.parseTibiaForumDateTime((String)CollectionsKt.first((List)dates)));
        if (dates.size() > 1) {
            $this$addPost.setEditedDate(DatesKt.parseTibiaForumDateTime((String)dates.get(1)));
            String string3 = postDetails.text();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text(...)");
            MatchResult matchResult = Regex.find$default((Regex)editedByRegex, (CharSequence)string3, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            $this$addPost.setEditedBy((String)matchResult.getGroupValues().get(1));
        }
        Element element7 = $container.selectFirst("div.AdditionalBox");
        Intrinsics.checkNotNull((Object)element7);
        Element additionalBox = element7;
        String[] stringArray = new String[]{"#"};
        $this$addPost.setPostId(Integer.parseInt((String)StringsKt.split$default((CharSequence)ElementsKt.cleanText(additionalBox), (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(1)));
        return Unit.INSTANCE;
    }
}

