/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.ForumBoardBuilder;
import com.galarzaa.tibiakt.core.enums.ThreadStatus;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.forums.ForumBoard;
import com.galarzaa.tibiakt.core.models.forums.ForumEmoticon;
import com.galarzaa.tibiakt.core.models.forums.LastPost;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.ForumsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/ForumBoardParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/forums/ForumBoard;", "<init>", "()V", "fileNameRegex", "Lkotlin/text/Regex;", "fromContent", "content", "", "parseThreadsTable", "", "Lcom/galarzaa/tibiakt/core/builders/ForumBoardBuilder;", "table", "Lorg/jsoup/nodes/Element;", "parseAnnouncements", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nForumBoardParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForumBoardParser.kt\ncom/galarzaa/tibiakt/core/parsers/ForumBoardParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ForumBoardBuilder.kt\ncom/galarzaa/tibiakt/core/builders/ForumBoardBuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,122:1\n1#2:123\n1#2:140\n1#2:153\n31#3:124\n29#3:125\n1557#4:126\n1628#4,3:127\n1611#4,9:130\n1863#4:139\n1864#4:141\n1620#4:142\n1611#4,9:143\n1863#4:152\n1864#4:154\n1620#4:155\n1863#4,2:159\n3829#5:156\n4344#5,2:157\n*S KotlinDebug\n*F\n+ 1 ForumBoardParser.kt\ncom/galarzaa/tibiakt/core/parsers/ForumBoardParser\n*L\n113#1:140\n77#1:153\n48#1:124\n48#1:125\n50#1:126\n50#1:127,3\n113#1:130,9\n113#1:139\n113#1:141\n113#1:142\n77#1:143,9\n77#1:152\n77#1:154\n77#1:155\n102#1:159,2\n102#1:156\n102#1:157,2\n*E\n"})
public final class ForumBoardParser
implements Parser<ForumBoard> {
    @NotNull
    public static final ForumBoardParser INSTANCE = new ForumBoardParser();
    @NotNull
    private static final Regex fileNameRegex = new Regex("(\\w+.gif)");

    private ForumBoardParser() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ForumBoard fromContent(@NotNull String content) {
        void $this$mapTo$iv$iv;
        ForumBoardBuilder forumBoardBuilder;
        Element forumBreadcrumbs;
        Element boxContent;
        block10: {
            block12: {
                block11: {
                    Element element;
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    boxContent = this.boxContent(content, org.jsoup.parser.Parser.xmlParser());
                    forumBreadcrumbs = boxContent.selectFirst("div.ForumBreadCrumbs");
                    if (forumBreadcrumbs != null) break block10;
                    Object object = boxContent.selectFirst("div.InnerTableContainer");
                    if (object == null) break block11;
                    Element it = element = object;
                    boolean bl = false;
                    object = StringsKt.contains$default((CharSequence)ElementsKt.cleanText(it), (CharSequence)"board you requested", (boolean)false, (int)2, null) ? element : null;
                    if (object != null) break block12;
                }
                throw new ParsingException("content does not belong to a board.", null, 2, null);
            }
            return null;
        }
        boolean $i$f$forumBoard = false;
        boolean $i$f$forumBoardBuilder = false;
        ForumBoardBuilder $this$fromContent_u24lambda_u242 = forumBoardBuilder = new ForumBoardBuilder();
        boolean bl = false;
        String headerText = ElementsKt.cleanText(forumBreadcrumbs);
        String[] stringArray = new String[]{"|"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)headerText, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List headerParts = (List)destination$iv$iv;
        $this$fromContent_u24lambda_u242.setName((String)CollectionsKt.last((List)headerParts));
        $this$fromContent_u24lambda_u242.setSection((String)CollectionsKt.first((List)headerParts));
        Object object = forumBreadcrumbs.selectFirst("a");
        if (object == null || (object = ElementsKt.getLinkInformation((Element)object)) == null || (object = ((LinkInformation)object).getQueryParams()) == null || (object = (List)((HashMap)object).get("sectionid")) == null || (object = (String)CollectionsKt.first((List)object)) == null) {
            throw new ParsingException("sectionId not found", null, 2, null);
        }
        $this$fromContent_u24lambda_u242.setSectionId(Integer.parseInt((String)object));
        Object object2 = boxContent.selectFirst("form");
        if (object2 == null || (object2 = ElementsKt.formData((Element)object2)) == null) {
            throw new ParsingException("form not found", null, 2, null);
        }
        Object form = object2;
        String string = ((FormData)form).getValues().get("boardid");
        $this$fromContent_u24lambda_u242.setBoardId(string != null ? Integer.valueOf(Integer.parseInt(string)) : null);
        String string2 = ((FormData)form).getValues().get("threadage");
        if (string2 == null) {
        } else {
            $this$fromContent_u24lambda_u242.setThreadAge(Integer.parseInt(string2));
            Element element = boxContent.selectFirst("table.Table3");
            if (element == null) {
                throw new ParsingException("No board tables found.", null, 2, null);
            }
            Element table = element;
            Elements elements = table.select("table.TableContent");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Elements contentTables = elements;
            if (contentTables.size() >= 2) {
                Element element2 = contentTables.first();
                Intrinsics.checkNotNull((Object)element2);
                INSTANCE.parseAnnouncements($this$fromContent_u24lambda_u242, element2);
            }
            Element element3 = contentTables.last();
            Intrinsics.checkNotNull((Object)element3);
            INSTANCE.parseThreadsTable($this$fromContent_u24lambda_u242, element3);
            Element element4 = boxContent.selectFirst("td > small");
            Intrinsics.checkNotNull((Object)element4);
            PaginationData paginationData = ElementsKt.parsePagination(element4);
            $this$fromContent_u24lambda_u242.setCurrentPage(paginationData.getCurrentPage());
            $this$fromContent_u24lambda_u242.setTotalPages(paginationData.getTotalPages());
            $this$fromContent_u24lambda_u242.setResultsCount(paginationData.getResultsCount());
        }
        return forumBoardBuilder.build();
    }

    private final void parseThreadsTable(ForumBoardBuilder $this$parseThreadsTable, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table), 1)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            Elements columns = ElementsKt.cells(row);
            if (columns.size() < 6) continue;
            $this$parseThreadsTable.thread((Function1<? super ForumBoardBuilder.ThreadEntryBuilder, Unit>)((Function1)arg_0 -> ForumBoardParser.parseThreadsTable$lambda$10(columns, row, arg_0)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseAnnouncements(ForumBoardBuilder $this$parseAnnouncements, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table), 1)) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            Elements elements = row.select("a");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Iterable $this$mapNotNull$iv = (Iterable)elements;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LinkInformation it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (ElementsKt.getLinkInformation(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            LinkInformation authorLink = (LinkInformation)list.get(0);
            LinkInformation titleLink = (LinkInformation)list.get(1);
            $this$parseAnnouncements.announcement((Function1<? super ForumBoardBuilder.AnnouncementEntryBuilder, Unit>)((Function1)arg_0 -> ForumBoardParser.parseAnnouncements$lambda$12(titleLink, authorLink, arg_0)));
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseThreadsTable$lambda$10(Elements $columns, Element $row, ForumBoardBuilder.ThreadEntryBuilder $this$thread) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        String string;
        String string2;
        ThreadStatus[] it;
        Object object;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$thread, (String)"$this$thread");
        Elements elements = ((Element)$columns.get(2)).select("a");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$mapNotNull$iv = (Iterable)elements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        HashMap<String, List<String>> hashMap = $this$forEach$iv$iv$iv.iterator();
        while (hashMap.hasNext()) {
            LinkInformation it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = hashMap.next();
            boolean bl = false;
            Element it2 = (Element)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            if (ElementsKt.getLinkInformation(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it3 = (List)destination$iv$iv;
        boolean bl = false;
        Pair pair = TuplesKt.to((Object)CollectionsKt.first((List)it3), (Object)CollectionsKt.drop((Iterable)it3, (int)1));
        LinkInformation threadLink = (LinkInformation)pair.component1();
        List pageLinks = (List)pair.component2();
        Object object2 = $columns.get(3);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String authorName = ElementsKt.cleanText((Element)object2);
        Element element = ((Element)$columns.get(1)).selectFirst("img");
        if (element != null) {
            Element it4 = $i$f$mapNotNullTo = element;
            boolean bl4 = false;
            String string3 = it4.attr("alt");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"attr(...)");
            String string4 = it4.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attr(...)");
            $this$thread.setEmoticon(new ForumEmoticon(string3, string4));
        }
        boolean isTraded = false;
        if (StringsKt.contains$default((CharSequence)authorName, (CharSequence)"(traded)", (boolean)false, (int)2, null)) {
            authorName = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)authorName, (String)"(traded)", (String)"", (boolean)false, (int)4, null))).toString();
            isTraded = true;
        } else {
            isTraded = false;
        }
        if ((object = ((Element)$columns.get(0)).selectFirst("img")) != null && (object = object.attr("src")) != null) {
            it = object;
            boolean bl5 = false;
            Object object3 = Regex.find$default((Regex)fileNameRegex, (CharSequence)((CharSequence)it), (int)0, (int)2, null);
            string2 = object3 != null && (object3 = object3.getGroupValues()) != null ? (String)object3.get(1) : null;
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        String statusImageFileName = string;
        Element authorLink = ((Element)$columns.get(3)).selectFirst("a");
        $this$thread.setTitle(threadLink.getTitle());
        List<String> list = threadLink.getQueryParams().get("threadid");
        $this$thread.setThreadId(list != null && (list = list.get(0)) != null ? Integer.valueOf(Integer.parseInt((String)((Object)list))) : null);
        hashMap = pageLinks;
        it = hashMap;
        ForumBoardBuilder.ThreadEntryBuilder threadEntryBuilder = $this$thread;
        boolean bl6 = false;
        boolean bl7 = !((Collection)it).isEmpty();
        HashMap<String, List<String>> hashMap2 = bl7 ? hashMap : null;
        threadEntryBuilder.setPages(hashMap2 != null && (hashMap2 = (LinkInformation)CollectionsKt.last((List)((Object)hashMap2))) != null && (hashMap2 = ((LinkInformation)((Object)hashMap2)).getQueryParams()) != null && (hashMap2 = hashMap2.get("pagenumber")) != null && (hashMap2 = (String)hashMap2.get(0)) != null ? Integer.parseInt((String)((Object)hashMap2)) : 1);
        $this$thread.setAuthor(authorName);
        $this$thread.setAuthorTraded(isTraded);
        $this$thread.setAuthorDeleted(authorLink == null && !isTraded);
        Object $this$filter$iv = ThreadStatus.values();
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int it2 = 0; it2 < n; ++it2) {
            void element$iv$iv;
            void it5 = element$iv$iv = $this$filterTo$iv$iv[it2];
            boolean bl8 = false;
            CharSequence charSequence = statusImageFileName;
            String string5 = it5.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string5, (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            ThreadStatus it6 = (ThreadStatus)((Object)element$iv);
            boolean bl9 = false;
            $this$thread.getStatus().add(it6);
        }
        Object object4 = $columns.get(6);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        LastPost lastPost = ForumsKt.parseLastPostFromCell((Element)object4);
        if (lastPost == null) {
            throw new ParsingException("last post not found", null, 2, null);
        }
        $this$thread.setLastPost(lastPost);
        String string6 = ((Element)$columns.get(4)).text();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"text(...)");
        $this$thread.setReplies(Integer.parseInt(StringExtensionsKt.remove$default(string6, ",", false, 2, null)));
        String string7 = ((Element)$columns.get(5)).text();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"text(...)");
        $this$thread.setViews(Integer.parseInt(StringExtensionsKt.remove$default(string7, ",", false, 2, null)));
        String string8 = $row.attr("class");
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attr(...)");
        $this$thread.setHasGoldenFrame(StringsKt.contains$default((CharSequence)string8, (CharSequence)"ClassifiedProposal", (boolean)false, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit parseAnnouncements$lambda$12(LinkInformation $titleLink, LinkInformation $authorLink, ForumBoardBuilder.AnnouncementEntryBuilder $this$announcement) {
        Intrinsics.checkNotNullParameter((Object)$this$announcement, (String)"$this$announcement");
        $this$announcement.setTitle($titleLink.getTitle());
        $this$announcement.setAuthor($authorLink.getTitle());
        List<String> list = $titleLink.getQueryParams().get("announcementid");
        $this$announcement.setAnnouncementId(list != null && (list = (String)CollectionsKt.first(list)) != null ? Integer.valueOf(Integer.parseInt((String)((Object)list))) : null);
        return Unit.INSTANCE;
    }
}

