/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.ForumAnnouncementBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.forums.ForumAnnouncement;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.ForumsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/ForumAnnouncementParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/forums/ForumAnnouncement;", "<init>", "()V", "fromContent", "content", "", "announcementId", "", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nForumAnnouncementParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForumAnnouncementParser.kt\ncom/galarzaa/tibiakt/core/parsers/ForumAnnouncementParser\n+ 2 ForumAnnouncementBuilder.kt\ncom/galarzaa/tibiakt/core/builders/ForumAnnouncementBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n30#2:78\n26#2:79\n1611#3,9:80\n1863#3:89\n1864#3:91\n1620#3:92\n1#4:90\n*S KotlinDebug\n*F\n+ 1 ForumAnnouncementParser.kt\ncom/galarzaa/tibiakt/core/parsers/ForumAnnouncementParser\n*L\n39#1:78\n39#1:79\n48#1:80,9\n48#1:89\n48#1:91\n48#1:92\n48#1:90\n*E\n"})
public final class ForumAnnouncementParser
implements Parser<ForumAnnouncement> {
    @NotNull
    public static final ForumAnnouncementParser INSTANCE = new ForumAnnouncementParser();

    private ForumAnnouncementParser() {
    }

    @Override
    @Nullable
    public ForumAnnouncement fromContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return this.fromContent(content, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ForumAnnouncement fromContent(@NotNull String content, int announcementId) {
        void $this$mapNotNullTo$iv$iv;
        Elements breadCrumbs;
        ForumAnnouncementBuilder $this$fromContent_u24lambda_u241;
        ForumAnnouncementBuilder forumAnnouncementBuilder;
        Element boxContent;
        block7: {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
                    boolean $i$f$forumAnnouncement = false;
                    boolean $i$f$forumAnnouncementBuilder = false;
                    $this$fromContent_u24lambda_u241 = forumAnnouncementBuilder = new ForumAnnouncementBuilder();
                    boolean bl = false;
                    Elements elements = boxContent.select("div.ForumBreadCrumbs > a");
                    Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
                    breadCrumbs = elements;
                    if (!breadCrumbs.isEmpty()) break block7;
                    Element messageBox = boxContent.selectFirst("div.TableContainer");
                    if (messageBox == null) break block8;
                    String string = messageBox.text();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"error", (boolean)false, (int)2, null)) break block9;
                }
                throw new ParsingException("Could not find Forum Breadcrumbs", null, 2, null);
            }
            return null;
        }
        Iterable $this$mapNotNull$iv = (Iterable)breadCrumbs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv$iv$iv.iterator();
        while (stringArray.hasNext()) {
            LinkInformation it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = stringArray.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (ElementsKt.getLinkInformation(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        LinkInformation sectionLink = (LinkInformation)list.get(0);
        LinkInformation boardLink = (LinkInformation)list.get(1);
        List<String> list2 = sectionLink.getQueryParams().get("sectionid");
        if (list2 == null || (list2 = (String)CollectionsKt.first(list2)) == null) {
            throw new ParsingException("Could not find section ID in link.", null, 2, null);
        }
        $this$fromContent_u24lambda_u241.setSectionId(Integer.parseInt((String)((Object)list2)));
        $this$fromContent_u24lambda_u241.setSection(sectionLink.getTitle());
        List<String> list3 = boardLink.getQueryParams().get("boardid");
        if (list3 == null || (list3 = (String)CollectionsKt.first(list3)) == null) {
            throw new ParsingException("Could not find board ID in link.", null, 2, null);
        }
        $this$fromContent_u24lambda_u241.setBoardId(Integer.parseInt((String)((Object)list3)));
        $this$fromContent_u24lambda_u241.setBoard(boardLink.getTitle());
        $this$fromContent_u24lambda_u241.setAnnouncementId(announcementId);
        Element element = boxContent.selectFirst("div.PostCharacterText");
        Intrinsics.checkNotNull((Object)element);
        $this$fromContent_u24lambda_u241.setAuthor(ForumsKt.parseAuthorTable(element));
        Element element2 = boxContent.selectFirst("div.ForumPost");
        Intrinsics.checkNotNull((Object)element2);
        Element postContainer = element2;
        Element element3 = postContainer.selectFirst("div.PostText");
        Intrinsics.checkNotNull((Object)element3);
        Element postTextContainer = element3;
        Element titleTag = postTextContainer.selectFirst("b");
        Element element4 = postTextContainer.selectFirst("font");
        Intrinsics.checkNotNull((Object)element4);
        Element datesContainer = element4;
        stringArray = new String[]{" until "};
        List list4 = StringsKt.split$default((CharSequence)StringExtensionsKt.remove$default(StringExtensionsKt.remove$default(ElementsKt.cleanText(datesContainer), "(", false, 2, null), ")", false, 2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String startDateText = (String)list4.get(0);
        String endDateText = (String)list4.get(1);
        Object object = titleTag;
        if (object == null || (object = object.text()) == null) {
            throw new ParsingException("Could not find title in post.", null, 2, null);
        }
        $this$fromContent_u24lambda_u241.setTitle((String)object);
        titleTag.remove();
        datesContainer.remove();
        String string = postTextContainer.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
        String[] stringArray2 = new String[]{"<hr>"};
        $this$fromContent_u24lambda_u241.setContent((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray2, (boolean)false, (int)2, (int)2, null)));
        $this$fromContent_u24lambda_u241.setStartDate(DatesKt.parseTibiaForumDateTime(startDateText));
        $this$fromContent_u24lambda_u241.setEndDate(DatesKt.parseTibiaForumDateTime(endDateText));
        return forumAnnouncementBuilder.build();
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

