/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.EventsScheduleBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.news.EventsSchedule;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/EventsScheduleParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/news/EventsSchedule;", "<init>", "()V", "fromContent", "content", "", "parseCalendar", "", "Lcom/galarzaa/tibiakt/core/builders/EventsScheduleBuilder;", "boxContent", "Lorg/jsoup/nodes/Element;", "yearMonth", "Ljava/time/YearMonth;", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nEventsScheduleParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsScheduleParser.kt\ncom/galarzaa/tibiakt/core/parsers/EventsScheduleParser\n+ 2 EventsScheduleBuilder.kt\ncom/galarzaa/tibiakt/core/builders/EventsScheduleBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n27#2:105\n40#2:106\n1863#3,2:107\n*S KotlinDebug\n*F\n+ 1 EventsScheduleParser.kt\ncom/galarzaa/tibiakt/core/parsers/EventsScheduleParser\n*L\n37#1:105\n72#1:106\n100#1:107,2\n*E\n"})
public final class EventsScheduleParser
implements Parser<EventsSchedule> {
    @NotNull
    public static final EventsScheduleParser INSTANCE = new EventsScheduleParser();

    private EventsScheduleParser() {
    }

    @Override
    @NotNull
    public EventsSchedule fromContent(@NotNull String content) {
        EventsScheduleBuilder eventsScheduleBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Element boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
        boolean $i$f$eventsSchedule = false;
        EventsScheduleBuilder $this$fromContent_u24lambda_u240 = eventsScheduleBuilder = new EventsScheduleBuilder();
        boolean bl = false;
        Element element = boxContent.selectFirst("div.eventscheduleheaderdateblock");
        if (element == null) {
            throw new ParsingException("date block not found", null, 2, null);
        }
        Element dateBlock = element;
        $this$fromContent_u24lambda_u240.setYearMonth(YearMonth.parse(StringExtensionsKt.remove$default(StringExtensionsKt.remove$default(ElementsKt.cleanText(dateBlock), "\u00bb", false, 2, null), "\u00ab", false, 2, null), DateTimeFormatter.ofPattern("MMMM yyyy")));
        INSTANCE.parseCalendar($this$fromContent_u24lambda_u240, boxContent, $this$fromContent_u24lambda_u240.getYearMonth());
        return eventsScheduleBuilder.build();
    }

    private final void parseCalendar(EventsScheduleBuilder $this$parseCalendar, Element boxContent, YearMonth yearMonth) {
        YearMonth currentMonth = yearMonth;
        Element calendarTable = boxContent.selectFirst("#eventscheduletable");
        int onGoingDay = 1;
        boolean isFirstDay = true;
        List onGoingEvents = new ArrayList();
        Iterator iterator = ElementsKt.cells(calendarTable).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Elements spans;
            Element dayDiv;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element cell = (Element)e;
            if (cell.selectFirst("div") == null) {
                throw new ParsingException("could not find day's div", null, 2, null);
            }
            int day = Integer.parseInt(ElementsKt.cleanText(dayDiv));
            Intrinsics.checkNotNullExpressionValue((Object)cell.select("span.HelperDivIndicator"), (String)"select(...)");
            if (onGoingDay < day) {
                currentMonth = currentMonth.minusMonths(1L);
            }
            if (day < onGoingDay) {
                currentMonth = currentMonth.plusMonths(1L);
            }
            onGoingDay = day + 1;
            List todayEvents = new ArrayList();
            Iterator iterator3 = spans.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"iterator(...)");
            Iterator iterator4 = iterator3;
            block1: while (iterator4.hasNext()) {
                Elements divs;
                Object e2 = iterator4.next();
                Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                Element popup = (Element)e2;
                String string = popup.attr("onmouseover");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                Document popupContent = (Document)ElementsKt.parsePopup(string).component2();
                Intrinsics.checkNotNullExpressionValue((Object)popupContent.select("div"), (String)"select(...)");
                int index = 0;
                int n = CollectionsKt.getLastIndex((List)((List)divs));
                int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
                if (index > n2) continue;
                while (true) {
                    EventsScheduleBuilder.EventEntryBuilder eventEntryBuilder;
                    boolean $i$f$eventEntryBuilder = false;
                    EventsScheduleBuilder.EventEntryBuilder $this$parseCalendar_u24lambda_u241 = eventEntryBuilder = new EventsScheduleBuilder.EventEntryBuilder();
                    boolean bl = false;
                    Object object = divs.get(index);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    $this$parseCalendar_u24lambda_u241.setTitle(StringExtensionsKt.remove$default(ElementsKt.cleanText((Element)object), ":", false, 2, null));
                    Object object2 = divs.get(index + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                    $this$parseCalendar_u24lambda_u241.setDescription(StringExtensionsKt.remove$default(ElementsKt.cleanText((Element)object2), "\u2022 ", false, 2, null));
                    EventsScheduleBuilder.EventEntryBuilder event = eventEntryBuilder;
                    todayEvents.add(event);
                    if (!onGoingEvents.contains(event)) {
                        if (!isFirstDay) {
                            event.setStartDate(LocalDate.of(currentMonth.getYear(), currentMonth.getMonth(), day));
                        }
                        onGoingEvents.add(event);
                    }
                    if (index == n2) continue block1;
                    index += 2;
                }
            }
            for (EventsScheduleBuilder.EventEntryBuilder pendingEvent : CollectionsKt.toList((Iterable)onGoingEvents)) {
                if (todayEvents.contains(pendingEvent)) continue;
                pendingEvent.setEndDate(LocalDate.of(currentMonth.getYear(), currentMonth.getMonth(), day).minusDays(1L));
                $this$parseCalendar.addEntry(pendingEvent.build());
                onGoingEvents.remove(pendingEvent);
            }
            isFirstDay = false;
        }
        Iterable $this$forEach$iv = onGoingEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventsScheduleBuilder.EventEntryBuilder it = (EventsScheduleBuilder.EventEntryBuilder)element$iv;
            boolean bl = false;
            $this$parseCalendar.addEntry(it.build());
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

