/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.CreaturesSectionBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.creatures.CreaturesSection;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/CreaturesSectionParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/creatures/CreaturesSection;", "<init>", "()V", "fromContent", "content", "", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nCreaturesSectionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreaturesSectionParser.kt\ncom/galarzaa/tibiakt/core/parsers/CreaturesSectionParser\n+ 2 CreaturesSectionBuilder.kt\ncom/galarzaa/tibiakt/core/builders/CreaturesSectionBuilderKt\n*L\n1#1,59:1\n25#2:60\n*S KotlinDebug\n*F\n+ 1 CreaturesSectionParser.kt\ncom/galarzaa/tibiakt/core/parsers/CreaturesSectionParser\n*L\n31#1:60\n*E\n"})
public final class CreaturesSectionParser
implements Parser<CreaturesSection> {
    @NotNull
    public static final CreaturesSectionParser INSTANCE = new CreaturesSectionParser();

    private CreaturesSectionParser() {
    }

    @Override
    @NotNull
    public CreaturesSection fromContent(@NotNull String content) {
        CreaturesSectionBuilder $this$fromContent_u24lambda_u243;
        CreaturesSectionBuilder creaturesSectionBuilder;
        Element boxContent;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
                Map<String, Element> tables = ElementsKt.parseTablesMap(boxContent, "table.Table1");
                boolean $i$f$creaturesSection = false;
                $this$fromContent_u24lambda_u243 = creaturesSectionBuilder = new CreaturesSectionBuilder();
                boolean bl = false;
                Object object = tables.get("Boosted Creature");
                if (object == null) break block7;
                Element it = object;
                boolean bl2 = false;
                Object object2 = it.selectFirst("a");
                if (object2 == null || (object2 = ElementsKt.getLinkInformation(object2)) == null) {
                    throw new ParsingException("boosted creature link not found", null, 2, null);
                }
                Object boostedCreatureLink = object2;
                CreaturesSectionBuilder creaturesSectionBuilder2 = $this$fromContent_u24lambda_u243.boostedCreature((Function1<? super CreaturesSectionBuilder.CreatureEntryBuilder, Unit>)((Function1)arg_0 -> CreaturesSectionParser.fromContent$lambda$3$lambda$1$lambda$0((LinkInformation)boostedCreatureLink, arg_0)));
                object = creaturesSectionBuilder2;
                if (creaturesSectionBuilder2 != null) break block8;
            }
            throw new ParsingException("Boosted Creature table not found.", null, 2, null);
        }
        Element element = boxContent.selectFirst("div[style*=display: table]");
        if (element == null) {
            throw new ParsingException("could not find creatures list container", null, 2, null);
        }
        Element entriesTable = element;
        Elements elements = entriesTable.select("div[style*=float: left]");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements entryContainers = elements;
        Iterator iterator = entryContainers.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element entryContainer = (Element)e;
            Object object = entryContainer.selectFirst("a");
            if (object == null || (object = ElementsKt.getLinkInformation(object)) == null) {
                throw new ParsingException("creature link not found", null, 2, null);
            }
            Object linkInfo = object;
            $this$fromContent_u24lambda_u243.addCreature((Function1<? super CreaturesSectionBuilder.CreatureEntryBuilder, Unit>)((Function1)arg_0 -> CreaturesSectionParser.fromContent$lambda$3$lambda$2(entryContainer, (LinkInformation)linkInfo, arg_0)));
        }
        return creaturesSectionBuilder.build();
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final Unit fromContent$lambda$3$lambda$1$lambda$0(LinkInformation $boostedCreatureLink, CreaturesSectionBuilder.CreatureEntryBuilder $this$boostedCreature) {
        Intrinsics.checkNotNullParameter((Object)$this$boostedCreature, (String)"$this$boostedCreature");
        $this$boostedCreature.setName($boostedCreatureLink.getTitle());
        List<String> list = $boostedCreatureLink.getQueryParams().get("race");
        if (list == null || (list = list.get(0)) == null) {
            throw new ParsingException("race not found in boosted creature's link", null, 2, null);
        }
        $this$boostedCreature.setIdentifier((String)((Object)list));
        return Unit.INSTANCE;
    }

    private static final Unit fromContent$lambda$3$lambda$2(Element $entryContainer, LinkInformation $linkInfo, CreaturesSectionBuilder.CreatureEntryBuilder $this$addCreature) {
        Intrinsics.checkNotNullParameter((Object)$this$addCreature, (String)"$this$addCreature");
        $this$addCreature.setName(ElementsKt.cleanText($entryContainer));
        List<String> list = $linkInfo.getQueryParams().get("race");
        if (list == null || (list = list.get(0)) == null) {
            throw new ParsingException("race not found in creature's link", null, 2, null);
        }
        $this$addCreature.setIdentifier((String)((Object)list));
        return Unit.INSTANCE;
    }
}

