/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.CharacterBuilder;
import com.galarzaa.tibiakt.core.enums.Sex;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.enums.Vocation;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.character.Character;
import com.galarzaa.tibiakt.core.models.character.DeathParticipant;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001b\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0014\u0010\u001d\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0014\u0010\u001e\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001f\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010 \u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010!\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0014\u0010%\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/CharacterParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/character/Character;", "<init>", "()V", "deletedRegexp", "Lkotlin/text/Regex;", "titlesRegexp", "houseRegexp", "deathsRegex", "deathAssistsRegex", "linkSearch", "linkContent", "deathSummon", "tradedLabel", "", "fromContent", "content", "parseCharacterInformation", "", "Lcom/galarzaa/tibiakt/core/builders/CharacterBuilder;", "rows", "Lorg/jsoup/select/Elements;", "parseGuildColumn", "valueColumn", "Lorg/jsoup/nodes/Element;", "parseHouseColumn", "parseTitles", "value", "parseNameField", "parseAccountBadges", "parseAccountAchievements", "parseAccountInformation", "parseCharacterDeaths", "parseKiller", "Lcom/galarzaa/tibiakt/core/models/character/DeathParticipant;", "killerHtml", "parseCharacters", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nCharacterParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterParser.kt\ncom/galarzaa/tibiakt/core/parsers/CharacterParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CharacterBuilder.kt\ncom/galarzaa/tibiakt/core/builders/CharacterBuilderKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n*L\n1#1,242:1\n1755#2,3:243\n1557#2:248\n1628#2,3:249\n1557#2:252\n1628#2,3:253\n1557#2:260\n1628#2,3:261\n1611#2,9:264\n1863#2:273\n1864#2:275\n1620#2:276\n1611#2,9:277\n1863#2:286\n1864#2:288\n1620#2:289\n35#3:246\n1#4:247\n1#4:257\n1#4:259\n1#4:274\n1#4:287\n33#5:256\n33#5:258\n*S KotlinDebug\n*F\n+ 1 CharacterParser.kt\ncom/galarzaa/tibiakt/core/parsers/CharacterParser\n*L\n56#1:243,3\n71#1:248\n71#1:249,3\n76#1:252\n76#1:253,3\n166#1:260\n166#1:261,3\n194#1:264,9\n194#1:273\n194#1:275\n194#1:276\n195#1:277,9\n195#1:286\n195#1:288\n195#1:289\n57#1:246\n78#1:257\n80#1:259\n194#1:274\n195#1:287\n78#1:256\n80#1:258\n*E\n"})
public final class CharacterParser
implements Parser<Character> {
    @NotNull
    public static final CharacterParser INSTANCE = new CharacterParser();
    @NotNull
    private static final Regex deletedRegexp = new Regex("([^,]+), will be deleted at (.*)");
    @NotNull
    private static final Regex titlesRegexp = new Regex("(.*)\\((\\d+) titles? unlocked\\)");
    @NotNull
    private static final Regex houseRegexp = new Regex("\\(([^)]+)\\) is paid until (.*)");
    @NotNull
    private static final Regex deathsRegex = new Regex("Level (\\d+) by (.*)\\.</td>");
    @NotNull
    private static final Regex deathAssistsRegex = new Regex("(?:(?<killers>.+)\\.<br\\s?/>)?Assisted by (?<assists>.+)");
    @NotNull
    private static final Regex linkSearch = new Regex("<a[^>]+>[^<]+</a>");
    @NotNull
    private static final Regex linkContent = new Regex(">([^<]+)<");
    @NotNull
    private static final Regex deathSummon = new Regex("(?<summon>an? .+) of (?<name>.*)");
    @NotNull
    private static final String tradedLabel = "(traded)";

    private CharacterParser() {
    }

    @Override
    @Nullable
    public Character fromContent(@NotNull String content) {
        CharacterBuilder characterBuilder;
        block11: {
            Elements elements;
            boolean bl;
            Map tables;
            block10: {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Document document = Jsoup.parse((String)content, (String)"", (org.jsoup.parser.Parser)org.jsoup.parser.Parser.xmlParser());
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
                Document document2 = document;
                Element element = document2.selectFirst("div.BoxContent");
                if (element == null) {
                    throw new ParsingException("BoxContent container not found", null, 2, null);
                }
                Element boxContent = element;
                tables = ElementsKt.parseTables$default(boxContent, null, 1, null);
                Iterable $this$any$iv = tables.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"Could not find character", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            boolean $i$f$character = false;
            CharacterBuilder $this$fromContent_u24lambda_u246 = characterBuilder = new CharacterBuilder();
            boolean bl3 = false;
            Elements elements2 = (Elements)tables.get("Character Information");
            if (elements2 == null) {
                return null;
            }
            INSTANCE.parseCharacterInformation($this$fromContent_u24lambda_u246, elements2);
            Elements elements3 = (Elements)tables.get("Account Badges");
            if (elements3 != null) {
                Elements $this$fromContent_u24lambda_u246_u24lambda_u241 = elements = elements3;
                boolean bl4 = false;
                INSTANCE.parseAccountBadges($this$fromContent_u24lambda_u246, $this$fromContent_u24lambda_u246_u24lambda_u241);
            }
            Elements elements4 = (Elements)tables.get("Account Achievements");
            if (elements4 != null) {
                Elements $this$fromContent_u24lambda_u246_u24lambda_u242 = elements = elements4;
                boolean bl5 = false;
                INSTANCE.parseAccountAchievements($this$fromContent_u24lambda_u246, $this$fromContent_u24lambda_u246_u24lambda_u242);
            }
            Elements elements5 = (Elements)tables.get("Account Information");
            if (elements5 != null) {
                Elements $this$fromContent_u24lambda_u246_u24lambda_u243 = elements = elements5;
                boolean bl6 = false;
                INSTANCE.parseAccountInformation($this$fromContent_u24lambda_u246, $this$fromContent_u24lambda_u246_u24lambda_u243);
            }
            Elements elements6 = (Elements)tables.get("Character Deaths (Last 30 Days)");
            if (elements6 != null) {
                Elements $this$fromContent_u24lambda_u246_u24lambda_u244 = elements = elements6;
                boolean bl7 = false;
                INSTANCE.parseCharacterDeaths($this$fromContent_u24lambda_u246, $this$fromContent_u24lambda_u246_u24lambda_u244);
            }
            Elements elements7 = (Elements)tables.get("Characters");
            if (elements7 == null) break block11;
            Elements $this$fromContent_u24lambda_u246_u24lambda_u245 = elements = elements7;
            boolean bl8 = false;
            INSTANCE.parseCharacters($this$fromContent_u24lambda_u246, $this$fromContent_u24lambda_u246_u24lambda_u245);
        }
        return characterBuilder.build();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void parseCharacterInformation(CharacterBuilder $this$parseCharacterInformation, Elements rows) {
        v0 = rows.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"iterator(...)");
        var3_3 = v0;
        while (var3_3.hasNext()) {
            v1 = var3_3.next();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"next(...)");
            row = (Element)v1;
            Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
            $this$map$iv = (Iterable)columns;
            $i$f$map = false;
            var9_10 = $this$map$iv;
            destination$iv$iv /* !! */  = (String[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var14_17 = (Element)item$iv$iv;
                var21_34 = destination$iv$iv /* !! */ ;
                $i$a$-map-CharacterParser$parseCharacterInformation$1 = 0;
                v2 = it.wholeText();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"wholeText(...)");
                var21_34.add(StringExtensionsKt.clean(v2));
            }
            var6_6 = (List)destination$iv$iv /* !! */ ;
            field = (String)var6_6.get(0);
            value = (String)var6_6.get(1);
            v3 = StringExtensionsKt.remove$default(StringsKt.replace$default((String)field, (String)" ", (String)"_", (boolean)false, (int)4, null), ":", false, 2, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
            field = v3;
            var9_10 = field;
            tmp = -1;
            switch (var9_10.hashCode()) {
                case -1132570118: {
                    if (var9_10.equals("former_names")) {
                        tmp = 1;
                    }
                    break;
                }
                case 102865796: {
                    if (var9_10.equals("level")) {
                        tmp = 2;
                    }
                    break;
                }
                case -2019156864: {
                    if (var9_10.equals("last_login")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1123836348: {
                    if (var9_10.equals("former_world")) {
                        tmp = 4;
                    }
                    break;
                }
                case 113766: {
                    if (var9_10.equals("sex")) {
                        tmp = 5;
                    }
                    break;
                }
                case 903489523: {
                    if (var9_10.equals("achievement_points")) {
                        tmp = 6;
                    }
                    break;
                }
                case 869262916: {
                    if (var9_10.equals("account_status")) {
                        tmp = 7;
                    }
                    break;
                }
                case 110371416: {
                    if (var9_10.equals("title")) {
                        tmp = 8;
                    }
                    break;
                }
                case -1159028954: {
                    if (var9_10.equals("married_to")) {
                        tmp = 9;
                    }
                    break;
                }
                case 99469088: {
                    if (var9_10.equals("house")) {
                        tmp = 10;
                    }
                    break;
                }
                case -2145689493: {
                    if (var9_10.equals("vocation")) {
                        tmp = 11;
                    }
                    break;
                }
                case 113318802: {
                    if (var9_10.equals("world")) {
                        tmp = 12;
                    }
                    break;
                }
                case 144096162: {
                    if (var9_10.equals("guild_membership")) {
                        tmp = 13;
                    }
                    break;
                }
                case 3373707: {
                    if (var9_10.equals("name")) {
                        tmp = 14;
                    }
                    break;
                }
                case 950398559: {
                    if (var9_10.equals("comment")) {
                        tmp = 15;
                    }
                    break;
                }
                case 0x2C929929: {
                    if (var9_10.equals("position")) {
                        tmp = 16;
                    }
                    break;
                }
                case 2124045062: {
                    if (var9_10.equals("residence")) {
                        tmp = 17;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 14: {
                    this.parseNameField($this$parseCharacterInformation, value);
                    break;
                }
                case 8: {
                    this.parseTitles($this$parseCharacterInformation, value);
                    break;
                }
                case 1: {
                    destination$iv$iv /* !! */  = new String[]{","};
                    destination$iv$iv /* !! */  = StringsKt.split$default((CharSequence)value, (String[])destination$iv$iv /* !! */ , (boolean)false, (int)0, (int)6, null);
                    var21_34 = $this$parseCharacterInformation;
                    $i$f$map = false;
                    var12_14 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var17_26 = (String)item$iv$iv;
                        var22_35 = destination$iv$iv;
                        $i$a$-map-CharacterParser$parseCharacterInformation$2 = false;
                        var22_35.add(StringsKt.trim((CharSequence)((CharSequence)it)).toString());
                    }
                    var21_34.setFormerNames((List)destination$iv$iv);
                    break;
                }
                case 4: {
                    $this$parseCharacterInformation.setFormerWorld(value);
                    break;
                }
                case 5: {
                    $this$map$iv = StringEnum.Companion;
                    var21_34 = $this$parseCharacterInformation;
                    $i$f$fromValue = false;
                    it$iv = $this$mapTo$iv$iv = Sex.class;
                    $i$a$-takeIf-StringEnum$Companion$fromValue$1$iv = false;
                    v4 /* !! */  = it$iv.isEnum() != false ? $this$mapTo$iv$iv : null;
                    if (v4 /* !! */  == null || (v4 /* !! */  = (Enum[])v4 /* !! */ .getEnumConstants()) == null) ** GOTO lbl165
                    $i$a$-takeIf-StringEnum$Companion$fromValue$1$iv = v4 /* !! */ ;
                    var16_25 = $i$a$-takeIf-StringEnum$Companion$fromValue$1$iv.length;
                    for ($i$a$-map-CharacterParser$parseCharacterInformation$1 = 0; $i$a$-map-CharacterParser$parseCharacterInformation$1 < var16_25; ++$i$a$-map-CharacterParser$parseCharacterInformation$1) {
                        it$iv = var17_27 = $i$a$-takeIf-StringEnum$Companion$fromValue$1$iv[$i$a$-map-CharacterParser$parseCharacterInformation$1];
                        $i$a$-find-StringEnum$Companion$fromValue$2$iv = false;
                        if (!(Intrinsics.areEqual((Object)((StringEnum)it$iv).getValue(), (Object)value) != false || Intrinsics.areEqual((Object)it$iv.name(), (Object)value) != false)) continue;
                        v5 = var17_27;
                        ** GOTO lbl166
                    }
                    v5 = null;
                    ** GOTO lbl166
lbl165:
                    // 1 sources

                    v5 = null;
lbl166:
                    // 3 sources

                    Intrinsics.checkNotNull(v5);
                    var21_34.setSex((Sex)v5);
                    break;
                }
                case 11: {
                    $i$f$fromValue = StringEnum.Companion;
                    var21_34 = $this$parseCharacterInformation;
                    $i$f$fromValue = false;
                    it$iv = var13_16 = Vocation.class;
                    $i$a$-takeIf-StringEnum$Companion$fromValue$1$iv = false;
                    v6 /* !! */  = it$iv.isEnum() != false ? var13_16 : null;
                    if (v6 /* !! */  == null || (v6 /* !! */  = (Enum[])v6 /* !! */ .getEnumConstants()) == null) ** GOTO lbl187
                    var15_23 = v6 /* !! */ ;
                    var17_28 = var15_23.length;
                    for (var16_25 = 0; var16_25 < var17_28; ++var16_25) {
                        it$iv = var18_30 = var15_23[var16_25];
                        $i$a$-find-StringEnum$Companion$fromValue$2$iv = false;
                        if (!(Intrinsics.areEqual((Object)((StringEnum)it$iv).getValue(), (Object)value) != false || Intrinsics.areEqual((Object)it$iv.name(), (Object)value) != false)) continue;
                        v7 = var18_30;
                        ** GOTO lbl188
                    }
                    v7 = null;
                    ** GOTO lbl188
lbl187:
                    // 1 sources

                    v7 = null;
lbl188:
                    // 3 sources

                    v8 = (Vocation)v7;
                    if (v8 == null) {
                        throw new ParsingException("Unknown vocation: " + value, null, 2, null);
                    }
                    var21_34.setVocation(v8);
                    break;
                }
                case 2: {
                    $this$parseCharacterInformation.setLevel(Integer.parseInt(value));
                    break;
                }
                case 6: {
                    $this$parseCharacterInformation.setAchievementPoints(Integer.parseInt(value));
                    break;
                }
                case 12: {
                    $this$parseCharacterInformation.setWorld(value);
                    break;
                }
                case 17: {
                    $this$parseCharacterInformation.setResidence(value);
                    break;
                }
                case 3: {
                    if (StringsKt.contains((CharSequence)value, (CharSequence)"never logged", (boolean)true)) break;
                    $this$parseCharacterInformation.setLastLogin(DatesKt.parseTibiaDateTime(value));
                    break;
                }
                case 16: {
                    $this$parseCharacterInformation.setPosition(value);
                    break;
                }
                case 15: {
                    $this$parseCharacterInformation.setComment(value);
                    break;
                }
                case 7: {
                    v9 = value.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toLowerCase(...)");
                    $this$parseCharacterInformation.setPremium(StringsKt.contains$default((CharSequence)v9, (CharSequence)"premium", (boolean)false, (int)2, null));
                    break;
                }
                case 9: {
                    $this$parseCharacterInformation.setMarriedTo(value);
                    break;
                }
                case 10: {
                    v10 = columns.get(1);
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"get(...)");
                    this.parseHouseColumn($this$parseCharacterInformation, (Element)v10);
                    break;
                }
                case 13: {
                    v11 = columns.get(1);
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"get(...)");
                    this.parseGuildColumn($this$parseCharacterInformation, (Element)v11);
                }
            }
        }
    }

    private final void parseGuildColumn(CharacterBuilder $this$parseGuildColumn, Element valueColumn) {
        Object object = valueColumn.selectFirst("a");
        if (object == null || (object = object.text()) == null) {
            return;
        }
        Object guildName = object;
        String string = valueColumn.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        String[] stringArray = new String[]{"of the"};
        String rankName = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null))))).toString();
        $this$parseGuildColumn.guild(rankName, (String)guildName);
    }

    private final void parseHouseColumn(CharacterBuilder $this$parseHouseColumn, Element valueColumn) {
        String string = valueColumn.ownText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ownText(...)");
        MatchResult matchResult = Regex.find$default((Regex)houseRegexp, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null) {
            return;
        }
        MatchResult match = matchResult;
        Object object = valueColumn.selectFirst("a");
        if (object == null || (object = ElementsKt.getLinkInformation((Element)object)) == null) {
            return;
        }
        Object link = object;
        List list = match.getGroupValues();
        String town = (String)list.get(1);
        String paidUntilStr = (String)list.get(2);
        List<String> list2 = ((LinkInformation)link).getQueryParams().get("houseid");
        if (list2 == null || (list2 = (String)CollectionsKt.first(list2)) == null) {
            return;
        }
        List<String> list3 = ((LinkInformation)link).getQueryParams().get("world");
        if (list3 == null || (list3 = (String)CollectionsKt.first(list3)) == null) {
            return;
        }
        $this$parseHouseColumn.addHouse(((LinkInformation)link).getTitle(), Integer.parseInt((String)((Object)list2)), town, DatesKt.parseTibiaDate(paidUntilStr), (String)((Object)list3));
    }

    private final void parseTitles(CharacterBuilder $this$parseTitles, String value) {
        MatchResult matchResult = Regex.find$default((Regex)titlesRegexp, (CharSequence)value, (int)0, (int)2, null);
        if (matchResult == null) {
            return;
        }
        MatchResult match = matchResult;
        List list = match.getGroupValues();
        String currentTitle = (String)list.get(1);
        String unlockedTitlesStr = (String)list.get(2);
        $this$parseTitles.setTitle(StringsKt.contains((CharSequence)currentTitle, (CharSequence)"none", (boolean)true) ? null : ((Object)StringsKt.trim((CharSequence)currentTitle)).toString());
        $this$parseTitles.setUnlockedTitles(Integer.parseInt(unlockedTitlesStr));
    }

    private final void parseNameField(CharacterBuilder $this$parseNameField, String value) {
        String string;
        MatchResult match = deletedRegexp.matchEntire((CharSequence)value);
        if (match != null) {
            List list = match.getGroupValues();
            String cleanName = (String)list.get(1);
            String deletionDateStr = (String)list.get(2);
            $this$parseNameField.setDeletionDate(DatesKt.parseTibiaDateTime(deletionDateStr));
            string = cleanName;
        } else {
            string = value;
        }
        $this$parseNameField.setName(string);
        if (StringsKt.contains$default((CharSequence)$this$parseNameField.getName(), (CharSequence)tradedLabel, (boolean)false, (int)2, null)) {
            $this$parseNameField.setRecentlyTraded(true);
            $this$parseNameField.setName(((Object)StringsKt.trim((CharSequence)StringExtensionsKt.remove$default($this$parseNameField.getName(), tradedLabel, false, 2, null))).toString());
        }
    }

    private final void parseAccountBadges(CharacterBuilder $this$parseAccountBadges, Elements rows) {
        Object object = rows.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Element row = (Element)object;
        Iterator iterator = row.select("td > span").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String description;
            Element popupSpan;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element column = (Element)e;
            if (column.selectFirst("span.HelperDivIndicator") == null) {
                return;
            }
            String string = popupSpan.attr("onmouseover");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            Pair<String, Document> pair = ElementsKt.parsePopup(string);
            String title = (String)pair.component1();
            Document popupContent = (Document)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)popupContent.text(), (String)"text(...)");
            Element element = column.selectFirst("img");
            String imageUrl = element != null ? element.attr("src") : null;
            String string2 = imageUrl;
            if (string2 == null) continue;
            $this$parseAccountBadges.addBadge(title, description, string2);
        }
    }

    private final void parseAccountAchievements(CharacterBuilder $this$parseAccountAchievements, Elements rows) {
        Iterator iterator = rows.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String name;
            Elements columns;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element row = (Element)e;
            Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
            if (columns.size() != 2) continue;
            Object e2 = ((List)columns).get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"component1(...)");
            Element gradeColumn = (Element)e2;
            Object e3 = ((List)columns).get(1);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"component2(...)");
            Element nameColumn = (Element)e3;
            int grade = gradeColumn.select("img").size();
            Intrinsics.checkNotNullExpressionValue((Object)nameColumn.text(), (String)"text(...)");
            boolean isSecret = nameColumn.selectFirst("img") != null;
            $this$parseAccountAchievements.addAchievement(name, grade, isSecret);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseAccountInformation(CharacterBuilder $this$parseAccountInformation, Elements rows) {
        Map valueMap = new LinkedHashMap();
        Iterator iterator = rows.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Elements columns;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element row = (Element)e;
            Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
            Iterable $this$map$iv = (Iterable)columns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.wholeText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wholeText(...)");
                collection.add(StringExtensionsKt.clean(string));
            }
            List list = (List)destination$iv$iv;
            String field = (String)list.get(0);
            String value = (String)list.get(1);
            String string = StringExtensionsKt.remove$default(StringsKt.replace$default((String)field, (String)" ", (String)"_", (boolean)false, (int)4, null), ":", false, 2, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            field = string;
            valueMap.put(field, value);
        }
        String string = (String)valueMap.get("created");
        if (string == null) {
            return;
        }
        $this$parseAccountInformation.accountInformation(DatesKt.parseTibiaDateTime(string), (String)valueMap.get("loyalty_title"), (String)valueMap.get("position"));
    }

    /*
     * WARNING - void declaration
     */
    private final void parseCharacterDeaths(CharacterBuilder $this$parseCharacterDeaths, Elements rows) {
        Iterator iterator = rows.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable assistsDec;
            Elements columns;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element row = (Element)e;
            Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
            if (columns.size() != 2) continue;
            Object e2 = ((List)columns).get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"component1(...)");
            Element dateColumn = (Element)e2;
            Object e3 = ((List)columns).get(1);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"component2(...)");
            Element descriptionColumn = (Element)e3;
            String string = dateColumn.text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            Instant deathDateTime = DatesKt.parseTibiaDateTime(string);
            String string2 = descriptionColumn.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            MatchResult deathMatch = Regex.find$default((Regex)deathsRegex, (CharSequence)string2, (int)0, (int)2, null);
            Object object = deathMatch;
            if (object == null || (object = object.getGroupValues()) == null) {
                object = TuplesKt.toList((Triple)new Triple((Object)"", (Object)"0", (Object)descriptionColumn.toString()));
            }
            Object object2 = object;
            String levelStr = (String)object2.get(1);
            String killersDesc = null;
            killersDesc = (String)object2.get(2);
            List assistNameList = null;
            assistNameList = new ArrayList();
            if (Regex.find$default((Regex)deathAssistsRegex, (CharSequence)killersDesc, (int)0, (int)2, null) != null) {
                Object object3;
                MatchResult matchResult;
                MatchResult $this$parseCharacterDeaths_u24lambda_u2411 = matchResult;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseCharacterDeaths_u24lambda_u2411.getGroups(), (String)"killers");
                String string3 = matchGroup != null ? matchGroup.getValue() : null;
                if (string3 == null) {
                    string3 = killersDesc = "";
                }
                if ((object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseCharacterDeaths_u24lambda_u2411.getGroups(), (String)"assists")) == null || (object3 = object3.getValue()) == null) {
                    return;
                }
                assistsDec = object3;
                assistNameList = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)linkSearch, (CharSequence)((CharSequence)((Object)assistsDec)), (int)0, (int)2, null), CharacterParser::parseCharacterDeaths$lambda$11$lambda$10));
            }
            List killerNameList = StringExtensionsKt.splitList$default(killersDesc, null, null, 3, null);
            Iterable $this$mapNotNull$iv = killerNameList;
            boolean $i$f$mapNotNull = false;
            assistsDec = $this$mapNotNull$iv;
            Iterable<DeathParticipant> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                DeathParticipant it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (INSTANCE.parseKiller(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List killerList = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv2 = assistNameList;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator4 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator4.hasNext()) {
                DeathParticipant it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator4.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (INSTANCE.parseKiller(it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List assistsList = (List)destination$iv$iv2;
            $this$parseCharacterDeaths.addDeath(deathDateTime, Integer.parseInt(levelStr), killerList, assistsList);
        }
    }

    private final DeathParticipant parseKiller(String killerHtml) {
        String summon;
        boolean isTraded;
        boolean isPlayer;
        String name;
        block3: {
            MatchResult matchResult;
            name = null;
            name = killerHtml;
            isPlayer = false;
            isTraded = false;
            summon = null;
            if (StringsKt.contains$default((CharSequence)killerHtml, (CharSequence)tradedLabel, (boolean)false, (int)2, null)) {
                name = ((Object)StringsKt.trim((CharSequence)StringExtensionsKt.remove$default(StringExtensionsKt.clean(killerHtml), tradedLabel, false, 2, null))).toString();
                isTraded = true;
                isPlayer = true;
            }
            if (StringsKt.contains$default((CharSequence)killerHtml, (CharSequence)"href", (boolean)false, (int)2, null)) {
                Object object = Regex.find$default((Regex)linkContent, (CharSequence)killerHtml, (int)0, (int)2, null);
                if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
                    return null;
                }
                name = object;
                isPlayer = true;
            }
            MatchResult matchResult2 = Regex.find$default((Regex)deathSummon, (CharSequence)name, (int)0, (int)2, null);
            if (matchResult2 == null) break block3;
            MatchResult $this$parseKiller_u24lambda_u2414 = matchResult = matchResult2;
            boolean bl = false;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseKiller_u24lambda_u2414.getGroups(), (String)"summon");
            Intrinsics.checkNotNull((Object)matchGroup);
            summon = StringExtensionsKt.clean(matchGroup.getValue());
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$parseKiller_u24lambda_u2414.getGroups(), (String)"name");
            Intrinsics.checkNotNull((Object)matchGroup2);
            name = StringExtensionsKt.clean(matchGroup2.getValue());
        }
        return new DeathParticipant(StringExtensionsKt.clean(name), isPlayer, summon, isTraded);
    }

    private final void parseCharacters(CharacterBuilder $this$parseCharacters, Elements rows) {
        for (Object e : rows.subList(1, rows.size())) {
            Elements columns;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element row = (Element)e;
            Intrinsics.checkNotNullExpressionValue((Object)row.select("td"), (String)"select(...)");
            Object e2 = ((List)columns).get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"component1(...)");
            Element nameColumn = (Element)e2;
            Object e3 = ((List)columns).get(1);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"component2(...)");
            Element worldColumn = (Element)e3;
            Object e4 = ((List)columns).get(2);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"component3(...)");
            Element statusColumn = (Element)e4;
            boolean isTraded = false;
            String name = StringExtensionsKt.clean((String)CollectionsKt.last((List)StringExtensionsKt.splitList$default(nameColumn.text(), ".", null, 2, null)));
            if (StringsKt.contains((CharSequence)name, (CharSequence)tradedLabel, (boolean)true)) {
                name = ((Object)StringsKt.trim((CharSequence)StringExtensionsKt.remove$default(name, tradedLabel, false, 2, null))).toString();
                isTraded = true;
            }
            boolean isMain = nameColumn.selectFirst("img") != null;
            String string = worldColumn.text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            String world = StringExtensionsKt.clean(string);
            String string2 = statusColumn.text();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
            String status = StringExtensionsKt.clean(string2);
            boolean isOnline = StringsKt.contains$default((CharSequence)status, (CharSequence)"online", (boolean)false, (int)2, null);
            boolean isDeleted = StringsKt.contains$default((CharSequence)status, (CharSequence)"deleted", (boolean)false, (int)2, null);
            String position = StringsKt.contains$default((CharSequence)status, (CharSequence)"CipSoft Member", (boolean)false, (int)2, null) ? "CipSoft Member" : null;
            $this$parseCharacters.addOtherCharacter(name, world, isMain, isOnline, isDeleted, isTraded, position);
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final String parseCharacterDeaths$lambda$11$lambda$10(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }
}

