/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.AuctionBuilder;
import com.galarzaa.tibiakt.core.builders.BazaarFiltersBuilder;
import com.galarzaa.tibiakt.core.builders.CharacterBazaarBuilder;
import com.galarzaa.tibiakt.core.enums.AuctionBattlEyeFilter;
import com.galarzaa.tibiakt.core.enums.AuctionOrderBy;
import com.galarzaa.tibiakt.core.enums.AuctionOrderDirection;
import com.galarzaa.tibiakt.core.enums.AuctionSearchType;
import com.galarzaa.tibiakt.core.enums.AuctionSkillFilter;
import com.galarzaa.tibiakt.core.enums.AuctionVocationFilter;
import com.galarzaa.tibiakt.core.enums.BazaarType;
import com.galarzaa.tibiakt.core.enums.IntEnum;
import com.galarzaa.tibiakt.core.enums.PvpType;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.bazaar.CharacterBazaar;
import com.galarzaa.tibiakt.core.parsers.AuctionParser;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/CharacterBazaarParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/bazaar/CharacterBazaar;", "<init>", "()V", "fromContent", "content", "", "parseAuctionFilters", "", "Lcom/galarzaa/tibiakt/core/builders/CharacterBazaarBuilder;", "filtersTable", "Lorg/jsoup/nodes/Element;", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nCharacterBazaarParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterBazaarParser.kt\ncom/galarzaa/tibiakt/core/parsers/CharacterBazaarParser\n+ 2 CharacterBazaarBuilder.kt\ncom/galarzaa/tibiakt/core/builders/CharacterBazaarBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 BazaarFiltersBuilder.kt\ncom/galarzaa/tibiakt/core/builders/BazaarFiltersBuilderKt\n+ 6 IntEnum.kt\ncom/galarzaa/tibiakt/core/enums/IntEnum$Companion\n*L\n1#1,97:1\n27#2,5:98\n1#3:103\n1#3:114\n1#3:116\n1#3:118\n1#3:120\n1#3:122\n1#3:124\n1863#4,2:104\n1863#4,2:106\n31#5,5:108\n33#6:113\n33#6:115\n33#6:117\n33#6:119\n33#6:121\n33#6:123\n*S KotlinDebug\n*F\n+ 1 CharacterBazaarParser.kt\ncom/galarzaa/tibiakt/core/parsers/CharacterBazaarParser\n*L\n48#1:98,5\n79#1:114\n80#1:116\n81#1:118\n82#1:120\n83#1:122\n92#1:124\n51#1:104,2\n57#1:106,2\n76#1:108,5\n79#1:113\n80#1:115\n81#1:117\n82#1:119\n83#1:121\n92#1:123\n*E\n"})
public final class CharacterBazaarParser
implements Parser<CharacterBazaar> {
    @NotNull
    public static final CharacterBazaarParser INSTANCE = new CharacterBazaarParser();

    private CharacterBazaarParser() {
    }

    @Override
    @NotNull
    public CharacterBazaar fromContent(@NotNull String content) {
        CharacterBazaarBuilder characterBazaarBuilder;
        block5: {
            Element paginationBlock;
            Object object;
            Element it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Element element;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Document document = Jsoup.parse((String)content);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            Document document2 = document;
            Map<String, Element> tables = ElementsKt.parseTablesMap((Element)document2, "table.Table3");
            boolean $i$f$characterBazaar = false;
            boolean $i$f$characterBazaarBuilder = false;
            CharacterBazaarBuilder $this$fromContent_u24lambda_u248 = characterBazaarBuilder = new CharacterBazaarBuilder();
            boolean bl = false;
            Element element2 = tables.get("Filter Auctions");
            if (element2 != null) {
                Element $this$fromContent_u24lambda_u248_u24lambda_u240 = element = element2;
                boolean bl2 = false;
                INSTANCE.parseAuctionFilters($this$fromContent_u24lambda_u248, $this$fromContent_u24lambda_u248_u24lambda_u240);
            }
            Element element3 = tables.get("Current Auctions");
            if (element3 != null) {
                Element $this$fromContent_u24lambda_u248_u24lambda_u243 = element = element3;
                boolean bl3 = false;
                Elements elements = $this$fromContent_u24lambda_u248_u24lambda_u243.select("div.Auction");
                Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
                $this$forEach$iv = (Iterable)elements;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Element)element$iv;
                    boolean bl4 = false;
                    $this$fromContent_u24lambda_u248.auction((Function1<? super AuctionBuilder, Unit>)((Function1)arg_0 -> CharacterBazaarParser.fromContent$lambda$8$lambda$3$lambda$2$lambda$1(it, arg_0)));
                }
                $this$fromContent_u24lambda_u248.setType(BazaarType.CURRENT);
            }
            Element element4 = tables.get("Auction History");
            if (element4 != null) {
                Element $this$fromContent_u24lambda_u248_u24lambda_u246 = element = element4;
                boolean bl5 = false;
                Elements elements = $this$fromContent_u24lambda_u248_u24lambda_u246.select("div.Auction");
                Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
                $this$forEach$iv = (Iterable)elements;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Element)element$iv;
                    boolean bl6 = false;
                    $this$fromContent_u24lambda_u248.auction((Function1<? super AuctionBuilder, Unit>)((Function1)arg_0 -> CharacterBazaarParser.fromContent$lambda$8$lambda$6$lambda$5$lambda$4(it, arg_0)));
                }
                $this$fromContent_u24lambda_u248.setType(BazaarType.HISTORY);
            }
            if ((object = (paginationBlock = document2.selectFirst("td.PageNavigation"))) == null || (object = ElementsKt.parsePagination((Element)object)) == null) break block5;
            Object it2 = object;
            boolean bl7 = false;
            $this$fromContent_u24lambda_u248.setTotalPages(((PaginationData)it2).getTotalPages());
            $this$fromContent_u24lambda_u248.setCurrentPage(((PaginationData)it2).getCurrentPage());
            $this$fromContent_u24lambda_u248.setResultsCount(((PaginationData)it2).getResultsCount());
        }
        return characterBazaarBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final void parseAuctionFilters(CharacterBazaarBuilder $this$parseAuctionFilters, Element filtersTable) {
        Object object;
        Object value$iv;
        int n;
        void var12_13;
        void $this$parseAuctionFilters_u24lambda_u249;
        CharacterBazaarBuilder characterBazaarBuilder;
        BazaarFiltersBuilder bazaarFiltersBuilder;
        Object searchData;
        Elements forms;
        block24: {
            Object object2;
            IntEnum.Companion this_$iv;
            boolean bl;
            Object it$iv;
            Object object3;
            int n2;
            Object it$iv2;
            Object object4;
            boolean $i$f$fromValue;
            block23: {
                Object object5;
                block22: {
                    Object object6;
                    block21: {
                        Enum enum_;
                        block20: {
                            Elements elements = filtersTable.select("form");
                            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
                            forms = elements;
                            Object object7 = forms.first();
                            if (object7 == null || (object7 = ElementsKt.formData((Element)object7)) == null) {
                                throw new ParsingException("could not find search form", null, 2, null);
                            }
                            searchData = object7;
                            boolean $i$f$bazaarFilters = false;
                            boolean $i$f$bazaarFiltersBuilder = false;
                            BazaarFiltersBuilder bazaarFiltersBuilder2 = bazaarFiltersBuilder = new BazaarFiltersBuilder();
                            characterBazaarBuilder = $this$parseAuctionFilters;
                            boolean bl2 = false;
                            $this$parseAuctionFilters_u24lambda_u249.setWorld(((FormData)searchData).getValues().get("filter_world"));
                            String string = ((FormData)searchData).getValues().get("filter_worldpvptype");
                            $this$parseAuctionFilters_u24lambda_u249.setPvpType(PvpType.Companion.fromHighscoresFilterValue(string != null ? Integer.valueOf(Integer.parseInt(string)) : null));
                            IntEnum.Companion companion = IntEnum.Companion;
                            String string2 = ((FormData)searchData).getValues().get("filter_worldbattleyestate");
                            var12_13 = $this$parseAuctionFilters_u24lambda_u249;
                            $i$f$fromValue = false;
                            it$iv2 = object4 = AuctionBattlEyeFilter.class;
                            boolean bl32 = false;
                            Object object8 = ((Class)it$iv2).isEnum() ? object4 : null;
                            if (object8 != null && (object8 = (Enum[])object8.getEnumConstants()) != null) {
                                Enum[] bl32 = object8;
                                n = bl32.length;
                                for (n2 = 0; n2 < n; ++n2) {
                                    it$iv = object3 = bl32[n2];
                                    bl = false;
                                    if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)it$iv).getValue()), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv).name(), (Object)value$iv))) continue;
                                    enum_ = object3;
                                    break block20;
                                }
                                enum_ = null;
                            } else {
                                enum_ = null;
                            }
                        }
                        var12_13.setBattlEyeType((AuctionBattlEyeFilter)enum_);
                        this_$iv = IntEnum.Companion;
                        value$iv = ((FormData)searchData).getValues().get("filter_profession");
                        var12_13 = $this$parseAuctionFilters_u24lambda_u249;
                        $i$f$fromValue = false;
                        it$iv2 = object4 = AuctionVocationFilter.class;
                        boolean bl42 = false;
                        Object object9 = ((Class)it$iv2).isEnum() ? object4 : null;
                        if (object9 != null && (object9 = (Enum[])((Class)object9).getEnumConstants()) != null) {
                            Object bl42 = object9;
                            n = ((Object)bl42).length;
                            for (n2 = 0; n2 < n; ++n2) {
                                it$iv = object3 = bl42[n2];
                                bl = false;
                                if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)it$iv).getValue()), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv).name(), (Object)value$iv))) continue;
                                object6 = object3;
                                break block21;
                            }
                            object6 = null;
                        } else {
                            object6 = null;
                        }
                    }
                    var12_13.setVocation((AuctionVocationFilter)object6);
                    this_$iv = IntEnum.Companion;
                    value$iv = ((FormData)searchData).getValues().get("filter_skillid");
                    var12_13 = $this$parseAuctionFilters_u24lambda_u249;
                    $i$f$fromValue = false;
                    it$iv2 = object4 = AuctionSkillFilter.class;
                    boolean bl52 = false;
                    Object object10 = ((Class)it$iv2).isEnum() ? object4 : null;
                    if (object10 != null && (object10 = (Enum[])object10.getEnumConstants()) != null) {
                        Enum[] bl52 = object10;
                        n = bl52.length;
                        for (n2 = 0; n2 < n; ++n2) {
                            it$iv = object3 = bl52[n2];
                            bl = false;
                            if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)it$iv).getValue()), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv).name(), (Object)value$iv))) continue;
                            object5 = object3;
                            break block22;
                        }
                        object5 = null;
                    } else {
                        object5 = null;
                    }
                }
                var12_13.setSkill((AuctionSkillFilter)object5);
                this_$iv = IntEnum.Companion;
                value$iv = ((FormData)searchData).getValues().get("order_column");
                var12_13 = $this$parseAuctionFilters_u24lambda_u249;
                $i$f$fromValue = false;
                it$iv2 = object4 = AuctionOrderBy.class;
                boolean bl62 = false;
                Object object11 = ((Class)it$iv2).isEnum() ? object4 : null;
                if (object11 != null && (object11 = (Enum[])object11.getEnumConstants()) != null) {
                    Enum[] bl62 = object11;
                    n = bl62.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        it$iv = object3 = bl62[n2];
                        bl = false;
                        if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)it$iv).getValue()), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv).name(), (Object)value$iv))) continue;
                        object2 = object3;
                        break block23;
                    }
                    object2 = null;
                } else {
                    object2 = null;
                }
            }
            var12_13.setOrderBy((AuctionOrderBy)object2);
            this_$iv = IntEnum.Companion;
            value$iv = ((FormData)searchData).getValues().get("order_direction");
            var12_13 = $this$parseAuctionFilters_u24lambda_u249;
            $i$f$fromValue = false;
            it$iv2 = object4 = AuctionOrderDirection.class;
            boolean bl72 = false;
            Object object12 = ((Class)it$iv2).isEnum() ? object4 : null;
            if (object12 != null && (object12 = (Enum[])object12.getEnumConstants()) != null) {
                Enum[] bl72 = object12;
                n = bl72.length;
                for (n2 = 0; n2 < n; ++n2) {
                    it$iv = object3 = bl72[n2];
                    bl = false;
                    if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)it$iv).getValue()), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv).name(), (Object)value$iv))) continue;
                    object = object3;
                    break block24;
                }
                object = null;
            } else {
                object = null;
            }
        }
        var12_13.setOrderDirection((AuctionOrderDirection)object);
        String string = ((FormData)searchData).getValues().get("filter_levelrangefrom");
        $this$parseAuctionFilters_u24lambda_u249.setMinimumLevel(string != null && (string = StringExtensionsKt.nullIfBlank(string)) != null ? Integer.valueOf(StringExtensionsKt.parseInteger(string)) : null);
        String string3 = ((FormData)searchData).getValues().get("filter_levelrangeto");
        $this$parseAuctionFilters_u24lambda_u249.setMaximumLevel(string3 != null && (string3 = StringExtensionsKt.nullIfBlank(string3)) != null ? Integer.valueOf(StringExtensionsKt.parseInteger(string3)) : null);
        String string4 = ((FormData)searchData).getValues().get("filter_skillrangefrom");
        $this$parseAuctionFilters_u24lambda_u249.setMinimumSkillLevel(string4 != null && (string4 = StringExtensionsKt.nullIfBlank(string4)) != null ? Integer.valueOf(StringExtensionsKt.parseInteger(string4)) : null);
        String string5 = ((FormData)searchData).getValues().get("filter_skillrangeto");
        $this$parseAuctionFilters_u24lambda_u249.setMaximumSkillLevel(string5 != null && (string5 = StringExtensionsKt.nullIfBlank(string5)) != null ? Integer.valueOf(StringExtensionsKt.parseInteger(string5)) : null);
        if (forms.size() > 1) {
            Enum enum_;
            block25: {
                Enum[] enumArray;
                Object object13 = forms.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"get(...)");
                FormData additionalData = ElementsKt.formData((Element)object13);
                String string6 = additionalData.getValues().get("searchstring");
                $this$parseAuctionFilters_u24lambda_u249.setSearchString(string6 != null ? StringExtensionsKt.nullIfBlank(string6) : null);
                value$iv = IntEnum.Companion;
                String $i$f$fromValue = additionalData.getValues().get("searchtype");
                var12_13 = $this$parseAuctionFilters_u24lambda_u249;
                boolean $i$f$fromValue2 = false;
                Enum[] it$iv = enumArray = AuctionSearchType.class;
                boolean bl = false;
                Object object14 = it$iv.isEnum() ? enumArray : null;
                if (object14 != null && (object14 = (Enum[])object14.getEnumConstants()) != null) {
                    Enum[] enumArray2 = object14;
                    int n3 = enumArray2.length;
                    for (n = 0; n < n3; ++n) {
                        void value$iv2;
                        Enum enum_2;
                        Enum it$iv3 = enum_2 = enumArray2[n];
                        boolean bl8 = false;
                        if (!(Intrinsics.areEqual((Object)String.valueOf(((IntEnum)((Object)it$iv3)).getValue()), (Object)value$iv2) || Intrinsics.areEqual((Object)it$iv3.name(), (Object)value$iv2))) continue;
                        enum_ = enum_2;
                        break block25;
                    }
                    enum_ = null;
                } else {
                    enum_ = null;
                }
            }
            var12_13.setSearchType((AuctionSearchType)enum_);
        }
        characterBazaarBuilder.setFilters(bazaarFiltersBuilder.build());
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final Unit fromContent$lambda$8$lambda$3$lambda$2$lambda$1(Element $it, AuctionBuilder $this$auction) {
        Intrinsics.checkNotNullParameter((Object)$this$auction, (String)"$this$auction");
        Intrinsics.checkNotNull((Object)$it);
        AuctionParser.INSTANCE.parseAuctionContainer$tibiakt_core($this$auction, $it);
        return Unit.INSTANCE;
    }

    private static final Unit fromContent$lambda$8$lambda$6$lambda$5$lambda$4(Element $it, AuctionBuilder $this$auction) {
        Intrinsics.checkNotNullParameter((Object)$this$auction, (String)"$this$auction");
        Intrinsics.checkNotNull((Object)$it);
        AuctionParser.INSTANCE.parseAuctionContainer$tibiakt_core($this$auction, $it);
        return Unit.INSTANCE;
    }
}

