/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.CMPostArchiveBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.forums.CMPost;
import com.galarzaa.tibiakt.core.models.forums.CMPostArchive;
import com.galarzaa.tibiakt.core.parsers.HouseParser;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.FormData;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\t*\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/CMPostArchiveParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/forums/CMPostArchive;", "<init>", "()V", "fromContent", "content", "", "parseSearchTable", "", "Lcom/galarzaa/tibiakt/core/builders/CMPostArchiveBuilder;", "form", "Lorg/jsoup/nodes/Element;", "parsePostList", "table", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nCMPostArchiveParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMPostArchiveParser.kt\ncom/galarzaa/tibiakt/core/parsers/CMPostArchiveParser\n+ 2 CMPostArchiveBuilder.kt\ncom/galarzaa/tibiakt/core/builders/CMPostArchiveBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n26#2:84\n1#3:85\n*S KotlinDebug\n*F\n+ 1 CMPostArchiveParser.kt\ncom/galarzaa/tibiakt/core/parsers/CMPostArchiveParser\n*L\n43#1:84\n*E\n"})
public final class CMPostArchiveParser
implements Parser<CMPostArchive> {
    @NotNull
    public static final CMPostArchiveParser INSTANCE = new CMPostArchiveParser();

    private CMPostArchiveParser() {
    }

    @Override
    @NotNull
    public CMPostArchive fromContent(@NotNull String content) {
        CMPostArchiveBuilder cMPostArchiveBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Element boxContent = Parser.DefaultImpls.boxContent$default(HouseParser.INSTANCE, content, null, 2, null);
        Map tables = ElementsKt.parseTablesMap$default(boxContent, null, 1, null);
        boolean $i$f$cmPostArchive = false;
        CMPostArchiveBuilder $this$fromContent_u24lambda_u241 = cMPostArchiveBuilder = new CMPostArchiveBuilder();
        boolean bl = false;
        Element element = boxContent.selectFirst("form");
        if (element == null) {
            throw new ParsingException("Could not find search form.", null, 2, null);
        }
        Element form = element;
        Element element2 = (Element)tables.get("CM Post List");
        if (element2 != null) {
            Element it = element2;
            boolean bl2 = false;
            INSTANCE.parsePostList($this$fromContent_u24lambda_u241, it);
        }
        INSTANCE.parseSearchTable($this$fromContent_u24lambda_u241, form);
        Object object = boxContent.selectFirst("small");
        if (object == null || (object = ElementsKt.parsePagination((Element)object)) == null) {
            object = PaginationData.Companion.default();
        }
        Object paginationData = object;
        $this$fromContent_u24lambda_u241.setCurrentPage(((PaginationData)paginationData).getCurrentPage());
        $this$fromContent_u24lambda_u241.setTotalPages(((PaginationData)paginationData).getTotalPages());
        $this$fromContent_u24lambda_u241.setResultsCount(((PaginationData)paginationData).getResultsCount());
        return cMPostArchiveBuilder.build();
    }

    private final void parseSearchTable(CMPostArchiveBuilder $this$parseSearchTable, Element form) {
        FormData formData = ElementsKt.formData(form);
        String string = formData.getValues().get("startyear");
        if (string == null) {
            throw new ParsingException("could not find startyear param", null, 2, null);
        }
        String string2 = formData.getValues().get("startmonth");
        if (string2 == null) {
            throw new ParsingException("could not find startmonth param", null, 2, null);
        }
        String string3 = formData.getValues().get("startday");
        if (string3 == null) {
            throw new ParsingException("could not find startday param", null, 2, null);
        }
        $this$parseSearchTable.setStartDate(LocalDate.of(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3)));
        String string4 = formData.getValues().get("endyear");
        if (string4 == null) {
            throw new ParsingException("could not find endyear param", null, 2, null);
        }
        String string5 = formData.getValues().get("endmonth");
        if (string5 == null) {
            throw new ParsingException("could not find endmonth param", null, 2, null);
        }
        String string6 = formData.getValues().get("endday");
        if (string6 == null) {
            throw new ParsingException("could not find endday param", null, 2, null);
        }
        $this$parseSearchTable.setEndDate(LocalDate.of(Integer.parseInt(string4), Integer.parseInt(string5), Integer.parseInt(string6)));
    }

    private final void parsePostList(CMPostArchiveBuilder $this$parsePostList, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table), 1)) {
            String dateText;
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            Elements columns = ElementsKt.cells(row);
            Intrinsics.checkNotNullExpressionValue((Object)((Element)columns.get(0)).text(), (String)"text(...)");
            Instant date = DatesKt.parseTibiaDateTime(dateText);
            Object object = columns.get(1);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String[] stringArray = new String[]{"\n"};
            List list = StringsKt.split$default((CharSequence)ElementsKt.wholeCleanText(ElementsKt.replaceBrs((Element)object)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String forum = (String)list.get(0);
            String thread = (String)list.get(1);
            Object object2 = ((Element)columns.get(2)).selectFirst("a");
            if (object2 == null || (object2 = ElementsKt.getLinkInformation((Element)object2)) == null) {
                throw new ParsingException("could not find post link", null, 2, null);
            }
            Object postLink = object2;
            List<String> list2 = ((LinkInformation)postLink).getQueryParams().get("postid");
            if (list2 == null || (list2 = list2.get(0)) == null) {
                throw new ParsingException("could not find postid in link", null, 2, null);
            }
            int postId = Integer.parseInt((String)((Object)list2));
            $this$parsePostList.addEntry(new CMPost(postId, date, forum, thread));
        }
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }
}

