/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.BoostableBossesBuilder;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.creatures.BoostableBosses;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/BoostableBossesParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/creatures/BoostableBosses;", "<init>", "()V", "fromContent", "content", "", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nBoostableBossesParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoostableBossesParser.kt\ncom/galarzaa/tibiakt/core/parsers/BoostableBossesParser\n+ 2 BoostableBossesBuilder.kt\ncom/galarzaa/tibiakt/core/builders/BoostableBossesBuilderKt\n*L\n1#1,61:1\n25#2:62\n*S KotlinDebug\n*F\n+ 1 BoostableBossesParser.kt\ncom/galarzaa/tibiakt/core/parsers/BoostableBossesParser\n*L\n33#1:62\n*E\n"})
public final class BoostableBossesParser
implements Parser<BoostableBosses> {
    @NotNull
    public static final BoostableBossesParser INSTANCE = new BoostableBossesParser();

    private BoostableBossesParser() {
    }

    @Override
    @NotNull
    public BoostableBosses fromContent(@NotNull String content) {
        BoostableBossesBuilder $this$fromContent_u24lambda_u243;
        BoostableBossesBuilder boostableBossesBuilder;
        Element boxContent;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                boxContent = Parser.DefaultImpls.boxContent$default(this, content, null, 2, null);
                Map<String, Element> tables = ElementsKt.parseTablesMap(boxContent, "table.Table1");
                boolean $i$f$boostableBosses = false;
                $this$fromContent_u24lambda_u243 = boostableBossesBuilder = new BoostableBossesBuilder();
                boolean bl = false;
                Object object = tables.get("Boosted Boss");
                if (object == null) break block7;
                Element it = object;
                boolean bl2 = false;
                Object object2 = it.selectFirst("img");
                if (object2 == null || (object2 = object2.attr("src")) == null) {
                    throw new ParsingException("boosted boss image not found", null, 2, null);
                }
                Object boostedCreatureImageUrl = object2;
                String string = new File(new URL((String)boostedCreatureImageUrl).getPath()).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String fileName = StringExtensionsKt.remove$default(string, ".gif", false, 2, null);
                BoostableBossesBuilder boostableBossesBuilder2 = $this$fromContent_u24lambda_u243.boostedBoss((Function1<? super BoostableBossesBuilder.BossEntryBuilder, Unit>)((Function1)arg_0 -> BoostableBossesParser.fromContent$lambda$3$lambda$1$lambda$0(it, fileName, arg_0)));
                object = boostableBossesBuilder2;
                if (boostableBossesBuilder2 != null) break block8;
            }
            throw new ParsingException("Boosted boss table not found.", null, 2, null);
        }
        Element element = boxContent.selectFirst("div[style*=display: table]");
        if (element == null) {
            throw new ParsingException("could not find creatures list container", null, 2, null);
        }
        Element entriesTable = element;
        Elements elements = entriesTable.select("div[style*=float: left]");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements entryContainers = elements;
        Iterator iterator = entryContainers.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element entryContainer = (Element)e;
            Object object = entryContainer.selectFirst("img");
            if (object == null || (object = object.attr("src")) == null) {
                throw new ParsingException("boss image not found", null, 2, null);
            }
            Object imageUrl = object;
            String string = new File(new URL((String)imageUrl).getPath()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = StringExtensionsKt.remove$default(string, ".gif", false, 2, null);
            $this$fromContent_u24lambda_u243.addCreature((Function1<? super BoostableBossesBuilder.BossEntryBuilder, Unit>)((Function1)arg_0 -> BoostableBossesParser.fromContent$lambda$3$lambda$2(entryContainer, fileName, arg_0)));
        }
        return boostableBossesBuilder.build();
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final Unit fromContent$lambda$3$lambda$1$lambda$0(Element $it, String $fileName, BoostableBossesBuilder.BossEntryBuilder $this$boostedBoss) {
        Intrinsics.checkNotNullParameter((Object)$this$boostedBoss, (String)"$this$boostedBoss");
        Object object = $it.selectFirst("p");
        if (object == null || (object = ElementsKt.cleanText(object)) == null || (object = StringsKt.substringAfter$default((String)object, (String)"Today's boosted boss: ", null, (int)2, null)) == null) {
            throw new ParsingException("Boss title not found", null, 2, null);
        }
        $this$boostedBoss.setName((String)object);
        $this$boostedBoss.setIdentifier($fileName);
        return Unit.INSTANCE;
    }

    private static final Unit fromContent$lambda$3$lambda$2(Element $entryContainer, String $fileName, BoostableBossesBuilder.BossEntryBuilder $this$addCreature) {
        Intrinsics.checkNotNullParameter((Object)$this$addCreature, (String)"$this$addCreature");
        $this$addCreature.setName(ElementsKt.cleanText($entryContainer));
        $this$addCreature.setIdentifier($fileName);
        return Unit.INSTANCE;
    }
}

