/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.parsers;

import com.galarzaa.tibiakt.core.builders.AuctionBuilder;
import com.galarzaa.tibiakt.core.enums.AuctionStatus;
import com.galarzaa.tibiakt.core.enums.BidType;
import com.galarzaa.tibiakt.core.enums.Sex;
import com.galarzaa.tibiakt.core.enums.StringEnum;
import com.galarzaa.tibiakt.core.enums.Vocation;
import com.galarzaa.tibiakt.core.exceptions.ParsingException;
import com.galarzaa.tibiakt.core.models.bazaar.AchievementEntry;
import com.galarzaa.tibiakt.core.models.bazaar.Auction;
import com.galarzaa.tibiakt.core.models.bazaar.AuctionSkills;
import com.galarzaa.tibiakt.core.models.bazaar.BlessingEntry;
import com.galarzaa.tibiakt.core.models.bazaar.CharmEntry;
import com.galarzaa.tibiakt.core.models.bazaar.CreatureEntry;
import com.galarzaa.tibiakt.core.models.bazaar.FamiliarEntry;
import com.galarzaa.tibiakt.core.models.bazaar.Familiars;
import com.galarzaa.tibiakt.core.models.bazaar.ItemEntry;
import com.galarzaa.tibiakt.core.models.bazaar.ItemSummary;
import com.galarzaa.tibiakt.core.models.bazaar.MountEntry;
import com.galarzaa.tibiakt.core.models.bazaar.Mounts;
import com.galarzaa.tibiakt.core.models.bazaar.OutfitEntry;
import com.galarzaa.tibiakt.core.models.bazaar.OutfitImage;
import com.galarzaa.tibiakt.core.models.bazaar.Outfits;
import com.galarzaa.tibiakt.core.models.bazaar.RevealedGem;
import com.galarzaa.tibiakt.core.models.bazaar.RevealedGemMod;
import com.galarzaa.tibiakt.core.parsers.Parser;
import com.galarzaa.tibiakt.core.utils.DatesKt;
import com.galarzaa.tibiakt.core.utils.ElementsKt;
import com.galarzaa.tibiakt.core.utils.LinkInformation;
import com.galarzaa.tibiakt.core.utils.ListExtensionsKt;
import com.galarzaa.tibiakt.core.utils.PaginationData;
import com.galarzaa.tibiakt.core.utils.StringExtensionsKt;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\bH\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001d\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u0016H\u0002J\u0014\u0010\u001f\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010 \u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001bH\u0002J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0.2\u0006\u0010/\u001a\u00020\u001bH\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010/\u001a\u00020\u001bH\u0002J\u0014\u00102\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0019\u00103\u001a\u00020\u0018*\u0002042\u0006\u00105\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b6J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\u001bH\u0001J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001bH\u0001J\u0010\u0010=\u001a\u00020>2\u0006\u0010<\u001a\u00020\u001bH\u0001J\u001f\u0010?\u001a\b\u0012\u0004\u0012\u0002H@0\"\"\u0006\b\u0000\u0010@\u0018\u00012\u0006\u0010\u0012\u001a\u00020\bH\u0086\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/galarzaa/tibiakt/core/parsers/AuctionParser;", "Lcom/galarzaa/tibiakt/core/parsers/Parser;", "Lcom/galarzaa/tibiakt/core/models/bazaar/Auction;", "<init>", "()V", "PERCENTAGE", "", "ICON_CSS_SELECTOR", "", "getICON_CSS_SELECTOR$annotations", "PAGINATOR_SELECTOR", "charInfoRegex", "Lkotlin/text/Regex;", "idAddonsRegex", "amountRegex", "tierRegex", "idRegex", "fromContent", "content", "auctionId", "", "parseDetails", "", "parseCharmsTable", "", "Lcom/galarzaa/tibiakt/core/builders/AuctionBuilder$AuctionDetailsBuilder;", "table", "Lorg/jsoup/nodes/Element;", "parseAchievementsTable", "parseBestiaryTable", "bosstiary", "parseRevealedGemsTable", "parseBlessingsTable", "parseSingleColumnTable", "", "parseFamiliarsTable", "Lcom/galarzaa/tibiakt/core/models/bazaar/Familiars;", "parseOutfitsTable", "Lcom/galarzaa/tibiakt/core/models/bazaar/Outfits;", "parseMountsTable", "Lcom/galarzaa/tibiakt/core/models/bazaar/Mounts;", "mountsTable", "parseItemsTable", "Lcom/galarzaa/tibiakt/core/models/bazaar/ItemSummary;", "itemsTable", "getAuctionTableFieldValue", "Lkotlin/Pair;", "row", "parseSkillValue", "", "parseGeneralTable", "parseAuctionContainer", "Lcom/galarzaa/tibiakt/core/builders/AuctionBuilder;", "auctionContainer", "parseAuctionContainer$tibiakt_core", "parseDisplayedItem", "Lcom/galarzaa/tibiakt/core/models/bazaar/ItemEntry;", "displayItemContainer", "parseDisplayedOutfit", "Lcom/galarzaa/tibiakt/core/models/bazaar/OutfitEntry;", "container", "parseDisplayedMount", "Lcom/galarzaa/tibiakt/core/models/bazaar/MountEntry;", "parsePageItems", "T", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nAuctionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuctionParser.kt\ncom/galarzaa/tibiakt/core/parsers/AuctionParser\n+ 2 AuctionBuilder.kt\ncom/galarzaa/tibiakt/core/builders/AuctionBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 StringEnum.kt\ncom/galarzaa/tibiakt/core/enums/StringEnum$Companion\n*L\n1#1,463:1\n42#2:464\n1#3:465\n1#3:485\n1#3:487\n1#3:497\n1#3:499\n1#3:510\n1#3:523\n1#3:536\n1557#4:466\n1628#4,3:467\n1557#4:470\n1628#4,3:471\n1557#4:474\n1628#4,3:475\n1863#4:478\n1557#4:479\n1628#4,3:480\n1864#4:483\n1863#4,2:488\n1863#4,2:490\n1557#4:492\n1628#4,3:493\n1611#4,9:500\n1863#4:509\n1864#4:511\n1620#4:512\n1611#4,9:513\n1863#4:522\n1864#4:524\n1620#4:525\n1611#4,9:526\n1863#4:535\n1864#4:537\n1620#4:538\n1863#4,2:539\n1863#4,2:541\n1863#4,2:543\n1863#4,2:545\n33#5:484\n33#5:486\n33#5:496\n33#5:498\n*S KotlinDebug\n*F\n+ 1 AuctionParser.kt\ncom/galarzaa/tibiakt/core/parsers/AuctionParser\n*L\n86#1:464\n363#1:485\n366#1:487\n400#1:497\n403#1:499\n456#1:510\n457#1:523\n458#1:536\n152#1:466\n152#1:467,3\n213#1:470\n213#1:471,3\n233#1:474\n233#1:475,3\n276#1:478\n322#1:479\n322#1:480,3\n276#1:483\n374#1:488,2\n380#1:490,2\n391#1:492\n391#1:493,3\n456#1:500,9\n456#1:509\n456#1:511\n456#1:512\n457#1:513,9\n457#1:522\n457#1:524\n457#1:525\n458#1:526,9\n458#1:535\n458#1:537\n458#1:538\n102#1:539,2\n105#1:541,2\n108#1:543,2\n110#1:545,2\n363#1:484\n366#1:486\n400#1:496\n403#1:498\n*E\n"})
public final class AuctionParser
implements Parser<Auction> {
    @NotNull
    public static final AuctionParser INSTANCE = new AuctionParser();
    private static final float PERCENTAGE = 100.0f;
    @NotNull
    public static final String ICON_CSS_SELECTOR = "div.CVIcon";
    @NotNull
    public static final String PAGINATOR_SELECTOR = "div.BlockPageNavigationRow";
    @NotNull
    private static final Regex charInfoRegex = new Regex("Level: (\\d+) \\| Vocation: ([\\w\\s]+)\\| (\\w+) \\| World: (\\w+)");
    @NotNull
    private static final Regex idAddonsRegex = new Regex("/(\\d+)_(\\d+)");
    @NotNull
    private static final Regex amountRegex = new Regex("([\\d,]+)x ");
    @NotNull
    private static final Regex tierRegex = new Regex("(.*)\\s\\(tier (\\d)\\)");
    @NotNull
    private static final Regex idRegex = new Regex("(\\d+).(?:gif|png)");

    private AuctionParser() {
    }

    @PublishedApi
    public static /* synthetic */ void getICON_CSS_SELECTOR$annotations() {
    }

    @Override
    @Nullable
    public Auction fromContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return this.fromContent(content, 0, true);
    }

    @Nullable
    public final Auction fromContent(@NotNull String content, int auctionId, boolean parseDetails) {
        AuctionBuilder auctionBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Document document = Jsoup.parse((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        boolean $i$f$auction = false;
        AuctionBuilder $this$fromContent_u24lambda_u2424 = auctionBuilder = new AuctionBuilder();
        boolean bl = false;
        $this$fromContent_u24lambda_u2424.setAuctionId(auctionId);
        Element element = document2.selectFirst("div.Auction");
        if (element == null) {
            return null;
        }
        Element it = element;
        boolean bl2 = false;
        INSTANCE.parseAuctionContainer$tibiakt_core($this$fromContent_u24lambda_u2424, it);
        Map<String, Element> detailsTables = ElementsKt.parseTablesMap((Element)document2, "table.Table3, table.Table5");
        if (parseDetails) {
            $this$fromContent_u24lambda_u2424.details((Function1<? super AuctionBuilder.AuctionDetailsBuilder, Unit>)((Function1)arg_0 -> AuctionParser.fromContent$lambda$24$lambda$23(detailsTables, arg_0)));
        }
        return auctionBuilder.build();
    }

    public static /* synthetic */ Auction fromContent$default(AuctionParser auctionParser, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return auctionParser.fromContent(string, n, bl);
    }

    private final void parseCharmsTable(AuctionBuilder.AuctionDetailsBuilder $this$parseCharmsTable, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table.selectFirst("table.TableContent")), 1)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            List<String> colsText = ElementsKt.cellsText(row);
            if (colsText.size() != 2) continue;
            String cost = colsText.get(0);
            String name = colsText.get(1);
            $this$parseCharmsTable.addCharm(new CharmEntry(name, StringExtensionsKt.parseInteger(cost)));
        }
    }

    private final void parseAchievementsTable(AuctionBuilder.AuctionDetailsBuilder $this$parseAchievementsTable, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table.selectFirst("table.TableContent")), 1)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            String text = ElementsKt.cleanText(row);
            if (StringsKt.contains$default((CharSequence)text, (CharSequence)"more entries", (boolean)false, (int)2, null)) continue;
            boolean isSecret = row.selectFirst("img") != null;
            $this$parseAchievementsTable.addAchievement(new AchievementEntry(text, isSecret));
        }
    }

    private final void parseBestiaryTable(AuctionBuilder.AuctionDetailsBuilder $this$parseBestiaryTable, Element table, boolean bosstiary) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table.selectFirst("table.TableContent")), 1)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            List<String> columnsText = ElementsKt.cellsText(row);
            if (columnsText.size() != 3) continue;
            String step = columnsText.get(0);
            String kills = columnsText.get(1);
            String name = columnsText.get(2);
            CreatureEntry entry = new CreatureEntry(name, StringExtensionsKt.parseLong(StringExtensionsKt.remove$default(kills, "x", false, 2, null)), Integer.parseInt(step));
            AuctionBuilder.AuctionDetailsBuilder auctionDetailsBuilder = bosstiary ? $this$parseBestiaryTable.addBosstiaryEntry(entry) : $this$parseBestiaryTable.addBestiaryEntry(entry);
        }
    }

    static /* synthetic */ void parseBestiaryTable$default(AuctionParser auctionParser, AuctionBuilder.AuctionDetailsBuilder auctionDetailsBuilder, Element element, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        auctionParser.parseBestiaryTable(auctionDetailsBuilder, element, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void parseRevealedGemsTable(AuctionBuilder.AuctionDetailsBuilder $this$parseRevealedGemsTable, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table.selectFirst("table.TableContent")), 1)) {
            String gemType;
            void $this$mapTo$iv$iv;
            Elements modSpans;
            Element gemTag;
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            if (row.selectFirst("div.Gem") == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)gemTag.attr("title"), (String)"attr(...)");
            Intrinsics.checkNotNullExpressionValue((Object)row.select("span"), (String)"select(...)");
            Iterable $this$map$iv = (Iterable)modSpans;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String[] stringArray = new String[]{"\n"};
                collection.add(new RevealedGemMod(StringsKt.split$default((CharSequence)ElementsKt.wholeCleanText(ElementsKt.replaceBrs((Element)it)), (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
            }
            List mods = (List)destination$iv$iv;
            $this$parseRevealedGemsTable.addRevealedGem(new RevealedGem(gemType, mods));
        }
    }

    private final void parseBlessingsTable(AuctionBuilder.AuctionDetailsBuilder $this$parseBlessingsTable, Element table) {
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(table.selectFirst("table.TableContent")), 1)) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            List<String> colsText = ElementsKt.cellsText(row);
            if (colsText.size() != 2) continue;
            String amount = colsText.get(0);
            String name = colsText.get(1);
            $this$parseBlessingsTable.addBlessing(new BlessingEntry(name, StringExtensionsKt.parseInteger(StringExtensionsKt.remove$default(amount, "x", false, 2, null))));
        }
    }

    private final List<String> parseSingleColumnTable(Element table) {
        Element innerTable = table.select("table.TableContent").last();
        List values = new ArrayList();
        for (Object t : ListExtensionsKt.offsetStart((List)ElementsKt.rows(innerTable), 1)) {
            String text;
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            Element row = (Element)t;
            Element element = row.selectFirst("td");
            String string = element != null ? ElementsKt.cleanText(element) : null;
            if (string == null) {
                string = "";
            }
            if (StringsKt.contains$default((CharSequence)(text = string), (CharSequence)"more entries", (boolean)false, (int)2, null)) continue;
            values.add(text);
        }
        return values;
    }

    private final Familiars parseFamiliarsTable(Element table) {
        Object object = table.selectFirst(PAGINATOR_SELECTOR);
        if (object == null || (object = ElementsKt.parsePagination((Element)object)) == null) {
            return new Familiars(1, 0, 0, CollectionsKt.emptyList(), false);
        }
        Object paginationData = object;
        Elements elements = table.select(ICON_CSS_SELECTOR);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements familiarBoxes = elements;
        List familiars = new ArrayList();
        Iterator iterator = familiarBoxes.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object2;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element mountBox = (Element)e;
            String string = mountBox.attr("title");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            String[] stringArray = new String[]{"("};
            String name = StringExtensionsKt.clean((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
            Element element = mountBox.selectFirst("img");
            String string2 = element != null ? element.attr("src") : null;
            if (string2 == null) {
                string2 = "";
            }
            if ((object2 = Regex.find$default((Regex)idRegex, (CharSequence)string2, (int)0, (int)2, null)) == null || (object2 = object2.getGroupValues()) == null) {
                throw new ParsingException("familiar image did not match expected pattern", null, 2, null);
            }
            String id = (String)object2.get(1);
            familiars.add(new FamiliarEntry(name, Integer.parseInt(id)));
        }
        return new Familiars(((PaginationData)paginationData).getCurrentPage(), ((PaginationData)paginationData).getTotalPages(), ((PaginationData)paginationData).getResultsCount(), familiars, false);
    }

    /*
     * WARNING - void declaration
     */
    private final Outfits parseOutfitsTable(Element table) {
        void $this$mapTo$iv$iv;
        Object object = table.selectFirst(PAGINATOR_SELECTOR);
        if (object == null || (object = ElementsKt.parsePagination((Element)object)) == null) {
            return new Outfits(1, 0, 0, CollectionsKt.emptyList(), false);
        }
        Object paginationData = object;
        Elements elements = table.select(ICON_CSS_SELECTOR);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements outfitBoxes = elements;
        Iterable $this$map$iv = (Iterable)outfitBoxes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(INSTANCE.parseDisplayedOutfit((Element)it));
        }
        List outfits = (List)destination$iv$iv;
        return new Outfits(((PaginationData)paginationData).getCurrentPage(), ((PaginationData)paginationData).getTotalPages(), ((PaginationData)paginationData).getResultsCount(), outfits, false);
    }

    /*
     * WARNING - void declaration
     */
    private final Mounts parseMountsTable(Element mountsTable) {
        void $this$mapTo$iv$iv;
        Object object = mountsTable.selectFirst(PAGINATOR_SELECTOR);
        if (object == null || (object = ElementsKt.parsePagination((Element)object)) == null) {
            return new Mounts(1, 0, 0, CollectionsKt.emptyList(), false);
        }
        Object paginationData = object;
        Elements elements = mountsTable.select(ICON_CSS_SELECTOR);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements mountsBoxes = elements;
        Iterable $this$map$iv = (Iterable)mountsBoxes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(INSTANCE.parseDisplayedMount((Element)it));
        }
        List mounts = (List)destination$iv$iv;
        return new Mounts(((PaginationData)paginationData).getCurrentPage(), ((PaginationData)paginationData).getTotalPages(), ((PaginationData)paginationData).getResultsCount(), mounts, false);
    }

    private final ItemSummary parseItemsTable(Element itemsTable) {
        Object object = itemsTable.selectFirst(PAGINATOR_SELECTOR);
        if (object == null || (object = ElementsKt.parsePagination((Element)object)) == null) {
            return new ItemSummary(1, 0, 0, CollectionsKt.emptyList(), false);
        }
        Object paginationData = object;
        Elements elements = itemsTable.select(ICON_CSS_SELECTOR);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements itemBoxes = elements;
        List items = new ArrayList();
        Iterator iterator = itemBoxes.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemEntry $this$parseItemsTable_u24lambda_u2428;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element itemBox = (Element)e;
            if (this.parseDisplayedItem(itemBox) == null) continue;
            boolean bl = false;
            items.add($this$parseItemsTable_u24lambda_u2428);
        }
        return new ItemSummary(((PaginationData)paginationData).getCurrentPage(), ((PaginationData)paginationData).getTotalPages(), ((PaginationData)paginationData).getResultsCount(), items, false);
    }

    private final Pair<String, String> getAuctionTableFieldValue(Element row) {
        Object object = row.selectFirst(".LabelV, .LabelColumn");
        if (object == null || (object = ElementsKt.cleanText(object)) == null || (object = StringExtensionsKt.remove$default((String)object, ":", false, 2, null)) == null) {
            throw new ParsingException("could not find field's label", null, 2, null);
        }
        Object field = object;
        Object object2 = row.selectFirst("div");
        if (object2 == null || (object2 = ElementsKt.cleanText(object2)) == null) {
            throw new ParsingException("could not find value's div", null, 2, null);
        }
        Object value = object2;
        return TuplesKt.to((Object)field, (Object)value);
    }

    private final double parseSkillValue(Element row) {
        List<String> list = ElementsKt.cellsText(row);
        String level = list.get(1);
        String progress = list.get(2);
        return (double)StringExtensionsKt.parseInteger(level) + Double.parseDouble(StringExtensionsKt.remove$default(progress, "%", false, 2, null)) / (double)100.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseGeneralTable(AuctionBuilder.AuctionDetailsBuilder $this$parseGeneralTable, Element table) {
        Map skillsMap = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), AuctionParser::parseGeneralTable$lambda$29);
        Elements elements = table.select("table.TableContent");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements contentContainers = elements;
        Iterable $this$forEach$iv = (Iterable)ElementsKt.rows(contentContainers);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element row = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)row);
            Pair<String, String> pair = INSTANCE.getAuctionTableFieldValue(row);
            String field = (String)pair.component1();
            String value = (String)pair.component2();
            switch (field) {
                case "Hit Points": {
                    $this$parseGeneralTable.setHitPoints(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Mana": {
                    $this$parseGeneralTable.setMana(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Capacity": {
                    $this$parseGeneralTable.setCapacity(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Speed": {
                    $this$parseGeneralTable.setSpeed(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Blessings": {
                    String[] stringArray = new String[]{"/"};
                    $this$parseGeneralTable.setBlessingsCount(StringExtensionsKt.parseInteger((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null))));
                    break;
                }
                case "Mounts": {
                    $this$parseGeneralTable.setMountsCount(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Outfits": {
                    $this$parseGeneralTable.setOutfitsCount(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Titles": {
                    $this$parseGeneralTable.setTitlesCount(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Axe Fighting": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Club Fighting": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Sword Fighting": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Distance Fighting": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Fishing": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Magic Level": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Fist Fighting": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Shielding": {
                    skillsMap.put(field, INSTANCE.parseSkillValue(row));
                    break;
                }
                case "Creation Date": {
                    $this$parseGeneralTable.setCreationDate(DatesKt.parseTibiaDateTime(value));
                    break;
                }
                case "Experience": {
                    $this$parseGeneralTable.setExperience(StringExtensionsKt.parseLong(value));
                    break;
                }
                case "Gold": {
                    $this$parseGeneralTable.setGold(StringExtensionsKt.parseLong(value));
                    break;
                }
                case "Achievement Points": {
                    $this$parseGeneralTable.setAchievementPoints(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Regular World Transfer": {
                    if (!StringsKt.contains$default((CharSequence)value, (CharSequence)"after", (boolean)false, (int)2, null)) break;
                    String[] stringArray = new String[]{"after"};
                    $this$parseGeneralTable.setRegularWorldTransfersAvailable(DatesKt.parseTibiaDateTime((String)StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)));
                    break;
                }
                case "Charm Expansion": {
                    $this$parseGeneralTable.setHasCharmExpansion(StringsKt.contains$default((CharSequence)value, (CharSequence)"yes", (boolean)false, (int)2, null));
                    break;
                }
                case "Available Charm Points": {
                    $this$parseGeneralTable.setAvailableCharmPoints(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Spent Charm Points": {
                    $this$parseGeneralTable.setSpentCharmPoints(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Daily Reward Streak": {
                    $this$parseGeneralTable.setDailyRewardStreak(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Hunting Task Points": {
                    $this$parseGeneralTable.setHuntingTaskPoints(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Permanent Hunting Task Slots": {
                    $this$parseGeneralTable.setPermanentHuntingTaskSlots(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Permanent Prey Slots": {
                    $this$parseGeneralTable.setPermanentPreySlots(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Prey Wildcards": {
                    $this$parseGeneralTable.setPreyWildcards(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Hirelings": {
                    $this$parseGeneralTable.setHirelings(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Hireling Jobs": {
                    $this$parseGeneralTable.setHirelingJobs(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Hireling Outfits": {
                    $this$parseGeneralTable.setHirelingOutfits(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Exalted Dust": {
                    void $this$mapTo$iv$iv;
                    AuctionBuilder.AuctionDetailsBuilder $this$parseGeneralTable_u24lambda_u2432_u24lambda_u2431 = $this$parseGeneralTable;
                    boolean bl2 = false;
                    String[] stringArray = new String[]{"/"};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(StringExtensionsKt.parseInteger((String)it));
                    }
                    List list = (List)destination$iv$iv;
                    int current = ((Number)list.get(0)).intValue();
                    int limit = ((Number)list.get(1)).intValue();
                    $this$parseGeneralTable_u24lambda_u2432_u24lambda_u2431.setExaltedDust(current);
                    $this$parseGeneralTable_u24lambda_u2432_u24lambda_u2431.setExaltedDustLimit(limit);
                    break;
                }
                case "Animus Masteries unlocked": {
                    $this$parseGeneralTable.setAnimusMasteriesUnlocked(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Boss Points": {
                    $this$parseGeneralTable.setBossPoints(StringExtensionsKt.parseInteger(value));
                    break;
                }
                case "Bonus Promotion Points": {
                    $this$parseGeneralTable.setBonusPromotionPoints(StringExtensionsKt.parseInteger(value));
                }
            }
        }
        double d = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Axe Fighting")).doubleValue();
        double d2 = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Club Fighting")).doubleValue();
        double d3 = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Sword Fighting")).doubleValue();
        double d4 = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Distance Fighting")).doubleValue();
        double d5 = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Fishing")).doubleValue();
        double d6 = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Magic Level")).doubleValue();
        double d7 = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Fist Fighting")).doubleValue();
        double d8 = ((Number)MapsKt.getValue((Map)skillsMap, (Object)"Shielding")).doubleValue();
        $this$parseGeneralTable.setSkills(new AuctionSkills(d, d2, d4, d5, d7, d6, d8, d3));
    }

    /*
     * WARNING - void declaration
     */
    public final void parseAuctionContainer$tibiakt_core(@NotNull AuctionBuilder $this$parseAuctionContainer, @NotNull Element auctionContainer) {
        Object object;
        Object object2;
        block38: {
            block37: {
                Enum enum_;
                Object object3;
                block36: {
                    Enum[] enumArray;
                    Element bidTag;
                    void $this$mapTo$iv$iv;
                    Element it;
                    Object element$iv2;
                    Object object4;
                    Object it$iv;
                    Object auctionLinkInfo;
                    Element element;
                    Intrinsics.checkNotNullParameter((Object)$this$parseAuctionContainer, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)auctionContainer, (String)"auctionContainer");
                    Element element2 = auctionContainer.selectFirst("div.AuctionHeader");
                    if (element2 == null) {
                        throw new ParsingException("auction header not found", null, 2, null);
                    }
                    Element headerContainer = element2;
                    Object object5 = headerContainer.selectFirst("div.AuctionCharacterName");
                    if (object5 == null || (object5 = ElementsKt.cleanText(object5)) == null) {
                        throw new ParsingException("character name not found", null, 2, null);
                    }
                    $this$parseAuctionContainer.setName((String)object5);
                    Element element3 = headerContainer.selectFirst("div.AuctionCharacterName > a");
                    if (element3 != null) {
                        Element $this$parseAuctionContainer_u24lambda_u2433 = element = element3;
                        boolean bl = false;
                        LinkInformation linkInformation = ElementsKt.getLinkInformation($this$parseAuctionContainer_u24lambda_u2433);
                        Intrinsics.checkNotNull((Object)linkInformation);
                        auctionLinkInfo = linkInformation;
                        List<String> list = ((LinkInformation)auctionLinkInfo).getQueryParams().get("auctionid");
                        if (list == null || (list = (String)CollectionsKt.first(list)) == null) {
                            throw new ParsingException("auctionId not found in link", null, 2, null);
                        }
                        $this$parseAuctionContainer.setAuctionId(Integer.parseInt((String)((Object)list)));
                        $this$parseAuctionContainer_u24lambda_u2433.remove();
                    }
                    MatchResult matchResult = Regex.find$default((Regex)charInfoRegex, (CharSequence)ElementsKt.cleanText(headerContainer), (int)0, (int)2, null);
                    if (matchResult != null) {
                        Object object6;
                        AuctionBuilder auctionBuilder;
                        String worldStr;
                        String sexStr;
                        block34: {
                            Enum enum_2;
                            String value$iv;
                            boolean bl;
                            Object it$iv2;
                            Object object7;
                            int n;
                            int n2;
                            Object object8;
                            boolean $i$f$fromValue;
                            Iterator vocationStr;
                            block33: {
                                MatchResult $this$parseAuctionContainer_u24lambda_u2434 = matchResult;
                                boolean bl2 = false;
                                auctionLinkInfo = $this$parseAuctionContainer_u24lambda_u2434.getGroupValues();
                                String levelStr = (String)auctionLinkInfo.get(1);
                                vocationStr = (String)auctionLinkInfo.get(2);
                                sexStr = (String)auctionLinkInfo.get(3);
                                worldStr = (String)auctionLinkInfo.get(4);
                                $this$parseAuctionContainer.setLevel(Integer.parseInt(levelStr));
                                StringEnum.Companion companion = StringEnum.Companion;
                                String string = ((Object)StringsKt.trim((CharSequence)((CharSequence)((Object)vocationStr)))).toString();
                                auctionBuilder = $this$parseAuctionContainer;
                                $i$f$fromValue = false;
                                object8 = Vocation.class;
                                it$iv = object8;
                                boolean bl32 = false;
                                Object object9 = it$iv.isEnum() ? object8 : null;
                                if (object9 != null && (object9 = (Enum[])object9.getEnumConstants()) != null) {
                                    Enum[] bl32 = object9;
                                    n2 = bl32.length;
                                    for (n = 0; n < n2; ++n) {
                                        it$iv2 = object7 = bl32[n];
                                        bl = false;
                                        if (!(Intrinsics.areEqual((Object)((StringEnum)it$iv2).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv2).name(), (Object)value$iv))) continue;
                                        enum_2 = object7;
                                        break block33;
                                    }
                                    enum_2 = null;
                                } else {
                                    enum_2 = null;
                                }
                            }
                            Vocation vocation = (Vocation)enum_2;
                            if (vocation == null) {
                                throw new ParsingException("Unknown vocation found: " + (String)((Object)vocationStr), null, 2, null);
                            }
                            auctionBuilder.setVocation(vocation);
                            StringEnum.Companion this_$iv = StringEnum.Companion;
                            String string = sexStr.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                            value$iv = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            auctionBuilder = $this$parseAuctionContainer;
                            $i$f$fromValue = false;
                            object8 = Sex.class;
                            it$iv = object8;
                            boolean bl4 = false;
                            Object object10 = it$iv.isEnum() ? object8 : null;
                            if (object10 != null && (object10 = (Enum[])((Class)object10).getEnumConstants()) != null) {
                                Object object11 = object10;
                                n2 = ((Object)object11).length;
                                for (n = 0; n < n2; ++n) {
                                    it$iv2 = object7 = object11[n];
                                    bl = false;
                                    if (!(Intrinsics.areEqual((Object)((StringEnum)it$iv2).getValue(), (Object)value$iv) || Intrinsics.areEqual((Object)((Enum)it$iv2).name(), (Object)value$iv))) continue;
                                    object6 = object7;
                                    break block34;
                                }
                                object6 = null;
                            } else {
                                object6 = null;
                            }
                        }
                        Sex sex = (Sex)object6;
                        if (sex == null) {
                            throw new ParsingException("Unknown sex found: " + sexStr, null, 2, null);
                        }
                        auctionBuilder.setSex(sex);
                        $this$parseAuctionContainer.setWorld(((Object)StringsKt.trim((CharSequence)worldStr)).toString());
                    }
                    if ((object4 = auctionContainer.selectFirst("img.AuctionOutfitImage")) == null || (object4 = object4.attr("src")) == null) {
                        throw new ParsingException("outfit image not found", null, 2, null);
                    }
                    Object outfitImageUrl = object4;
                    Object object12 = Regex.find$default((Regex)idAddonsRegex, (CharSequence)((CharSequence)outfitImageUrl), (int)0, (int)2, null);
                    if (object12 == null || (object12 = object12.getGroupValues()) == null) {
                        throw new ParsingException("image URL does not match expected pattern", null, 2, null);
                    }
                    element = object12;
                    String outfitId = (String)element.get(1);
                    String addons = (String)element.get(2);
                    Elements elements = auctionContainer.select(".CVIcon");
                    Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
                    Iterable $this$forEach$iv = (Iterable)elements;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        ItemEntry $this$parseAuctionContainer_u24lambda_u2436_u24lambda_u2435;
                        it = (Element)element$iv2;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (INSTANCE.parseDisplayedItem(it) == null) continue;
                        boolean bl5 = false;
                        $this$parseAuctionContainer.addDisplayedItem($this$parseAuctionContainer_u24lambda_u2436_u24lambda_u2435);
                    }
                    $this$parseAuctionContainer.setOutfit(new OutfitImage(Integer.parseInt(outfitId), Integer.parseInt(addons)));
                    Elements elements2 = auctionContainer.select("div.Entry");
                    Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
                    $this$forEach$iv = (Iterable)elements2;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        String imgUrl;
                        Object img;
                        it = (Element)element$iv2;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.select("img"), (String)"select(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)img.attr("src"), (String)"attr(...)");
                        Object object13 = Regex.find$default((Regex)idRegex, (CharSequence)imgUrl, (int)0, (int)2, null);
                        if (object13 == null || (object13 = object13.getGroupValues()) == null) {
                            throw new ParsingException("sales argument image does not match pattern.", null, 2, null);
                        }
                        String id = (String)object13.get(1);
                        $this$parseAuctionContainer.salesArgument((Function1<? super AuctionBuilder.SalesArgumentBuilder, Unit>)((Function1)arg_0 -> AuctionParser.parseAuctionContainer$lambda$38$lambda$37(id, it, arg_0)));
                    }
                    Elements elements3 = auctionContainer.select("div.ShortAuctionDataValue");
                    Intrinsics.checkNotNullExpressionValue((Object)elements3, (String)"select(...)");
                    Iterable $this$map$iv = (Iterable)elements3;
                    boolean $i$f$map = false;
                    element$iv2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Element id = (Element)item$iv$iv;
                        object3 = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it2);
                        object3.add(ElementsKt.cleanText((Element)it2));
                    }
                    List list = (List)destination$iv$iv;
                    String startDate = (String)list.get(0);
                    String endDate = (String)list.get(1);
                    $this$parseAuctionContainer.setAuctionStart(DatesKt.parseTibiaDateTime(startDate));
                    $this$parseAuctionContainer.setAuctionEnd(DatesKt.parseTibiaDateTime(endDate));
                    Element element4 = auctionContainer.selectFirst("div.ShortAuctionDataBidRow");
                    if (element4 != null) {
                        Enum enum_3;
                        AuctionBuilder auctionBuilder;
                        String bidTypeStr;
                        block35: {
                            Enum[] enumArray2;
                            Element $this$parseAuctionContainer_u24lambda_u2440 = element4;
                            boolean bl = false;
                            Element element5 = $this$parseAuctionContainer_u24lambda_u2440.selectFirst("div.ShortAuctionDataValue");
                            if (element5 == null) {
                                throw new ParsingException("Could not find bid", null, 2, null);
                            }
                            bidTag = element5;
                            Element element6 = $this$parseAuctionContainer_u24lambda_u2440.selectFirst("div.ShortAuctionDataLabel");
                            if (element6 == null) {
                                throw new ParsingException("could not find bid type", null, 2, null);
                            }
                            Element bidTypeTag = element6;
                            bidTypeStr = StringExtensionsKt.remove$default(ElementsKt.cleanText(bidTypeTag), ":", false, 2, null);
                            String string = bidTag.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                            $this$parseAuctionContainer.setBid(StringExtensionsKt.parseInteger(string));
                            it$iv = StringEnum.Companion;
                            auctionBuilder = $this$parseAuctionContainer;
                            boolean $i$f$fromValue = false;
                            Enum[] it$iv3 = enumArray2 = BidType.class;
                            boolean bl6 = false;
                            Object object14 = it$iv3.isEnum() ? enumArray2 : null;
                            if (object14 != null && (object14 = (Enum[])object14.getEnumConstants()) != null) {
                                Enum[] enumArray3 = object14;
                                int n = enumArray3.length;
                                for (int i = 0; i < n; ++i) {
                                    Enum enum_4;
                                    Enum it$iv4 = enum_4 = enumArray3[i];
                                    boolean bl7 = false;
                                    if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv4)).getValue(), (Object)bidTypeStr) || Intrinsics.areEqual((Object)it$iv4.name(), (Object)bidTypeStr))) continue;
                                    enum_3 = enum_4;
                                    break block35;
                                }
                                enum_3 = null;
                            } else {
                                enum_3 = null;
                            }
                        }
                        BidType bidType = (BidType)enum_3;
                        if (bidType == null) {
                            throw new ParsingException("unknown bid type: " + bidTypeStr, null, 2, null);
                        }
                        auctionBuilder.setBidType(bidType);
                    }
                    object2 = $this$parseAuctionContainer;
                    object = auctionContainer.selectFirst("div.AuctionInfo");
                    if (object == null || (object = ElementsKt.cleanText(object)) == null) break block37;
                    bidTag = object;
                    object3 = object2;
                    boolean bl = false;
                    StringEnum.Companion this_$iv = StringEnum.Companion;
                    boolean $i$f$fromValue = false;
                    Enum[] it$iv5 = enumArray = AuctionStatus.class;
                    boolean bl8 = false;
                    Object object15 = it$iv5.isEnum() ? enumArray : null;
                    if (object15 != null && (object15 = (Enum[])object15.getEnumConstants()) != null) {
                        Enum[] enumArray4 = object15;
                        int n = enumArray4.length;
                        for (int i = 0; i < n; ++i) {
                            void it3;
                            Enum enum_5;
                            Enum it$iv6 = enum_5 = enumArray4[i];
                            boolean bl9 = false;
                            if (!(Intrinsics.areEqual((Object)((StringEnum)((Object)it$iv6)).getValue(), (Object)it3) || Intrinsics.areEqual((Object)it$iv6.name(), (Object)it3))) continue;
                            enum_ = enum_5;
                            break block36;
                        }
                        enum_ = null;
                    } else {
                        enum_ = null;
                    }
                }
                AuctionStatus auctionStatus = (AuctionStatus)enum_;
                object2 = object3;
                object = auctionStatus;
                if (auctionStatus != null) break block38;
            }
            object = AuctionStatus.IN_PROGRESS;
        }
        ((AuctionBuilder)object2).setStatus((AuctionStatus)object);
    }

    @PublishedApi
    @Nullable
    public final ItemEntry parseDisplayedItem(@NotNull Element displayItemContainer) {
        int tier;
        int amount;
        String description;
        Object name;
        int itemId;
        block2: {
            MatchResult matchResult;
            Intrinsics.checkNotNullParameter((Object)displayItemContainer, (String)"displayItemContainer");
            String string = displayItemContainer.attr("title");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            String title = string;
            Object object = displayItemContainer.selectFirst("img");
            if (object == null || (object = object.attr("src")) == null) {
                return null;
            }
            Object fileUrl = object;
            String fileName = new File(new URL((String)fileUrl).getPath()).getName();
            Intrinsics.checkNotNull((Object)fileName);
            itemId = Integer.parseInt(StringExtensionsKt.remove$default(fileName, ".gif", false, 2, null));
            String[] stringArray = new String[]{"\n"};
            List titleLines = StringsKt.split$default((CharSequence)title, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            name = null;
            name = CollectionsKt.first((List)titleLines);
            description = titleLines.size() > 1 ? CollectionsKt.joinToString$default((Iterable)ListExtensionsKt.offsetStart(titleLines, 1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null;
            amount = 0;
            amount = 1;
            MatchResult matchResult2 = Regex.find$default((Regex)amountRegex, (CharSequence)((CharSequence)name), (int)0, (int)2, null);
            if (matchResult2 != null) {
                MatchResult matchResult3;
                MatchResult $this$parseDisplayedItem_u24lambda_u2442 = matchResult3 = matchResult2;
                boolean bl = false;
                MatchGroup matchGroup = $this$parseDisplayedItem_u24lambda_u2442.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                amount = StringExtensionsKt.parseInteger(matchGroup.getValue());
                name = amountRegex.replace((CharSequence)name, "");
            }
            tier = 0;
            MatchResult matchResult4 = Regex.find$default((Regex)tierRegex, (CharSequence)((CharSequence)name), (int)0, (int)2, null);
            if (matchResult4 == null) break block2;
            MatchResult $this$parseDisplayedItem_u24lambda_u2443 = matchResult = matchResult4;
            boolean bl = false;
            MatchGroup matchGroup = $this$parseDisplayedItem_u24lambda_u2443.getGroups().get(2);
            Intrinsics.checkNotNull((Object)matchGroup);
            tier = StringExtensionsKt.parseInteger(matchGroup.getValue());
            MatchGroup matchGroup2 = $this$parseDisplayedItem_u24lambda_u2443.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup2);
            name = matchGroup2.getValue();
        }
        return new ItemEntry(itemId, (String)name, description, amount, tier);
    }

    @PublishedApi
    @NotNull
    public final OutfitEntry parseDisplayedOutfit(@NotNull Element container) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        String string = container.attr("title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        Object object2 = new String[]{"("};
        String name = StringExtensionsKt.clean((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (String[])object2, (boolean)false, (int)0, (int)6, null)));
        Element element = container.selectFirst("img");
        String string2 = element != null ? element.attr("src") : null;
        if (string2 == null) {
            string2 = "";
        }
        if ((object = Regex.find$default((Regex)idAddonsRegex, (CharSequence)string2, (int)0, (int)2, null)) == null || (object = object.getGroupValues()) == null) {
            throw new ParsingException("outfit image did not match expected pattern", null, 2, null);
        }
        object2 = object;
        String id = (String)object2.get(1);
        String addons = (String)object2.get(2);
        return new OutfitEntry(name, Integer.parseInt(id), Integer.parseInt(addons));
    }

    @PublishedApi
    @NotNull
    public final MountEntry parseDisplayedMount(@NotNull Element container) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        String string = container.attr("title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String name = string;
        Element element = container.selectFirst("img");
        String string2 = element != null ? element.attr("src") : null;
        if (string2 == null) {
            string2 = "";
        }
        if ((object = Regex.find$default((Regex)idRegex, (CharSequence)string2, (int)0, (int)2, null)) == null || (object = object.getGroupValues()) == null) {
            throw new ParsingException("mount image did not match expected pattern", null, 2, null);
        }
        String id = (String)object.get(1);
        return new MountEntry(name, Integer.parseInt(id));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> List<T> parsePageItems(String content) {
        List list;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        boolean $i$f$parsePageItems = false;
        Document document = Jsoup.parse((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        Elements elements = document2.select(ICON_CSS_SELECTOR);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements cvIcon = elements;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ItemEntry.class))) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)cvIcon;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                ItemEntry itemEntry = INSTANCE.parseDisplayedItem(it);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                if ((Object)itemEntry == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(OutfitEntry.class))) {
            Iterable $this$mapNotNull$iv = (Iterable)cvIcon;
            boolean $i$f$mapNotNull = false;
            Iterable $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it);
                OutfitEntry outfitEntry = INSTANCE.parseDisplayedOutfit(it);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                if ((Object)outfitEntry == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MountEntry.class))) {
            Iterable $this$mapNotNull$iv = (Iterable)cvIcon;
            boolean $i$f$mapNotNull = false;
            Iterable $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNull((Object)it);
                MountEntry mountEntry = INSTANCE.parseDisplayedMount(it);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                if ((Object)mountEntry == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public Element boxContent(@NotNull String content, @Nullable org.jsoup.parser.Parser parser) {
        return Parser.DefaultImpls.boxContent(this, content, parser);
    }

    private static final Unit fromContent$lambda$24$lambda$23(Map $detailsTables, AuctionBuilder.AuctionDetailsBuilder $this$details) {
        block21: {
            String it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Element element;
            Intrinsics.checkNotNullParameter((Object)$this$details, (String)"$this$details");
            Element element2 = (Element)$detailsTables.get("General");
            if (element2 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u241 = element = element2;
                boolean bl = false;
                INSTANCE.parseGeneralTable($this$details, $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u241);
            }
            Element element3 = (Element)$detailsTables.get("Item Summary");
            if (element3 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u242 = element = element3;
                boolean bl = false;
                $this$details.setItems(INSTANCE.parseItemsTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u242));
            }
            Element element4 = (Element)$detailsTables.get("Store Item Summary");
            if (element4 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u243 = element = element4;
                boolean bl = false;
                $this$details.setStoreItems(INSTANCE.parseItemsTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u243));
            }
            Element element5 = (Element)$detailsTables.get("Mounts");
            if (element5 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u244 = element = element5;
                boolean bl = false;
                $this$details.setMounts(INSTANCE.parseMountsTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u244));
            }
            Element element6 = (Element)$detailsTables.get("Store Mounts");
            if (element6 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u245 = element = element6;
                boolean bl = false;
                $this$details.setStoreMounts(INSTANCE.parseMountsTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u245));
            }
            Element element7 = (Element)$detailsTables.get("Outfits");
            if (element7 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u246 = element = element7;
                boolean bl = false;
                $this$details.setOutfits(INSTANCE.parseOutfitsTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u246));
            }
            Element element8 = (Element)$detailsTables.get("Store Outfits");
            if (element8 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u247 = element = element8;
                boolean bl = false;
                $this$details.setStoreOutfits(INSTANCE.parseOutfitsTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u247));
            }
            Element element9 = (Element)$detailsTables.get("Familiars");
            if (element9 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u248 = element = element9;
                boolean bl = false;
                $this$details.setFamiliars(INSTANCE.parseFamiliarsTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u248));
            }
            Element element10 = (Element)$detailsTables.get("Blessings");
            if (element10 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u249 = element = element10;
                boolean bl = false;
                INSTANCE.parseBlessingsTable($this$details, $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u249);
            }
            Element element11 = (Element)$detailsTables.get("Imbuements");
            if (element11 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2411 = element = element11;
                boolean bl = false;
                $this$forEach$iv = INSTANCE.parseSingleColumnTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2411);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    $this$details.addImbuement(it);
                }
            }
            Element element12 = (Element)$detailsTables.get("Charms");
            if (element12 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2412 = element = element12;
                boolean bl = false;
                INSTANCE.parseCharmsTable($this$details, $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2412);
            }
            Element element13 = (Element)$detailsTables.get("Completed Cyclopedia Map Areas");
            if (element13 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2414 = element = element13;
                boolean bl = false;
                $this$forEach$iv = INSTANCE.parseSingleColumnTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2414);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl3 = false;
                    $this$details.addCompletedCyclopediaMapArea(it);
                }
            }
            Element element14 = (Element)$detailsTables.get("Completed Quest Lines");
            if (element14 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2416 = element = element14;
                boolean bl = false;
                $this$forEach$iv = INSTANCE.parseSingleColumnTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2416);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl4 = false;
                    $this$details.addCompletedQuestLine(it);
                }
            }
            Element element15 = (Element)$detailsTables.get("Titles");
            if (element15 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2418 = element15;
                boolean bl = false;
                $this$forEach$iv = INSTANCE.parseSingleColumnTable($this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2418);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl5 = false;
                    $this$details.addTitle(it);
                }
            }
            Element element16 = (Element)$detailsTables.get("Achievements");
            if (element16 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2419 = element16;
                boolean bl = false;
                INSTANCE.parseAchievementsTable($this$details, $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2419);
            }
            Element element17 = (Element)$detailsTables.get("Bestiary Progress");
            if (element17 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420 = element17;
                boolean bl = false;
                INSTANCE.parseBestiaryTable($this$details, $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420, false);
            }
            Element element18 = (Element)$detailsTables.get("Bosstiary Progress");
            if (element18 != null) {
                Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421 = element18;
                boolean bl = false;
                INSTANCE.parseBestiaryTable($this$details, $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421, true);
            }
            Element element19 = (Element)$detailsTables.get("Revealed Gems");
            if (element19 == null) break block21;
            Element $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422 = element19;
            boolean bl = false;
            INSTANCE.parseRevealedGemsTable($this$details, $this$fromContent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422);
        }
        return Unit.INSTANCE;
    }

    private static final double parseGeneralTable$lambda$29(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0.0;
    }

    private static final Unit parseAuctionContainer$lambda$38$lambda$37(String $id, Element $it, AuctionBuilder.SalesArgumentBuilder $this$salesArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$salesArgument, (String)"$this$salesArgument");
        $this$salesArgument.setCategoryId(Integer.parseInt($id));
        Intrinsics.checkNotNull((Object)$it);
        $this$salesArgument.setContent(ElementsKt.cleanText($it));
        return Unit.INSTANCE;
    }
}

