/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.builders;

import com.galarzaa.tibiakt.core.builders.TibiaKtBuilder;
import com.galarzaa.tibiakt.core.enums.BattlEyeType;
import com.galarzaa.tibiakt.core.enums.PvpType;
import com.galarzaa.tibiakt.core.enums.TransferType;
import com.galarzaa.tibiakt.core.models.world.WorldEntry;
import com.galarzaa.tibiakt.core.models.world.WorldOverview;
import com.galarzaa.tibiakt.core.utils.BuilderDsl;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BuilderDsl
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J!\u0010\u0017\u001a\u00020\u00182\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\u0002\b\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u0002H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/galarzaa/tibiakt/core/builders/WorldOverviewBuilder;", "Lcom/galarzaa/tibiakt/core/builders/TibiaKtBuilder;", "Lcom/galarzaa/tibiakt/core/models/world/WorldOverview;", "<init>", "()V", "overallMaximumCount", "", "getOverallMaximumCount", "()Ljava/lang/Integer;", "setOverallMaximumCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "overallMaximumCountDateTime", "Lkotlinx/datetime/Instant;", "getOverallMaximumCountDateTime", "()Lkotlinx/datetime/Instant;", "setOverallMaximumCountDateTime", "(Lkotlinx/datetime/Instant;)V", "worlds", "", "Lcom/galarzaa/tibiakt/core/models/world/WorldEntry;", "getWorlds", "()Ljava/util/List;", "addWorld", "", "world", "block", "Lkotlin/Function1;", "Lcom/galarzaa/tibiakt/core/builders/WorldOverviewBuilder$WorldEntryBuilder;", "", "Lkotlin/ExtensionFunctionType;", "build", "WorldEntryBuilder", "tibiakt-core"})
public final class WorldOverviewBuilder
implements TibiaKtBuilder<WorldOverview> {
    @Nullable
    private Integer overallMaximumCount;
    @Nullable
    private Instant overallMaximumCountDateTime;
    @NotNull
    private final List<WorldEntry> worlds = new ArrayList();

    @Nullable
    public final Integer getOverallMaximumCount() {
        return this.overallMaximumCount;
    }

    public final void setOverallMaximumCount(@Nullable Integer n) {
        this.overallMaximumCount = n;
    }

    @Nullable
    public final Instant getOverallMaximumCountDateTime() {
        return this.overallMaximumCountDateTime;
    }

    public final void setOverallMaximumCountDateTime(@Nullable Instant instant) {
        this.overallMaximumCountDateTime = instant;
    }

    @NotNull
    public final List<WorldEntry> getWorlds() {
        return this.worlds;
    }

    public final boolean addWorld(@NotNull WorldEntry world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.worlds.add(world);
    }

    @BuilderDsl
    public final boolean addWorld(@NotNull Function1<? super WorldEntryBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        WorldEntryBuilder worldEntryBuilder = new WorldEntryBuilder();
        block.invoke((Object)worldEntryBuilder);
        return this.worlds.add(worldEntryBuilder.build());
    }

    @Override
    @NotNull
    public WorldOverview build() {
        Integer n = this.overallMaximumCount;
        if (n == null) {
            throw new IllegalStateException("overallMaximumCount is required".toString());
        }
        Instant instant = this.overallMaximumCountDateTime;
        if (instant == null) {
            throw new IllegalStateException("overallMaximumCountDateTime is required".toString());
        }
        return new WorldOverview(n, instant, this.worlds);
    }

    @BuilderDsl
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010;\u001a\u00020\u0002H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\r\"\u0004\b2\u0010\u000fR\u001a\u00103\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\r\"\u0004\b4\u0010\u000fR\u001c\u00105\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006<"}, d2={"Lcom/galarzaa/tibiakt/core/builders/WorldOverviewBuilder$WorldEntryBuilder;", "Lcom/galarzaa/tibiakt/core/builders/TibiaKtBuilder;", "Lcom/galarzaa/tibiakt/core/models/world/WorldEntry;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "isOnline", "", "()Z", "setOnline", "(Z)V", "onlineCount", "", "getOnlineCount", "()I", "setOnlineCount", "(I)V", "location", "getLocation", "setLocation", "pvpType", "Lcom/galarzaa/tibiakt/core/enums/PvpType;", "getPvpType", "()Lcom/galarzaa/tibiakt/core/enums/PvpType;", "setPvpType", "(Lcom/galarzaa/tibiakt/core/enums/PvpType;)V", "battlEyeType", "Lcom/galarzaa/tibiakt/core/enums/BattlEyeType;", "getBattlEyeType", "()Lcom/galarzaa/tibiakt/core/enums/BattlEyeType;", "setBattlEyeType", "(Lcom/galarzaa/tibiakt/core/enums/BattlEyeType;)V", "battlEyeStartDate", "Ljava/time/LocalDate;", "getBattlEyeStartDate", "()Ljava/time/LocalDate;", "setBattlEyeStartDate", "(Ljava/time/LocalDate;)V", "transferType", "Lcom/galarzaa/tibiakt/core/enums/TransferType;", "getTransferType", "()Lcom/galarzaa/tibiakt/core/enums/TransferType;", "setTransferType", "(Lcom/galarzaa/tibiakt/core/enums/TransferType;)V", "isPremiumRestricted", "setPremiumRestricted", "isExperimental", "setExperimental", "onlineRecordDateTime", "Lkotlinx/datetime/Instant;", "getOnlineRecordDateTime", "()Lkotlinx/datetime/Instant;", "setOnlineRecordDateTime", "(Lkotlinx/datetime/Instant;)V", "build", "tibiakt-core"})
    public static final class WorldEntryBuilder
    implements TibiaKtBuilder<WorldEntry> {
        @Nullable
        private String name;
        private boolean isOnline;
        private int onlineCount;
        @Nullable
        private String location;
        @Nullable
        private PvpType pvpType;
        @NotNull
        private BattlEyeType battlEyeType = BattlEyeType.UNPROTECTED;
        @Nullable
        private LocalDate battlEyeStartDate;
        @NotNull
        private TransferType transferType = TransferType.REGULAR;
        private boolean isPremiumRestricted;
        private boolean isExperimental;
        @Nullable
        private Instant onlineRecordDateTime;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        public final boolean isOnline() {
            return this.isOnline;
        }

        public final void setOnline(boolean bl) {
            this.isOnline = bl;
        }

        public final int getOnlineCount() {
            return this.onlineCount;
        }

        public final void setOnlineCount(int n) {
            this.onlineCount = n;
        }

        @Nullable
        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(@Nullable String string) {
            this.location = string;
        }

        @Nullable
        public final PvpType getPvpType() {
            return this.pvpType;
        }

        public final void setPvpType(@Nullable PvpType pvpType) {
            this.pvpType = pvpType;
        }

        @NotNull
        public final BattlEyeType getBattlEyeType() {
            return this.battlEyeType;
        }

        public final void setBattlEyeType(@NotNull BattlEyeType battlEyeType) {
            Intrinsics.checkNotNullParameter((Object)((Object)battlEyeType), (String)"<set-?>");
            this.battlEyeType = battlEyeType;
        }

        @Nullable
        public final LocalDate getBattlEyeStartDate() {
            return this.battlEyeStartDate;
        }

        public final void setBattlEyeStartDate(@Nullable LocalDate localDate) {
            this.battlEyeStartDate = localDate;
        }

        @NotNull
        public final TransferType getTransferType() {
            return this.transferType;
        }

        public final void setTransferType(@NotNull TransferType transferType) {
            Intrinsics.checkNotNullParameter((Object)((Object)transferType), (String)"<set-?>");
            this.transferType = transferType;
        }

        public final boolean isPremiumRestricted() {
            return this.isPremiumRestricted;
        }

        public final void setPremiumRestricted(boolean bl) {
            this.isPremiumRestricted = bl;
        }

        public final boolean isExperimental() {
            return this.isExperimental;
        }

        public final void setExperimental(boolean bl) {
            this.isExperimental = bl;
        }

        @Nullable
        public final Instant getOnlineRecordDateTime() {
            return this.onlineRecordDateTime;
        }

        public final void setOnlineRecordDateTime(@Nullable Instant instant) {
            this.onlineRecordDateTime = instant;
        }

        @Override
        @NotNull
        public WorldEntry build() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException("name is required".toString());
            }
            String string2 = this.location;
            if (string2 == null) {
                throw new IllegalStateException("location is required".toString());
            }
            PvpType pvpType = this.pvpType;
            if (pvpType == null) {
                throw new IllegalStateException("pvpType is required".toString());
            }
            return new WorldEntry(string, this.isOnline, this.onlineCount, string2, pvpType, this.battlEyeType, this.battlEyeStartDate, this.transferType, this.isPremiumRestricted, this.isExperimental);
        }
    }
}

