/*
 * Decompiled with CFR 0.152.
 */
package com.galarzaa.tibiakt.core.builders;

import com.galarzaa.tibiakt.core.builders.TibiaKtBuilder;
import com.galarzaa.tibiakt.core.enums.NewsCategory;
import com.galarzaa.tibiakt.core.enums.NewsType;
import com.galarzaa.tibiakt.core.models.news.NewsArchive;
import com.galarzaa.tibiakt.core.models.news.NewsEntry;
import com.galarzaa.tibiakt.core.utils.BuilderDsl;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BuilderDsl
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0010J.\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0010J\u001f\u0010\u001f\u001a\u00020\u00002\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020\u0002H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/galarzaa/tibiakt/core/builders/NewsArchiveBuilder;", "Lcom/galarzaa/tibiakt/core/builders/TibiaKtBuilder;", "Lcom/galarzaa/tibiakt/core/models/news/NewsArchive;", "<init>", "()V", "startDate", "Ljava/time/LocalDate;", "getStartDate", "()Ljava/time/LocalDate;", "setStartDate", "(Ljava/time/LocalDate;)V", "endDate", "getEndDate", "setEndDate", "types", "", "Lcom/galarzaa/tibiakt/core/enums/NewsType;", "getTypes", "()Ljava/util/Set;", "categories", "Lcom/galarzaa/tibiakt/core/enums/NewsCategory;", "getCategories", "entries", "", "Lcom/galarzaa/tibiakt/core/models/news/NewsEntry;", "getEntries", "()Ljava/util/List;", "addCategory", "category", "addType", "type", "addEntry", "id", "", "title", "", "date", "builder", "Lkotlin/Function1;", "Lcom/galarzaa/tibiakt/core/builders/NewsArchiveBuilder$NewsEntryBuilder;", "", "Lkotlin/ExtensionFunctionType;", "build", "NewsEntryBuilder", "tibiakt-core"})
@SourceDebugExtension(value={"SMAP\nNewsArchiveBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewsArchiveBuilder.kt\ncom/galarzaa/tibiakt/core/builders/NewsArchiveBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class NewsArchiveBuilder
implements TibiaKtBuilder<NewsArchive> {
    @Nullable
    private LocalDate startDate;
    @Nullable
    private LocalDate endDate;
    @NotNull
    private final Set<NewsType> types = new LinkedHashSet();
    @NotNull
    private final Set<NewsCategory> categories = new LinkedHashSet();
    @NotNull
    private final List<NewsEntry> entries = new ArrayList();

    @Nullable
    public final LocalDate getStartDate() {
        return this.startDate;
    }

    public final void setStartDate(@Nullable LocalDate localDate) {
        this.startDate = localDate;
    }

    @Nullable
    public final LocalDate getEndDate() {
        return this.endDate;
    }

    public final void setEndDate(@Nullable LocalDate localDate) {
        this.endDate = localDate;
    }

    @NotNull
    public final Set<NewsType> getTypes() {
        return this.types;
    }

    @NotNull
    public final Set<NewsCategory> getCategories() {
        return this.categories;
    }

    @NotNull
    public final List<NewsEntry> getEntries() {
        return this.entries;
    }

    @NotNull
    public final NewsArchiveBuilder addCategory(@NotNull NewsCategory category) {
        NewsArchiveBuilder newsArchiveBuilder;
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        NewsArchiveBuilder $this$addCategory_u24lambda_u240 = newsArchiveBuilder = this;
        boolean bl = false;
        $this$addCategory_u24lambda_u240.categories.add(category);
        return newsArchiveBuilder;
    }

    @NotNull
    public final NewsArchiveBuilder addType(@NotNull NewsType type) {
        NewsArchiveBuilder newsArchiveBuilder;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        NewsArchiveBuilder $this$addType_u24lambda_u241 = newsArchiveBuilder = this;
        boolean bl = false;
        $this$addType_u24lambda_u241.types.add(type);
        return newsArchiveBuilder;
    }

    @NotNull
    public final NewsArchiveBuilder addEntry(int id, @NotNull String title, @NotNull NewsCategory category, @NotNull LocalDate date, @NotNull NewsType type) {
        NewsArchiveBuilder newsArchiveBuilder;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        NewsArchiveBuilder $this$addEntry_u24lambda_u242 = newsArchiveBuilder = this;
        boolean bl = false;
        $this$addEntry_u24lambda_u242.entries.add(new NewsEntry(id, title, category, date, type));
        return newsArchiveBuilder;
    }

    @NotNull
    public final NewsArchiveBuilder addEntry(@NotNull Function1<? super NewsEntryBuilder, Unit> builder) {
        NewsArchiveBuilder newsArchiveBuilder;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        NewsArchiveBuilder $this$addEntry_u24lambda_u243 = newsArchiveBuilder = this;
        boolean bl = false;
        List<NewsEntry> list = $this$addEntry_u24lambda_u243.entries;
        NewsEntryBuilder newsEntryBuilder = new NewsEntryBuilder();
        builder.invoke((Object)newsEntryBuilder);
        list.add(newsEntryBuilder.build());
        return newsArchiveBuilder;
    }

    @Override
    @NotNull
    public NewsArchive build() {
        LocalDate localDate = this.startDate;
        if (localDate == null) {
            throw new IllegalStateException("startDate is required".toString());
        }
        LocalDate localDate2 = this.endDate;
        if (localDate2 == null) {
            throw new IllegalStateException("endDate is required".toString());
        }
        return new NewsArchive(localDate, localDate2, this.types, this.categories, this.entries);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010#\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lcom/galarzaa/tibiakt/core/builders/NewsArchiveBuilder$NewsEntryBuilder;", "Lcom/galarzaa/tibiakt/core/builders/TibiaKtBuilder;", "Lcom/galarzaa/tibiakt/core/models/news/NewsEntry;", "<init>", "()V", "id", "", "getId", "()I", "setId", "(I)V", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "category", "Lcom/galarzaa/tibiakt/core/enums/NewsCategory;", "getCategory", "()Lcom/galarzaa/tibiakt/core/enums/NewsCategory;", "setCategory", "(Lcom/galarzaa/tibiakt/core/enums/NewsCategory;)V", "date", "Ljava/time/LocalDate;", "getDate", "()Ljava/time/LocalDate;", "setDate", "(Ljava/time/LocalDate;)V", "type", "Lcom/galarzaa/tibiakt/core/enums/NewsType;", "getType", "()Lcom/galarzaa/tibiakt/core/enums/NewsType;", "setType", "(Lcom/galarzaa/tibiakt/core/enums/NewsType;)V", "build", "tibiakt-core"})
    public static final class NewsEntryBuilder
    implements TibiaKtBuilder<NewsEntry> {
        private int id;
        @Nullable
        private String title;
        @Nullable
        private NewsCategory category;
        @Nullable
        private LocalDate date;
        @Nullable
        private NewsType type;

        public final int getId() {
            return this.id;
        }

        public final void setId(int n) {
            this.id = n;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(@Nullable String string) {
            this.title = string;
        }

        @Nullable
        public final NewsCategory getCategory() {
            return this.category;
        }

        public final void setCategory(@Nullable NewsCategory newsCategory) {
            this.category = newsCategory;
        }

        @Nullable
        public final LocalDate getDate() {
            return this.date;
        }

        public final void setDate(@Nullable LocalDate localDate) {
            this.date = localDate;
        }

        @Nullable
        public final NewsType getType() {
            return this.type;
        }

        public final void setType(@Nullable NewsType newsType) {
            this.type = newsType;
        }

        @Override
        @NotNull
        public NewsEntry build() {
            String string = this.title;
            if (string == null) {
                throw new IllegalStateException("title is required".toString());
            }
            NewsCategory newsCategory = this.category;
            if (newsCategory == null) {
                throw new IllegalStateException("category is required".toString());
            }
            LocalDate localDate = this.date;
            if (localDate == null) {
                throw new IllegalStateException("date is required".toString());
            }
            NewsType newsType = this.type;
            if (newsType == null) {
                throw new IllegalStateException("type is required".toString());
            }
            return new NewsEntry(this.id, string, newsCategory, localDate, newsType);
        }
    }
}

