/*
 * Decompiled with CFR 0.152.
 */
package com.gabrielittner.auto.value.util;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public final class ElementUtil {
    public static Optional<ExecutableElement> getMatchingStaticMethod(TypeElement cls, TypeName returns, TypeName ... takes) {
        for (Element element : cls.getEnclosedElements()) {
            ExecutableElement method;
            if (element.getKind() != ElementKind.METHOD || !ElementUtil.methodMatches(method = (ExecutableElement)element, Modifier.STATIC, returns, takes)) continue;
            return Optional.of((Object)method);
        }
        return Optional.absent();
    }

    public static Optional<ExecutableElement> getMatchingAbstractMethod(Set<ExecutableElement> methods, TypeName returns, TypeName ... takes) {
        for (ExecutableElement method : methods) {
            if (!ElementUtil.methodMatches(method, Modifier.ABSTRACT, returns, takes)) continue;
            return Optional.of((Object)method);
        }
        return Optional.absent();
    }

    private static boolean methodMatches(ExecutableElement method, Modifier modifier, TypeName returns, TypeName[] takes) {
        return ElementUtil.hasModifier(method, modifier) && ElementUtil.methodTakes(method, takes) && ElementUtil.methodReturns(method, returns);
    }

    static boolean hasModifier(ExecutableElement method, Modifier modifier) {
        return method.getModifiers().contains((Object)modifier);
    }

    static boolean methodTakes(ExecutableElement method, TypeName ... takes) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() != takes.length) {
            return false;
        }
        for (int i = 0; i < takes.length; ++i) {
            if (takes[i].equals((Object)TypeName.get((TypeMirror)parameters.get(i).asType()))) continue;
            return false;
        }
        return true;
    }

    static boolean methodReturns(ExecutableElement method, TypeName returns) {
        return returns.equals((Object)ClassName.get((TypeMirror)method.getReturnType()));
    }

    public static boolean typeExists(Elements elements, ClassName className) {
        String name = className.toString();
        return elements.getTypeElement(name) != null;
    }

    public static boolean hasAnnotationWithName(Element element, String simpleName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String name = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
            if (!simpleName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static ImmutableSet<String> buildAnnotations(ExecutableElement element) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            builder.add((Object)annotationMirror.getAnnotationType().asElement().getSimpleName().toString());
        }
        return builder.build();
    }

    public static Object getAnnotationValue(Element element, Class<? extends Annotation> clazz, String key) {
        Optional annotation = MoreElements.getAnnotationMirror((Element)element, clazz);
        if (annotation.isPresent()) {
            return AnnotationMirrors.getAnnotationValue((AnnotationMirror)((AnnotationMirror)annotation.get()), (String)key).getValue();
        }
        return null;
    }

    private ElementUtil() {
        throw new AssertionError((Object)"No instances.");
    }
}

