/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.gallery;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.ImageShow;
import com.gaadi.neon.activity.gallery.NeonBaseGalleryActivity;
import com.gaadi.neon.adapter.GridFilesAdapter;
import com.gaadi.neon.enumerations.CameraFacing;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.enumerations.CameraType;
import com.gaadi.neon.enumerations.ResponseCode;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.OnPermissionResultListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.CustomParameters;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.PermissionType;
import com.scanlibrary.R;
import com.scanlibrary.databinding.ActivityGridFilesBinding;
import java.util.ArrayList;
import java.util.List;

public class GridFilesActivity
extends NeonBaseGalleryActivity {
    List<FileInfo> recentelyImageCollection;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.recentelyImageCollection = new ArrayList<FileInfo>();
        this.bindXml();
        String title = this.getIntent().getStringExtra("BucketName");
        if (title == null || title.length() <= 0) {
            title = this.getString(R.string.gallery);
        }
        this.setTitle(title);
    }

    public void addImageToRecentelySelected(FileInfo fileInfo) {
        this.recentelyImageCollection.add(fileInfo);
    }

    public boolean removeImageFromRecentCollection(FileInfo fileInfo) {
        if (this.recentelyImageCollection == null || this.recentelyImageCollection.size() <= 0) {
            return true;
        }
        for (int i = 0; i < this.recentelyImageCollection.size(); ++i) {
            if (!this.recentelyImageCollection.get(i).getFilePath().equals(fileInfo.getFilePath())) continue;
            return this.recentelyImageCollection.remove(i) != null;
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_done_file, menu2);
        MenuItem textViewDone = menu2.findItem(R.id.menu_next);
        MenuItem menuItemCamera = menu2.findItem(R.id.menuCamera);
        if (NeonImagesHandler.getSingletonInstance().getGalleryParam() != null) {
            menuItemCamera.setVisible(NeonImagesHandler.getSingletonInstance().getGalleryParam().galleryToCameraSwitchEnabled());
        }
        textViewDone.setVisible(true);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.menu_next) {
            if (NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) {
                Toast.makeText((Context)this, (int)R.string.no_image_selected, (int)0).show();
                return super.onOptionsItemSelected(item);
            }
            if (!NeonImagesHandler.getSingleonInstance().isNeutralEnabled()) {
                if (NeonImagesHandler.getSingletonInstance().getGalleryParam().enableImageEditing() || NeonImagesHandler.getSingletonInstance().getGalleryParam().getTagEnabled()) {
                    Intent intent = new Intent((Context)this, ImageShow.class);
                    this.startActivity(intent);
                    this.setResult(300);
                    this.finish();
                } else if (NeonImagesHandler.getSingletonInstance().getGalleryParam().enableFolderStructure()) {
                    this.setResult(-1);
                    this.finish();
                } else if (NeonImagesHandler.getSingletonInstance().validateNeonExit((Activity)this)) {
                    NeonImagesHandler.getSingletonInstance().sendImageCollectionAndFinish((Activity)this, ResponseCode.Success);
                    this.finish();
                }
            } else {
                this.setResult(-1);
                this.finish();
            }
        } else if (id2 == R.id.menuCamera) {
            this.performCameraOperation();
            this.setResult(300);
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (this.recentelyImageCollection != null && this.recentelyImageCollection.size() > 0) {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Are you sure want to loose all selected images?").setCancelable(true).setIcon(17301543).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    for (int i = 0; i < GridFilesActivity.this.recentelyImageCollection.size(); ++i) {
                        NeonImagesHandler.getSingletonInstance().removeFromCollection(GridFilesActivity.this.recentelyImageCollection.get(i));
                    }
                    GridFilesActivity.this.finish();
                }
            }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).show();
            return;
        }
        if (NeonImagesHandler.getSingleonInstance().isNeutralEnabled()) {
            super.onBackPressed();
        } else if (!NeonImagesHandler.getSingleonInstance().getGalleryParam().enableFolderStructure()) {
            NeonImagesHandler.getSingleonInstance().showBackOperationAlertIfNeeded((Activity)this);
        } else {
            super.onBackPressed();
        }
    }

    private void performCameraOperation() {
        ICameraParam cameraParam = NeonImagesHandler.getSingleonInstance().getCameraParam();
        if (cameraParam == null) {
            cameraParam = new ICameraParam(){

                @Override
                public CameraFacing getCameraFacing() {
                    return CameraFacing.front;
                }

                @Override
                public CameraOrientation getCameraOrientation() {
                    return CameraOrientation.portrait;
                }

                @Override
                public boolean getFlashEnabled() {
                    return true;
                }

                @Override
                public boolean getCameraSwitchingEnabled() {
                    return true;
                }

                @Override
                public boolean getVideoCaptureEnabled() {
                    return false;
                }

                @Override
                public CameraType getCameraViewType() {
                    return CameraType.normal_camera;
                }

                @Override
                public boolean cameraToGallerySwitchEnabled() {
                    return true;
                }

                @Override
                public int getNumberOfPhotos() {
                    return NeonImagesHandler.getSingleonInstance().getGalleryParam().getNumberOfPhotos();
                }

                @Override
                public boolean getTagEnabled() {
                    return NeonImagesHandler.getSingletonInstance().getGalleryParam().getTagEnabled();
                }

                @Override
                public List<ImageTagModel> getImageTagsModel() {
                    return NeonImagesHandler.getSingleonInstance().getGalleryParam().getImageTagsModel();
                }

                public ArrayList<FileInfo> getAlreadyAddedImages() {
                    return null;
                }

                @Override
                public boolean enableImageEditing() {
                    return NeonImagesHandler.getSingletonInstance().getGalleryParam().enableImageEditing();
                }

                @Override
                public CustomParameters getCustomParameters() {
                    return NeonImagesHandler.getSingletonInstance().getGalleryParam().getCustomParameters();
                }
            };
        }
        try {
            PhotosLibrary.collectPhotos(NeonImagesHandler.getSingletonInstance().getRequestCode(), (Context)this, NeonImagesHandler.getSingletonInstance().getLibraryMode(), PhotosMode.setCameraMode().setParams(cameraParam), NeonImagesHandler.getSingleonInstance().getImageResultListener());
        }
        catch (NeonException e) {
            e.printStackTrace();
        }
    }

    private void bindXml() {
        try {
            this.askForPermissionIfNeeded(PermissionType.write_external_storage, new OnPermissionResultListener(){

                @Override
                public void onResult(boolean permissionGranted) {
                    if (permissionGranted) {
                        ActivityGridFilesBinding binder = (ActivityGridFilesBinding)DataBindingUtil.inflate((LayoutInflater)GridFilesActivity.this.getLayoutInflater(), (int)R.layout.activity_grid_files, (ViewGroup)GridFilesActivity.this.frameLayout, (boolean)true);
                        GridFilesAdapter adapter = new GridFilesAdapter(GridFilesActivity.this, GridFilesActivity.this.getFileFromBucketId(GridFilesActivity.this.getIntent().getStringExtra("BucketId")));
                        binder.gvFolderPhotos.setAdapter((ListAdapter)adapter);
                    } else {
                        if (NeonImagesHandler.getSingletonInstance().isNeutralEnabled()) {
                            GridFilesActivity.this.finish();
                        } else {
                            NeonImagesHandler.getSingletonInstance().sendImageCollectionAndFinish((Activity)GridFilesActivity.this, ResponseCode.Write_Permission_Error);
                        }
                        Toast.makeText((Context)GridFilesActivity.this, (int)R.string.permission_error, (int)0).show();
                    }
                }
            });
        }
        catch (ManifestPermission manifestPermission) {
            manifestPermission.printStackTrace();
        }
    }
}

